/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneApplyColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneApplyColumns
extends BaseRuleTest {
    public TestPruneApplyColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testRemoveUnusedApplyNode() {
        this.tester().assertThat((Rule<?>)new PruneApplyColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)subquerySymbol.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(subquerySymbol))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "correlationSymbol")));
    }

    @Test
    public void testRemoveUnreferencedAssignments() {
        this.tester().assertThat((Rule<?>)new PruneApplyColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult1 = p.symbol("in_result_1");
            Symbol inResult2 = p.symbol("in_result_2");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, inResult1}), (PlanNode)p.apply(Assignments.of((Symbol)inResult1, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference()), (Symbol)inResult2, (Expression)new InPredicate((Expression)b.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, b, correlationSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)subquerySymbol.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(subquerySymbol))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"in_result_1", (Object)PlanMatchPattern.expression("in_result_1")), PlanMatchPattern.apply((List<String>)ImmutableList.of((Object)"correlation_symbol"), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"in_result_1", (Object)ExpressionMatcher.inPredicate(new SymbolReference("a"), new SymbolReference("subquery_symbol"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"correlation_symbol", (Object)PlanMatchPattern.expression("correlation_symbol")), PlanMatchPattern.values("a", "b", "correlation_symbol")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values("subquery_symbol")))));
        this.tester().assertThat((Rule<?>)new PruneApplyColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol subquerySymbol1 = p.symbol("subquery_symbol_1");
            Symbol subquerySymbol2 = p.symbol("subquery_symbol_2");
            Symbol inResult1 = p.symbol("in_result_1");
            Symbol inResult2 = p.symbol("in_result_2");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, inResult1}), (PlanNode)p.apply(Assignments.of((Symbol)inResult1, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol1.toSymbolReference()), (Symbol)inResult2, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol2.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)subquerySymbol1.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(subquerySymbol1, subquerySymbol2))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"in_result_1", (Object)PlanMatchPattern.expression("in_result_1")), PlanMatchPattern.apply((List<String>)ImmutableList.of((Object)"correlation_symbol"), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"in_result_1", (Object)ExpressionMatcher.inPredicate(new SymbolReference("a"), new SymbolReference("subquery_symbol_1"))), PlanMatchPattern.values("a", "correlation_symbol"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"subquery_symbol_1", (Object)PlanMatchPattern.expression("subquery_symbol_1")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values("subquery_symbol_1", "subquery_symbol_2"))))));
    }

    @Test
    public void testPruneUnreferencedSubquerySymbol() {
        this.tester().assertThat((Rule<?>)new PruneApplyColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol unreferenced = p.symbol("unreferenced");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{correlationSymbol, inResult}), (PlanNode)p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)unreferenced.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(unreferenced, subquerySymbol))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"correlation_symbol", (Object)PlanMatchPattern.expression("correlation_symbol"), (Object)"in_result", (Object)PlanMatchPattern.expression("in_result")), PlanMatchPattern.apply((List<String>)ImmutableList.of((Object)"correlation_symbol"), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"in_result", (Object)ExpressionMatcher.inPredicate(new SymbolReference("a"), new SymbolReference("subquery_symbol"))), PlanMatchPattern.values("a", "correlation_symbol"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"subquery_symbol", (Object)PlanMatchPattern.expression("subquery_symbol")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values("unreferenced", "subquery_symbol"))))));
    }

    @Test
    public void testPruneUnreferencedInputSymbol() {
        this.tester().assertThat((Rule<?>)new PruneApplyColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol unreferenced = p.symbol("unreferenced");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{correlationSymbol, inResult}), (PlanNode)p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, unreferenced, correlationSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)subquerySymbol.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(subquerySymbol))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"correlation_symbol", (Object)PlanMatchPattern.expression("correlation_symbol"), (Object)"in_result", (Object)PlanMatchPattern.expression("in_result")), PlanMatchPattern.apply((List<String>)ImmutableList.of((Object)"correlation_symbol"), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"in_result", (Object)ExpressionMatcher.inPredicate(new SymbolReference("a"), new SymbolReference("subquery_symbol"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"correlation_symbol", (Object)PlanMatchPattern.expression("correlation_symbol")), PlanMatchPattern.values("a", "unreferenced", "correlation_symbol")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values("subquery_symbol")))));
    }

    @Test
    public void testDoNotPruneUnreferencedUsedCorrelationSymbol() {
        this.tester().assertThat((Rule<?>)new PruneApplyColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, inResult}), (PlanNode)p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)subquerySymbol.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(subquerySymbol))));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPruneUnreferencedCorrelationSymbol() {
        this.tester().assertThat((Rule<?>)new PruneApplyColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, inResult}), (PlanNode)p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), (PlanNode)p.values(subquerySymbol)));
        }).doesNotFire();
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneApplyColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, correlationSymbol, inResult}), (PlanNode)p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)subquerySymbol.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(subquerySymbol))));
        }).doesNotFire();
    }
}

