/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushLimitThroughProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPushLimitThroughProject
extends BaseRuleTest {
    public TestPushLimitThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownLimitNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(new Symbol[0])));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.limit(1L, PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testPushdownLimitWithTiesNNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedB = p.symbol("projectedB");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedB, (Expression)new SymbolReference("b")), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)new ExpressionMatcher("a"), (Object)"projectedB", (Object)new ExpressionMatcher("b")), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testPushdownLimitWithTiesThroughProjectionWithExpression() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedC, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)new ExpressionMatcher("a"), (Object)"projectedC", (Object)new ExpressionMatcher("a + b")), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testDoNotPushdownLimitWithTiesThroughProjectionWithExpression() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)projectedC), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedC, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))), (PlanNode)p.values(a, b)));
        }).doesNotFire();
    }

    @Test
    public void testDoesntPushdownLimitThroughIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testDoesntPushDownLimitThroughExclusiveDereferences() {
        RowType rowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("b"), (Expression)new SubscriptExpression((Expression)a.toSymbolReference(), (Expression)new LongLiteral("1")), (Symbol)p.symbol("c"), (Expression)new SubscriptExpression((Expression)a.toSymbolReference(), (Expression)new LongLiteral("2"))), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testLimitWithPreSortedInputs() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.limit(1L, false, (List<Symbol>)ImmutableList.of((Object)projectedC), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedC, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))), (PlanNode)p.values(a, b)));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of(), true, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedC, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)new ExpressionMatcher("a"), (Object)"projectedC", (Object)new ExpressionMatcher("a + b")), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, (List<String>)ImmutableList.of((Object)"a"), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testPushDownLimitThroughOverlappingDereferences() {
        RowType rowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject(this.tester().getTypeAnalyzer())).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("b"), (Expression)new SubscriptExpression((Expression)a.toSymbolReference(), (Expression)new LongLiteral("1")), (Symbol)p.symbol("c", (Type)rowType), (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("a[1]"), (Object)"c", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.limit(1L, PlanMatchPattern.values("a"))));
    }
}

