/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.SampleApplicationResult;
import io.trino.spi.connector.SampleType;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushSampleIntoTableScan;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPushSampleIntoTableScan
extends BaseRuleTest {
    public TestPushSampleIntoTableScan() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new PushSampleIntoTableScan((Metadata)new TestMetadata(false))).on(p -> p.sample(0.15, SampleNode.Type.SYSTEM, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))).doesNotFire();
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new PushSampleIntoTableScan((Metadata)new TestMetadata(true))).on(p -> p.sample(0.15, SampleNode.Type.SYSTEM, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))).matches(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]));
    }

    private static class TestMetadata
    extends AbstractMockMetadata {
        private final boolean samplePushdown;

        public TestMetadata(boolean samplePushdown) {
            this.samplePushdown = samplePushdown;
        }

        @Override
        public Optional<SampleApplicationResult<TableHandle>> applySample(Session session, TableHandle table, SampleType sampleType, double sampleRatio) {
            if (this.samplePushdown) {
                return Optional.of(new SampleApplicationResult((Object)table, false));
            }
            return Optional.empty();
        }
    }
}

