/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.rule.SimplifyExpressions;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.LogicalExpression;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimplifyExpressions {
    private static final SqlParser SQL_PARSER = new SqlParser();

    @Test
    public void testPushesDownNegations() {
        TestSimplifyExpressions.assertSimplifies("NOT X", "NOT X");
        TestSimplifyExpressions.assertSimplifies("NOT NOT X", "X");
        TestSimplifyExpressions.assertSimplifies("NOT NOT NOT X", "NOT X");
        TestSimplifyExpressions.assertSimplifies("NOT NOT NOT X", "NOT X");
        TestSimplifyExpressions.assertSimplifies("NOT (X > Y)", "X <= Y");
        TestSimplifyExpressions.assertSimplifies("NOT (X > (NOT NOT Y))", "X <= Y");
        TestSimplifyExpressions.assertSimplifies("X > (NOT NOT Y)", "X > Y");
        TestSimplifyExpressions.assertSimplifies("NOT (X AND Y AND (NOT (Z OR V)))", "(NOT X) OR (NOT Y) OR (Z OR V)");
        TestSimplifyExpressions.assertSimplifies("NOT (X OR Y OR (NOT (Z OR V)))", "(NOT X) AND (NOT Y) AND (Z OR V)");
        TestSimplifyExpressions.assertSimplifies("NOT (X OR Y OR (Z OR V))", "(NOT X) AND (NOT Y) AND ((NOT Z) AND (NOT V))");
        TestSimplifyExpressions.assertSimplifies("NOT (X IS DISTINCT FROM Y)", "NOT (X IS DISTINCT FROM Y)");
    }

    @Test
    public void testExtractCommonPredicates() {
        TestSimplifyExpressions.assertSimplifies("X AND Y", "X AND Y");
        TestSimplifyExpressions.assertSimplifies("X OR Y", "X OR Y");
        TestSimplifyExpressions.assertSimplifies("X AND X", "X");
        TestSimplifyExpressions.assertSimplifies("X OR X", "X");
        TestSimplifyExpressions.assertSimplifies("(X OR Y) AND (X OR Y)", "X OR Y");
        TestSimplifyExpressions.assertSimplifies("(A AND V) OR V", "V");
        TestSimplifyExpressions.assertSimplifies("(A OR V) AND V", "V");
        TestSimplifyExpressions.assertSimplifies("(A OR B OR C) AND (A OR B)", "A OR B");
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (A AND B AND C)", "A AND B");
        TestSimplifyExpressions.assertSimplifies("I = ((A OR B) AND (A OR B OR C))", "I = (A OR B)");
        TestSimplifyExpressions.assertSimplifies("(X OR Y) AND (X OR Z)", "(X OR Y) AND (X OR Z)");
        TestSimplifyExpressions.assertSimplifies("(X AND Y AND V) OR (X AND Y AND Z)", "(X AND Y) AND (V OR Z)");
        TestSimplifyExpressions.assertSimplifies("((X OR Y OR V) AND (X OR Y OR Z)) = I", "((X OR Y) OR (V AND Z)) = I");
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND V) OR ((X OR V) AND V)", "V");
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND X) OR ((X OR V) AND V)", "X OR V");
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND Z) OR ((X OR V) AND V)", "(X OR V) AND (Z OR V)");
        TestSimplifyExpressions.assertSimplifies("X AND ((Y AND Z) OR (Y AND V) OR (Y AND X))", "X AND Y AND (Z OR V OR X)");
        TestSimplifyExpressions.assertSimplifies("(A AND B AND C AND D) OR (A AND B AND E) OR (A AND F)", "A AND ((B AND C AND D) OR (B AND E) OR F)");
        TestSimplifyExpressions.assertSimplifies("((A AND B) OR (A AND C)) AND D", "A AND (B OR C) AND D");
        TestSimplifyExpressions.assertSimplifies("((A OR B) AND (A OR C)) OR D", "(A OR B OR D) AND (A OR C OR D)");
        TestSimplifyExpressions.assertSimplifies("(((A AND B) OR (A AND C)) AND D) OR E", "(A OR E) AND (B OR C OR E) AND (D OR E)");
        TestSimplifyExpressions.assertSimplifies("(((A OR B) AND (A OR C)) OR D) AND E", "(A OR (B AND C) OR D) AND E");
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (C AND D)", "(A OR C) AND (A OR D) AND (B OR C) AND (B OR D)");
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (C AND D) OR (E AND F)", "(A AND B) OR (C AND D) OR (E AND F)");
        TestSimplifyExpressions.assertSimplifies("(A1 AND A2) OR (A3 AND A4) OR (A5 AND A6) OR (A7 AND A8) OR (A9 AND A10) OR (A11 AND A12) OR (A13 AND A14) OR (A15 AND A16) OR (A17 AND A18) OR (A19 AND A20) OR (A21 AND A22) OR (A23 AND A24) OR (A25 AND A26) OR (A27 AND A28) OR (A29 AND A30) OR (A31 AND A32) OR (A33 AND A34) OR (A35 AND A36) OR (A37 AND A38) OR (A39 AND A40) OR (A41 AND A42) OR (A43 AND A44) OR (A45 AND A46) OR (A47 AND A48) OR (A49 AND A50) OR (A51 AND A52) OR (A53 AND A54) OR (A55 AND A56) OR (A57 AND A58) OR (A59 AND A60)", "(A1 AND A2) OR (A3 AND A4) OR (A5 AND A6) OR (A7 AND A8) OR (A9 AND A10) OR (A11 AND A12) OR (A13 AND A14) OR (A15 AND A16) OR (A17 AND A18) OR (A19 AND A20) OR (A21 AND A22) OR (A23 AND A24) OR (A25 AND A26) OR (A27 AND A28) OR (A29 AND A30) OR (A31 AND A32) OR (A33 AND A34) OR (A35 AND A36) OR (A37 AND A38) OR (A39 AND A40) OR (A41 AND A42) OR (A43 AND A44) OR (A45 AND A46) OR (A47 AND A48) OR (A49 AND A50) OR (A51 AND A52) OR (A53 AND A54) OR (A55 AND A56) OR (A57 AND A58) OR (A59 AND A60)");
    }

    @Test
    public void testMultipleNulls() {
        TestSimplifyExpressions.assertSimplifies("null AND null AND null AND false", "false");
        TestSimplifyExpressions.assertSimplifies("null AND null AND null AND B1", "null AND B1");
        TestSimplifyExpressions.assertSimplifies("null OR null OR null OR true", "true");
        TestSimplifyExpressions.assertSimplifies("null OR null OR null OR B1", "null OR B1");
    }

    @Test
    public void testCastBigintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(12300000000 AS varchar(11))", "'12300000000'");
        TestSimplifyExpressions.assertSimplifies("CAST(-12300000000 AS varchar(50))", "CAST('-12300000000' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(12300000000 AS varchar(3))", "CAST(12300000000 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(-12300000000 AS varchar(3))", "CAST(-12300000000 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(12300000000 AS varchar(3)) = '12300000000'", "CAST(12300000000 AS varchar(3)) = '12300000000'");
    }

    @Test
    public void testCastIntegerToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(1234 AS varchar(4))", "'1234'");
        TestSimplifyExpressions.assertSimplifies("CAST(-1234 AS varchar(50))", "CAST('-1234' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(1234 AS varchar(3))", "CAST(1234 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(-1234 AS varchar(3))", "CAST(-1234 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(1234 AS varchar(3)) = '1234'", "CAST(1234 AS varchar(3)) = '1234'");
    }

    @Test
    public void testCastSmallintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(SMALLINT '1234' AS varchar(4))", "'1234'");
        TestSimplifyExpressions.assertSimplifies("CAST(SMALLINT '-1234' AS varchar(50))", "CAST('-1234' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(SMALLINT '1234' AS varchar(3))", "CAST(SMALLINT '1234' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(SMALLINT '-1234' AS varchar(3))", "CAST(SMALLINT '-1234' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(SMALLINT '1234' AS varchar(3)) = '1234'", "CAST(SMALLINT '1234' AS varchar(3)) = '1234'");
    }

    @Test
    public void testCastTinyintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(TINYINT '123' AS varchar(3))", "'123'");
        TestSimplifyExpressions.assertSimplifies("CAST(TINYINT '-123' AS varchar(50))", "CAST('-123' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(TINYINT '123' AS varchar(2))", "CAST(TINYINT '123' AS varchar(2))");
        TestSimplifyExpressions.assertSimplifies("CAST(TINYINT '-123' AS varchar(2))", "CAST(TINYINT '-123' AS varchar(2))");
        TestSimplifyExpressions.assertSimplifies("CAST(TINYINT '123' AS varchar(2)) = '123'", "CAST(TINYINT '123' AS varchar(2)) = '123'");
    }

    @Test
    public void testCastShortDecimalToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '12.4' AS varchar(4))", "'12.4'");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '-12.4' AS varchar(50))", "CAST('-12.4' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '12.4' AS varchar(3))", "CAST(DECIMAL '12.4' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '-12.4' AS varchar(3))", "CAST(DECIMAL '-12.4' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '12.4' AS varchar(3)) = '12.4'", "CAST(DECIMAL '12.4' AS varchar(3)) = '12.4'");
    }

    @Test
    public void testCastLongDecimalToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '100000000000000000.1' AS varchar(20))", "'100000000000000000.1'");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '-100000000000000000.1' AS varchar(50))", "CAST('-100000000000000000.1' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '100000000000000000.1' AS varchar(3))", "CAST(DECIMAL '100000000000000000.1' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '-100000000000000000.1' AS varchar(3))", "CAST(DECIMAL '-100000000000000000.1' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '100000000000000000.1' AS varchar(3)) = '100000000000000000.1'", "CAST(DECIMAL '100000000000000000.1' AS varchar(3)) = '100000000000000000.1'");
    }

    @Test
    public void testCastDoubleToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(0e0 AS varchar(3))", "'0.0'");
        TestSimplifyExpressions.assertSimplifies("CAST(-0e0 AS varchar(4))", "'-0.0'");
        TestSimplifyExpressions.assertSimplifies("CAST(0e0 / 0e0 AS varchar(3))", "'NaN'");
        TestSimplifyExpressions.assertSimplifies("CAST(DOUBLE 'Infinity' AS varchar(8))", "'Infinity'");
        TestSimplifyExpressions.assertSimplifies("CAST(12e2 AS varchar(6))", "'1200.0'");
        TestSimplifyExpressions.assertSimplifies("CAST(-12e2 AS varchar(50))", "CAST('-1200.0' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(12e2 AS varchar(3))", "CAST(12e2 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(-12e2 AS varchar(3))", "CAST(-12e2 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DOUBLE 'NaN' AS varchar(2))", "CAST(DOUBLE 'NaN' AS varchar(2))");
        TestSimplifyExpressions.assertSimplifies("CAST(DOUBLE 'Infinity' AS varchar(7))", "CAST(DOUBLE 'Infinity' AS varchar(7))");
        TestSimplifyExpressions.assertSimplifies("CAST(12e2 AS varchar(3)) = '1200.0'", "CAST(12e2 AS varchar(3)) = '1200.0'");
    }

    @Test
    public void testCastRealToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '0e0' AS varchar(3))", "'0.0'");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '-0e0' AS varchar(4))", "'-0.0'");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '0e0' / REAL '0e0' AS varchar(3))", "'NaN'");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL 'Infinity' AS varchar(8))", "'Infinity'");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '12e2' AS varchar(6))", "'1200.0'");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '-12e2' AS varchar(50))", "CAST('-1200.0' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '12e2' AS varchar(3))", "CAST(REAL '12e2' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '-12e2' AS varchar(3))", "CAST(REAL '-12e2' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL 'NaN' AS varchar(2))", "CAST(REAL 'NaN' AS varchar(2))");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL 'Infinity' AS varchar(7))", "CAST(REAL 'Infinity' AS varchar(7))");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '12e2' AS varchar(3)) = '1200.0'", "CAST(REAL '12e2' AS varchar(3)) = '1200.0'");
    }

    private static void assertSimplifies(String expression, String expected) {
        ParsingOptions parsingOptions = new ParsingOptions();
        Expression actualExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expression, parsingOptions));
        Expression expectedExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expected, parsingOptions));
        Expression rewritten = SimplifyExpressions.rewrite((Expression)actualExpression, (Session)SessionTestUtils.TEST_SESSION, (SymbolAllocator)new SymbolAllocator(TestSimplifyExpressions.booleanSymbolTypeMapFor(actualExpression)), (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT));
        Assert.assertEquals((Object)TestSimplifyExpressions.normalize(rewritten), (Object)TestSimplifyExpressions.normalize(expectedExpression));
    }

    private static Map<Symbol, Type> booleanSymbolTypeMapFor(Expression expression) {
        return SymbolsExtractor.extractUnique((Expression)expression).stream().collect(Collectors.toMap(symbol -> symbol, symbol -> BooleanType.BOOLEAN));
    }

    @Test
    public void testPushesDownNegationsNumericTypes() {
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (I1 = I2)", "I1 <> I2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (I1 > I2)", "I1 <= I2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((I1 = I2) OR (I3 > I4))", "I1 <> I2 AND I3 <= I4");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (NOT NOT (I1 = I2) OR NOT(I3 > I4))", "I1 <> I2 AND I3 > I4");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((I1 = I2) OR (B1 AND B2) OR NOT (B3 OR B4))", "I1 <> I2 AND (NOT B1 OR NOT B2) AND (B3 OR B4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (I1 IS DISTINCT FROM I2)", "NOT (I1 IS DISTINCT FROM I2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 = D2)", "D1 <> D2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 <> D2)", "D1 = D2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 = R2)", "R1 <> R2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 <> R2)", "R1 = R2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 IS DISTINCT FROM D2)", "NOT (D1 IS DISTINCT FROM D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 IS DISTINCT FROM R2)", "NOT (R1 IS DISTINCT FROM R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 > D2)", "NOT (D1 > D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 >= D2)", "NOT (D1 >= D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 < D2)", "NOT (D1 < D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 <= D2)", "NOT (D1 <= D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 > R2)", "NOT (R1 > R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 >= R2)", "NOT (R1 >= R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 < R2)", "NOT (R1 < R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 <= R2)", "NOT (R1 <= R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (D1 <= D2)", "NOT (D1 <= D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT NOT (D1 <= D2)", "D1 <= D2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (R1 > R2)", "NOT (R1 > R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT NOT (R1 > R2)", "R1 > R2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((I1 = I2) OR (D1 > D2))", "I1 <> I2 AND NOT (D1 > D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (NOT NOT (R1 < R2) OR NOT(I1 > I2))", "NOT (R1 < R2) AND I1 > I2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((D1 > D2) OR (B1 AND B2) OR NOT (B3 OR B4))", "NOT (D1 > D2) AND (NOT B1 OR NOT B2) AND (B3 OR B4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (((D1 > D2) AND (I1 < I2)) OR ((B1 AND B2) AND (R1 > R2)))", "(NOT (D1 > D2) OR I1 >= I2) AND ((NOT B1 OR NOT B2) OR NOT (R1 > R2))");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("IF (NOT (I1 < I2), D1, D2)", "IF (I1 >= I2, D1, D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 > 1)", "NOT (D1 > 1)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (1 > D2)", "NOT (1 > D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 > 1)", "NOT (R1 > 1)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (1 > R2)", "NOT (1 > R2)");
    }

    @Test
    public void testRewriteOrExpression() {
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 = 2 ", "I1 IN (1, 2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 = 2 OR I1 IN (3, 4)", "I1 IN (3, 4) OR I1 IN (1, 2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 = 2 OR I1 = I2", "I1 IN (1, 2, I2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 = 2 OR I2 = 3 OR I2 = 4", "I1 IN (1, 2) OR I2 IN (3, 4)");
    }

    private static void assertSimplifiesNumericTypes(String expression, String expected) {
        ParsingOptions parsingOptions = new ParsingOptions();
        Expression actualExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expression, parsingOptions));
        Expression expectedExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expected, parsingOptions));
        Expression rewritten = SimplifyExpressions.rewrite((Expression)actualExpression, (Session)SessionTestUtils.TEST_SESSION, (SymbolAllocator)new SymbolAllocator(TestSimplifyExpressions.numericAndBooleanSymbolTypeMapFor(actualExpression)), (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT));
        Assert.assertEquals((Object)TestSimplifyExpressions.normalize(rewritten), (Object)TestSimplifyExpressions.normalize(expectedExpression));
    }

    private static Map<Symbol, Type> numericAndBooleanSymbolTypeMapFor(Expression expression) {
        return SymbolsExtractor.extractUnique((Expression)expression).stream().collect(Collectors.toMap(symbol -> symbol, symbol -> {
            switch (symbol.getName().charAt(0)) {
                case 'I': {
                    return IntegerType.INTEGER;
                }
                case 'D': {
                    return DoubleType.DOUBLE;
                }
                case 'R': {
                    return RealType.REAL;
                }
                case 'B': {
                    return BooleanType.BOOLEAN;
                }
            }
            return BigintType.BIGINT;
        }));
    }

    private static Expression normalize(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new NormalizeExpressionRewriter(), (Expression)expression);
    }

    private static class NormalizeExpressionRewriter
    extends ExpressionRewriter<Void> {
        private NormalizeExpressionRewriter() {
        }

        public Expression rewriteLogicalExpression(LogicalExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List predicates = ExpressionUtils.extractPredicates((LogicalExpression.Operator)node.getOperator(), (Expression)node).stream().map(p -> treeRewriter.rewrite(p, (Object)context)).sorted(Comparator.comparing(Expression::toString)).collect(Collectors.toList());
            return ExpressionUtils.logicalExpression((LogicalExpression.Operator)node.getOperator(), predicates);
        }

        public Expression rewriteCast(Cast node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            return new Cast(node.getExpression(), node.getType(), node.isSafe(), false);
        }
    }
}

