/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.type.Type;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PatternRecognitionExpressionRewriter;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.SkipTo;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PatternRecognitionBuilder {
    private PlanNode source;
    private List<Symbol> partitionBy = ImmutableList.of();
    private Optional<OrderingScheme> orderBy = Optional.empty();
    private final Map<Symbol, WindowNode.Function> windowFunctions = new HashMap<Symbol, WindowNode.Function>();
    private final Map<Symbol, Map.Entry<String, Type>> measures = new HashMap<Symbol, Map.Entry<String, Type>>();
    private Optional<WindowNode.Frame> commonBaseFrame = Optional.empty();
    private PatternRecognitionRelation.RowsPerMatch rowsPerMatch = PatternRecognitionRelation.RowsPerMatch.ONE;
    private Optional<IrLabel> skipToLabel = Optional.empty();
    private SkipTo.Position skipToPosition = SkipTo.Position.PAST_LAST;
    private boolean initial = true;
    private IrRowPattern pattern;
    private final Map<IrLabel, Set<IrLabel>> subsets = new HashMap<IrLabel, Set<IrLabel>>();
    private final Map<IrLabel, String> variableDefinitionsBySql = new HashMap<IrLabel, String>();
    private final Map<IrLabel, Expression> variableDefinitionsByExpression = new HashMap<IrLabel, Expression>();

    public PatternRecognitionBuilder source(PlanNode source) {
        this.source = source;
        return this;
    }

    public PatternRecognitionBuilder partitionBy(List<Symbol> partitionBy) {
        this.partitionBy = partitionBy;
        return this;
    }

    public PatternRecognitionBuilder orderBy(OrderingScheme orderingScheme) {
        this.orderBy = Optional.of(orderingScheme);
        return this;
    }

    public PatternRecognitionBuilder addWindowFunction(Symbol symbol, WindowNode.Function function) {
        this.windowFunctions.put(symbol, function);
        return this;
    }

    public PatternRecognitionBuilder addMeasure(Symbol symbol, String expression, Type type) {
        this.measures.put(symbol, new AbstractMap.SimpleEntry<String, Type>(expression, type));
        return this;
    }

    public PatternRecognitionBuilder frame(WindowNode.Frame frame) {
        this.commonBaseFrame = Optional.of(frame);
        return this;
    }

    public PatternRecognitionBuilder rowsPerMatch(PatternRecognitionRelation.RowsPerMatch rowsPerMatch) {
        this.rowsPerMatch = rowsPerMatch;
        return this;
    }

    public PatternRecognitionBuilder skipTo(SkipTo.Position position, IrLabel label) {
        this.skipToPosition = position;
        this.skipToLabel = Optional.of(label);
        return this;
    }

    public PatternRecognitionBuilder skipTo(SkipTo.Position position) {
        this.skipToPosition = position;
        return this;
    }

    public PatternRecognitionBuilder seek() {
        this.initial = false;
        return this;
    }

    public PatternRecognitionBuilder pattern(IrRowPattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public PatternRecognitionBuilder addSubset(IrLabel name, Set<IrLabel> elements) {
        this.subsets.put(name, elements);
        return this;
    }

    public PatternRecognitionBuilder addVariableDefinition(IrLabel name, String expression) {
        this.variableDefinitionsBySql.put(name, expression);
        return this;
    }

    public PatternRecognitionBuilder addVariableDefinition(IrLabel name, Expression expression) {
        this.variableDefinitionsByExpression.put(name, expression);
        return this;
    }

    public PatternRecognitionNode build(PlanNodeIdAllocator idAllocator) {
        ImmutableMap.Builder variableDefinitions = ImmutableMap.builder().putAll((Map)this.variableDefinitionsBySql.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> PatternRecognitionExpressionRewriter.rewrite((String)entry.getValue(), this.subsets)))).putAll((Map)this.variableDefinitionsByExpression.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> PatternRecognitionExpressionRewriter.rewrite((Expression)entry.getValue(), this.subsets))));
        return new PatternRecognitionNode(idAllocator.getNextId(), this.source, new WindowNode.Specification(this.partitionBy, this.orderBy), Optional.empty(), (Set)ImmutableSet.of(), 0, this.windowFunctions, (Map)this.measures.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.measure((Map.Entry)entry.getValue()))), this.commonBaseFrame, this.rowsPerMatch, this.skipToLabel, this.skipToPosition, this.initial, this.pattern, this.subsets, (Map)variableDefinitions.build());
    }

    private PatternRecognitionNode.Measure measure(Map.Entry<String, Type> entry) {
        return new PatternRecognitionNode.Measure(PatternRecognitionExpressionRewriter.rewrite(entry.getKey(), this.subsets), entry.getValue());
    }
}

