/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestEliminateCrossJoins
extends BasePlanTest {
    private static final PlanMatchPattern ORDERS_TABLESCAN = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"));
    private static final PlanMatchPattern ORDERS_WITH_SHIPPRIORITY_TABLESCAN = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey", (Object)"O_SHIPPRIORITY", (Object)"shippriority"));
    private static final PlanMatchPattern PART_TABLESCAN = PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"P_PARTKEY", (Object)"partkey"));
    private static final PlanMatchPattern PART_WITH_NAME_TABLESCAN = PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"P_PARTKEY", (Object)"partkey", (Object)"P_NAME", (Object)"name"));
    private static final PlanMatchPattern LINEITEM_TABLESCAN = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_PARTKEY", (Object)"partkey", (Object)"L_ORDERKEY", (Object)"orderkey"));
    private static final PlanMatchPattern LINEITEM_WITH_RETURNFLAG_TABLESCAN = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_PARTKEY", (Object)"partkey", (Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_RETURNFLAG", (Object)"returnflag"));
    private static final PlanMatchPattern LINEITEM_WITH_COMMENT_TABLESCAN = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_PARTKEY", (Object)"partkey", (Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_COMMENT", (Object)"comment"));

    public TestEliminateCrossJoins() {
        super((Map<String, String>)ImmutableMap.of((Object)"join_reordering_strategy", (Object)"ELIMINATE_CROSS_JOINS"));
    }

    @Test
    public void testEliminateSimpleCrossJoin() {
        this.assertPlan("SELECT * FROM part p, orders o, lineitem l WHERE p.partkey = l.partkey AND l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("L_ORDERKEY", "O_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("P_PARTKEY", "L_PARTKEY")), PlanMatchPattern.anyTree(PART_TABLESCAN), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN))), PlanMatchPattern.anyTree(ORDERS_TABLESCAN))));
    }

    @Test
    public void testDoesNotReorderJoinsWhenNoCrossJoinPresent() {
        this.assertPlan("SELECT o1.orderkey, o2.custkey, o3.orderstatus, o4.totalprice FROM (orders o1 JOIN orders o2 ON o1.orderkey = o2.orderkey) JOIN (orders o3 JOIN orders o4 ON o3.orderkey = o4.orderkey) ON o1.orderkey = o3.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O1_ORDERKEY", "O3_ORDERKEY")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O1_ORDERKEY", "O2_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O1_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O2_ORDERKEY", (Object)"orderkey", (Object)"O2_CUSTKEY", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O3_ORDERKEY", "O4_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O3_ORDERKEY", (Object)"orderkey", (Object)"O3_ORDERSTATUS", (Object)"orderstatus"))), PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O4_ORDERKEY", (Object)"orderkey", (Object)"O4_totalprice", (Object)"totalprice"))))))));
    }

    @Test
    public void testGiveUpOnCrossJoin() {
        this.assertPlan("SELECT o.orderkey FROM part p, orders o, lineitem l WHERE l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_ORDERKEY", "L_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("part"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))));
    }

    @Test
    public void testEliminateCrossJoinWithNonEqualityCondition() {
        this.assertPlan("SELECT o.orderkey FROM part p, orders o, lineitem l WHERE p.partkey = l.partkey AND l.orderkey = o.orderkey AND p.partkey <> o.orderkey AND p.name < l.comment", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("L_ORDERKEY", "O_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("P_PARTKEY", "L_PARTKEY")), Optional.of("P_NAME < cast(L_COMMENT AS varchar(55))"), PlanMatchPattern.anyTree(PART_WITH_NAME_TABLESCAN), PlanMatchPattern.anyTree(PlanMatchPattern.filter("L_PARTKEY <> L_ORDERKEY", LINEITEM_WITH_COMMENT_TABLESCAN)))), PlanMatchPattern.anyTree(ORDERS_TABLESCAN))));
    }

    @Test
    public void testEliminateCrossJoinPreserveFilters() {
        this.assertPlan("SELECT o.orderkey FROM part p, orders o, lineitem l WHERE p.partkey = l.partkey AND l.orderkey = o.orderkey AND l.returnflag = 'R' AND shippriority >= 10", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("L_ORDERKEY", "O_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("P_PARTKEY", "L_PARTKEY")), PlanMatchPattern.anyTree(PART_TABLESCAN), PlanMatchPattern.anyTree(PlanMatchPattern.filter("L_RETURNFLAG = 'R'", LINEITEM_WITH_RETURNFLAG_TABLESCAN)))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_SHIPPRIORITY >= 10", ORDERS_WITH_SHIPPRIORITY_TABLESCAN)))));
    }
}

