/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.server.ExpressionSerialization;
import io.trino.server.SliceSerialization;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.WindowFrame;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestWindowNode {
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();
    private SymbolAllocator symbolAllocator;
    private ValuesNode sourceNode;
    private Symbol columnA;
    private Symbol columnB;
    private Symbol columnC;
    private final ObjectMapper objectMapper;

    public TestWindowNode() {
        SqlParser sqlParser = new SqlParser();
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonSerializers((Map)ImmutableMap.of(Slice.class, (Object)new SliceSerialization.SliceSerializer(), Expression.class, (Object)new ExpressionSerialization.ExpressionSerializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(this.functionResolution.getPlannerContext().getTypeManager()), Slice.class, (Object)new SliceSerialization.SliceDeserializer(), Expression.class, (Object)new ExpressionSerialization.ExpressionDeserializer(sqlParser), TypeSignature.class, (Object)new TypeSignatureDeserializer()));
        provider.setKeyDeserializers((Map)ImmutableMap.of(TypeSignature.class, (Object)new TypeSignatureKeyDeserializer()));
        this.objectMapper = provider.get();
    }

    @BeforeClass
    public void setUp() {
        this.symbolAllocator = new SymbolAllocator();
        this.columnA = this.symbolAllocator.newSymbol("a", (Type)BigintType.BIGINT);
        this.columnB = this.symbolAllocator.newSymbol("b", (Type)BigintType.BIGINT);
        this.columnC = this.symbolAllocator.newSymbol("c", (Type)BigintType.BIGINT);
        this.sourceNode = new ValuesNode(TestWindowNode.newId(), (List)ImmutableList.of((Object)this.columnA, (Object)this.columnB, (Object)this.columnC), (List)ImmutableList.of());
    }

    @Test
    public void testSerializationRoundtrip() throws Exception {
        Symbol windowSymbol = this.symbolAllocator.newSymbol("sum", (Type)BigintType.BIGINT);
        ResolvedFunction resolvedFunction = this.functionResolution.resolveFunction(QualifiedName.of((String)"sum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        WindowNode.Frame frame = new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        PlanNodeId id = TestWindowNode.newId();
        WindowNode.Specification specification = new WindowNode.Specification((List)ImmutableList.of((Object)this.columnA), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)this.columnB), (Map)ImmutableMap.of((Object)this.columnB, (Object)SortOrder.ASC_NULLS_FIRST))));
        ImmutableMap functions = ImmutableMap.of((Object)windowSymbol, (Object)new WindowNode.Function(resolvedFunction, (List)ImmutableList.of((Object)this.columnC.toSymbolReference()), frame, false));
        Optional<Symbol> hashSymbol = Optional.of(this.columnB);
        ImmutableSet prePartitionedInputs = ImmutableSet.of((Object)this.columnA);
        WindowNode windowNode = new WindowNode(id, (PlanNode)this.sourceNode, specification, (Map)functions, hashSymbol, (Set)prePartitionedInputs, 0);
        String json = this.objectMapper.writeValueAsString((Object)windowNode);
        WindowNode actualNode = (WindowNode)this.objectMapper.readValue(json, WindowNode.class);
        Assert.assertEquals((Object)actualNode.getId(), (Object)windowNode.getId());
        Assert.assertEquals((Object)actualNode.getSpecification(), (Object)windowNode.getSpecification());
        Assert.assertEquals((Map)actualNode.getWindowFunctions(), (Map)windowNode.getWindowFunctions());
        Assert.assertEquals((Collection)actualNode.getFrames(), (Collection)windowNode.getFrames());
        Assert.assertEquals((Object)actualNode.getHashSymbol(), (Object)windowNode.getHashSymbol());
        Assert.assertEquals((Set)actualNode.getPrePartitionedInputs(), (Set)windowNode.getPrePartitionedInputs());
        Assert.assertEquals((int)actualNode.getPreSortedOrderPrefix(), (int)windowNode.getPreSortedOrderPrefix());
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }
}

