/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCopyAggregationStateInRowPatternMatching {
    private static final String QUERY = "SELECT m.id, m.classy           FROM (VALUES (1), (2), (3)) t(id)                  MATCH_RECOGNIZE (                    ORDER BY id                    MEASURES CLASSIFIER() AS classy                    ALL ROWS PER MATCH                    PATTERN ((A | B)* X)                    %s                 ) AS m";
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testArrayAgg() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(array_agg(CLASSIFIER()), '', '') = 'BAX' "))))).matches("VALUES      (1, VARCHAR 'B'),      (2, 'A'),      (3, 'X') ");
    }

    @Test
    public void testMinByN() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(min_by(CLASSIFIER(), id, 3), '', '') = 'BAX' "))))).matches("VALUES      (1, VARCHAR 'B'),      (2, 'A'),      (3, 'X') ");
    }

    @Test
    public void testMaxByN() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(max_by(CLASSIFIER(), id, 3), '', '') = 'XAB' "))))).matches("VALUES      (1, VARCHAR 'B'),      (2, 'A'),      (3, 'X') ");
    }

    @Test
    public void testMinN() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(min(CLASSIFIER(), 3), '', '') = 'ABX' "))))).matches("VALUES      (1, VARCHAR 'A'),      (2, 'B'),      (3, 'X') ");
    }

    @Test
    public void testMaxN() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(max(CLASSIFIER(), 3), '', '') = 'XBA' "))))).matches("VALUES      (1, VARCHAR 'A'),      (2, 'B'),      (3, 'X') ");
    }

    @Test
    public void testMultimapAgg() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(element_at(multimap_agg(id, CLASSIFIER()), 1), '', '') = 'B' "))))).matches("VALUES      (1, VARCHAR 'B'),      (2, 'A'),      (3, 'X') ");
    }

    @Test
    public void testMapAgg() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS element_at(map_agg(id, CLASSIFIER()), 1) = 'B' "))))).matches("VALUES      (1, VARCHAR 'B'),      (2, 'A'),      (3, 'X') ");
    }

    @Test
    public void testMapUnion() {
        String query = "SELECT m.id, m.classy           FROM (VALUES ('B'), ('C'), ('D')) t(id)                  MATCH_RECOGNIZE (                    ORDER BY id                    MEASURES CLASSIFIER() AS classy                    ALL ROWS PER MATCH                    PATTERN ((A | B)* X)                    %s                 ) AS m";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(query, "DEFINE X AS element_at(map_union(MAP(ARRAY[id], ARRAY[id])), 'B') = FIRST(CLASSIFIER()) "))))).matches("VALUES      ('B', VARCHAR 'B'),      ('C', 'A'),      ('D', 'X') ");
    }

    @Test
    public void testDecimalAvg() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS avg(CAST(B.id AS decimal(2, 1))) = 1e0 "))))).matches("VALUES      (1, VARCHAR 'B'),      (2, 'A'),      (3, 'X') ");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS avg(CAST(B.id AS decimal(30, 20))) = 1e0 "))))).matches("VALUES      (1, VARCHAR 'B'),      (2, 'A'),      (3, 'X') ");
    }

    @Test
    public void testDecimalSum() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS sum(CAST(B.id AS decimal(2, 1))) = 1.0 "))))).matches("VALUES      (1, VARCHAR 'B'),      (2, 'A'),      (3, 'X') ");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS sum(CAST(B.id AS decimal(30, 20))) = 1.0 "))))).matches("VALUES      (1, VARCHAR 'B'),      (2, 'A'),      (3, 'X') ");
    }
}

