/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.FeaturesConfig;
import io.trino.SystemSessionProperties;
import io.trino.SystemSessionPropertiesProvider;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.memory.MemoryManagerConfig;
import io.trino.memory.NodeMemoryConfig;
import io.trino.metadata.SessionPropertyManager;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestFilterHideInacessibleColumnsSession {
    @Test
    public void testDisableWhenEnabledByDefault() {
        FeaturesConfig featuresConfig = new FeaturesConfig();
        featuresConfig.setHideInaccesibleColumns(true);
        SessionPropertyManager sessionPropertyManager = new SessionPropertyManager((SystemSessionPropertiesProvider)new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), featuresConfig, new NodeMemoryConfig(), new DynamicFilterConfig(), new NodeSchedulerConfig()));
        Assertions.assertThatThrownBy(() -> sessionPropertyManager.validateSystemSessionProperty("hide_inaccessible_columns", "false")).hasMessage("hide_inaccessible_columns cannot be disabled with session property when it was enabled with configuration");
    }

    @Test
    public void testEnableWhenAlreadyEnabledByDefault() {
        FeaturesConfig featuresConfig = new FeaturesConfig();
        featuresConfig.setHideInaccesibleColumns(true);
        SessionPropertyManager sessionPropertyManager = new SessionPropertyManager((SystemSessionPropertiesProvider)new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), featuresConfig, new NodeMemoryConfig(), new DynamicFilterConfig(), new NodeSchedulerConfig()));
        Assertions.assertThatNoException().isThrownBy(() -> sessionPropertyManager.validateSystemSessionProperty("hide_inaccessible_columns", "true"));
    }

    @Test
    public void testDisableWhenAlreadyDisabledByDefault() {
        FeaturesConfig featuresConfig = new FeaturesConfig();
        SessionPropertyManager sessionPropertyManager = new SessionPropertyManager((SystemSessionPropertiesProvider)new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), featuresConfig, new NodeMemoryConfig(), new DynamicFilterConfig(), new NodeSchedulerConfig()));
        Assertions.assertThatNoException().isThrownBy(() -> sessionPropertyManager.validateSystemSessionProperty("hide_inaccessible_columns", "false"));
    }

    @Test
    public void testEnableWhenDisabledByDefault() {
        FeaturesConfig featuresConfig = new FeaturesConfig();
        SessionPropertyManager sessionPropertyManager = new SessionPropertyManager((SystemSessionPropertiesProvider)new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), featuresConfig, new NodeMemoryConfig(), new DynamicFilterConfig(), new NodeSchedulerConfig()));
        Assertions.assertThatNoException().isThrownBy(() -> sessionPropertyManager.validateSystemSessionProperty("hide_inaccessible_columns", "true"));
    }
}

