/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.connector.MockConnectorFactory;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestShowQueries {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)TestingSession.testSessionBuilder().setCatalog("local").setSchema("default").build());
        queryRunner.createCatalog("mock", (ConnectorFactory)MockConnectorFactory.builder().withGetColumns(schemaTableName -> ImmutableList.of((Object)ColumnMetadata.builder().setName("colaa").setType((Type)BigintType.BIGINT).build(), (Object)ColumnMetadata.builder().setName("cola_").setType((Type)BigintType.BIGINT).build(), (Object)ColumnMetadata.builder().setName("colabc").setType((Type)BigintType.BIGINT).build())).withListSchemaNames(session -> ImmutableList.of((Object)"mockschema")).withListTables((session, schemaName) -> ImmutableList.of((Object)new SchemaTableName("mockSchema", "mockTable"))).build(), (Map)ImmutableMap.of());
        queryRunner.getCatalogManager().registerCatalog(TestingSession.createBogusTestingCatalog((String)"testing_catalog"));
        queryRunner.getSessionPropertyManager().addConnectorSessionProperties(new CatalogName("testing_catalog"), List.of());
        this.assertions = new QueryAssertions((QueryRunner)queryRunner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testShowCatalogsLikeWithEscape() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW CATALOGS LIKE 't$_%' ESCAPE ''")).hasMessage("Escape string must be a single character");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW CATALOGS LIKE 't$_%' ESCAPE '$$'")).hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW CATALOGS LIKE '%$_%' ESCAPE '$'")))).matches("VALUES('testing_catalog')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW CATALOGS LIKE '$_%' ESCAPE '$'")))).matches("SELECT 'testing_catalog' WHERE FALSE");
    }

    @Test
    public void testShowFunctionLike() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW FUNCTIONS LIKE 'split%'")))).matches("VALUES (cast('split' AS VARCHAR(30)), cast('array(varchar(x))' AS VARCHAR(28)), cast('varchar(x), varchar(y)' AS VARCHAR(68)), cast('scalar' AS VARCHAR(9)), true, cast('' AS VARCHAR(131))),('split', 'array(varchar(x))', 'varchar(x), varchar(y), bigint', 'scalar', true, ''),('split_part', 'varchar(x)', 'varchar(x), varchar(y), bigint', 'scalar', true, 'Splits a string by a delimiter and returns the specified field (counting from one)'),('split_to_map', 'map(varchar,varchar)', 'varchar, varchar, varchar', 'scalar', true, 'Creates a map using entryDelimiter and keyValueDelimiter'),('split_to_multimap', 'map(varchar,array(varchar))', 'varchar, varchar, varchar', 'scalar', true, 'Creates a multimap by splitting a string into key/value pairs')");
    }

    @Test
    public void testShowFunctionsLikeWithEscape() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW FUNCTIONS LIKE 'split$_to$_%' ESCAPE '$'")))).matches("VALUES (cast('split_to_map' AS VARCHAR(30)), cast('map(varchar,varchar)' AS VARCHAR(28)), cast('varchar, varchar, varchar' AS VARCHAR(68)), cast('scalar' AS VARCHAR(9)), true, cast('Creates a map using entryDelimiter and keyValueDelimiter' AS VARCHAR(131))),('split_to_multimap', 'map(varchar,array(varchar))', 'varchar, varchar, varchar', 'scalar', true, 'Creates a multimap by splitting a string into key/value pairs')");
    }

    @Test
    public void testShowSessionLike() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW SESSION LIKE '%page_row_c%'")))).matches("VALUES (cast('filter_and_project_min_output_page_row_count' as VARCHAR(53)), cast('256' as VARCHAR(14)), cast('256' as VARCHAR(14)), 'integer', cast('Experimental: Minimum output page row count for filter and project operators' as VARCHAR(142)))");
    }

    @Test
    public void testShowSessionLikeWithEscape() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW SESSION LIKE 't$_%' ESCAPE ''")).hasMessage("Escape string must be a single character");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW SESSION LIKE 't$_%' ESCAPE '$$'")).hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW SESSION LIKE '%page$_row$_c%' ESCAPE '$'")))).matches("VALUES (cast('filter_and_project_min_output_page_row_count' as VARCHAR(53)), cast('256' as VARCHAR(14)), cast('256' as VARCHAR(14)), 'integer', cast('Experimental: Minimum output page row count for filter and project operators' as VARCHAR(142)))");
    }

    @Test
    public void testListingEmptyCatalogs() {
        this.assertions.executeExclusively(() -> {
            this.assertions.getQueryRunner().getAccessControl().denyCatalogs(catalog -> false);
            this.assertions.assertQueryReturnsEmptyResult("SHOW CATALOGS");
            this.assertions.getQueryRunner().getAccessControl().reset();
        });
    }

    @Test
    public void testShowColumns() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable")))).matches("VALUES (VARCHAR 'colaa', VARCHAR 'bigint' , VARCHAR '', VARCHAR ''),(VARCHAR 'cola_', VARCHAR 'bigint' , VARCHAR '', VARCHAR ''),(VARCHAR 'colabc', VARCHAR 'bigint' , VARCHAR '', VARCHAR '')");
    }

    @Test
    public void testShowColumnsLike() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable like 'colabc'")))).matches("VALUES (VARCHAR 'colabc', VARCHAR 'bigint' , VARCHAR '', VARCHAR '')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable like 'cola%'")))).matches("VALUES (VARCHAR 'colaa', VARCHAR 'bigint' , VARCHAR '', VARCHAR ''),(VARCHAR 'cola_', VARCHAR 'bigint' , VARCHAR '', VARCHAR ''),(VARCHAR 'colabc', VARCHAR 'bigint' , VARCHAR '', VARCHAR '')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable like 'cola_'")))).matches("VALUES (VARCHAR 'colaa', VARCHAR 'bigint' , VARCHAR '', VARCHAR ''),(VARCHAR 'cola_', VARCHAR 'bigint' , VARCHAR '', VARCHAR '')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 'node%'")))).matches("VALUES (VARCHAR 'node_id', VARCHAR 'varchar' , VARCHAR '', VARCHAR ''),(VARCHAR 'node_version', VARCHAR 'varchar' , VARCHAR '', VARCHAR '')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 'node_id'")))).matches("VALUES (VARCHAR 'node_id', VARCHAR 'varchar' , VARCHAR '', VARCHAR '')");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.assertions.execute("SHOW COLUMNS FROM system.runtime.nodes LIKE ''").getRowCount());
    }

    @Test
    public void testShowColumnsWithLikeWithEscape() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 't$_%' ESCAPE ''")).hasMessage("Escape string must be a single character");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 't$_%' ESCAPE '$$'")).hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable LIKE 'cola$_' ESCAPE '$'")))).matches("VALUES (VARCHAR 'cola_', VARCHAR 'bigint' , VARCHAR '', VARCHAR '')");
    }
}

