/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.MaterializedRow;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestUnwrapCastInComparison {
    private static final List<String> COMPARISON_OPERATORS = Arrays.asList("=", "<>", ">=", ">", "<=", "<", "IS DISTINCT FROM");
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testTinyint() {
        for (Number from : Arrays.asList(null, (byte)-128, 0, 1, (byte)127)) {
            String fromType = "TINYINT";
            for (String operator : COMPARISON_OPERATORS) {
                for (Number to : Arrays.asList(null, -129, (byte)-128, 0, 1, (byte)127, 128)) {
                    this.validate(operator, fromType, from, "SMALLINT", to);
                }
                for (Number to : Arrays.asList(null, -129, (byte)-128, 0, 1, (byte)127, 128)) {
                    this.validate(operator, fromType, from, "INTEGER", to);
                }
                for (Number to : Arrays.asList(null, -129, (byte)-128, 0, 1, (byte)127, 128)) {
                    this.validate(operator, fromType, from, "BIGINT", to);
                }
                for (Number to : Arrays.asList(null, -129, (byte)-128, 0, 1, (byte)127, 128)) {
                    this.validate(operator, fromType, from, "REAL", to);
                }
                for (Number to : Arrays.asList(null, -129, (byte)-128, 0, 1, (byte)127, 128)) {
                    this.validate(operator, fromType, from, "DOUBLE", to);
                }
            }
        }
    }

    @Test
    public void testSmallint() {
        for (Number from : Arrays.asList(null, (short)Short.MIN_VALUE, 0, 1, (short)Short.MAX_VALUE)) {
            String fromType = "SMALLINT";
            for (String operator : COMPARISON_OPERATORS) {
                for (Number to : Arrays.asList(null, -32769, (short)Short.MIN_VALUE, 0, 1, (short)Short.MAX_VALUE, 32768)) {
                    this.validate(operator, fromType, from, "INTEGER", to);
                }
                for (Number to : Arrays.asList(null, -32769, (short)Short.MIN_VALUE, 0, 1, (short)Short.MAX_VALUE, 32768)) {
                    this.validate(operator, fromType, from, "BIGINT", to);
                }
                for (Number to : Arrays.asList(null, -32769, (short)Short.MIN_VALUE, 0, 1, (short)Short.MAX_VALUE, 32768)) {
                    this.validate(operator, fromType, from, "REAL", to);
                }
                for (Number to : Arrays.asList(null, -32769, (short)Short.MIN_VALUE, 0, 1, (short)Short.MAX_VALUE, 32768)) {
                    this.validate(operator, fromType, from, "DOUBLE", to);
                }
            }
        }
    }

    @Test
    public void testInteger() {
        for (Number number : Arrays.asList(null, Integer.MIN_VALUE, 0, 1, Integer.MAX_VALUE)) {
            String fromType = "INTEGER";
            for (String operator : COMPARISON_OPERATORS) {
                for (Number to : Arrays.asList(null, -2147483649L, Integer.MIN_VALUE, 0, 1, Integer.MAX_VALUE, 0x80000000L)) {
                    this.validate(operator, fromType, number, "BIGINT", to);
                }
                for (Number to : Arrays.asList(null, -2147483649L, Integer.MIN_VALUE, 0, 0.1, 0.9, 1, Integer.MAX_VALUE, 0x80000000L)) {
                    this.validate(operator, fromType, number, "DOUBLE", to);
                }
                for (Number to : Arrays.asList(null, -2147483649L, Integer.MIN_VALUE, -16777216L, 0, 0.1, 0.9, 1, 0x400000L, Integer.MAX_VALUE, 0x80000000L)) {
                    this.validate(operator, fromType, number, "REAL", to);
                }
            }
        }
    }

    @Test
    public void testBigint() {
        for (Number from : Arrays.asList(null, Long.MIN_VALUE, 0, 1, Long.MAX_VALUE)) {
            String fromType = "BIGINT";
            for (String operator : COMPARISON_OPERATORS) {
                for (Number to : Arrays.asList(null, Long.MIN_VALUE, -9223372036854775807L, -18014398509481984L, 0, 0.1, 0.9, 1, 0x10000000000000L, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE)) {
                    this.validate(operator, fromType, from, "DOUBLE", to);
                }
                for (Number to : Arrays.asList(null, Long.MIN_VALUE, -9223372036854775807L, -16777216L, 0, 0.1, 0.9, 1, 0x400000L, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE)) {
                    this.validate(operator, fromType, from, "REAL", to);
                }
            }
        }
    }

    @Test
    public void testReal() {
        String fromType = "REAL";
        String toType = "DOUBLE";
        for (String from : TestUnwrapCastInComparison.toLiteral(fromType, Arrays.asList(null, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(-3.4028235E38f), 0, 0.1, 0.9, 1, Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NaN)))) {
            for (String operator : COMPARISON_OPERATORS) {
                for (String to : TestUnwrapCastInComparison.toLiteral(toType, Arrays.asList(null, Double.NEGATIVE_INFINITY, Math.nextDown((double)-1.4E-45f), -1.4E-45f, 0, 0.1, 0.9, 1, 3.4028234663852886E38, Math.nextUp(3.4028234663852886E38), Double.POSITIVE_INFINITY, Double.NaN))) {
                    this.validate(operator, fromType, from, toType, to);
                }
            }
        }
    }

    @Test
    public void testDecimal() {
        ImmutableList values = ImmutableList.of((Object)"-999999999999999", (Object)"999999999999999");
        for (String from : values) {
            for (String operator : COMPARISON_OPERATORS) {
                for (String to : values) {
                    this.validate(operator, "DECIMAL(15, 0)", from, "DOUBLE", Double.valueOf(to));
                }
            }
        }
        values = ImmutableList.of((Object)"-9999999999999999", (Object)"9999999999999999");
        for (String from : values) {
            for (String operator : COMPARISON_OPERATORS) {
                for (String to : values) {
                    this.validate(operator, "DECIMAL(16, 0)", from, "DOUBLE", Double.valueOf(to));
                }
            }
        }
        values = ImmutableList.of((Object)"-999999", (Object)"999999");
        for (String from : values) {
            for (String operator : COMPARISON_OPERATORS) {
                for (String to : values) {
                    this.validate(operator, "DECIMAL(7, 0)", from, "REAL", Double.valueOf(to));
                }
            }
        }
        values = ImmutableList.of((Object)"-9999999", (Object)"9999999");
        for (String from : values) {
            for (String operator : COMPARISON_OPERATORS) {
                for (String to : values) {
                    this.validate(operator, "DECIMAL(8, 0)", from, "REAL", Double.valueOf(to));
                }
            }
        }
    }

    @Test
    public void testVarchar() {
        for (String from : Arrays.asList(null, "''", "'a'", "'b'")) {
            for (String operator : COMPARISON_OPERATORS) {
                for (String to : Arrays.asList(null, "''", "'a'", "'aa'", "'b'", "'bb'")) {
                    this.validate(operator, "VARCHAR(1)", from, "VARCHAR(2)", to);
                }
            }
        }
        for (String operator : COMPARISON_OPERATORS) {
            for (String to : Arrays.asList("'" + "a".repeat(200) + "'", "'" + "b".repeat(200) + "'")) {
                this.validate(operator, "VARCHAR(200)", "'" + "a".repeat(200) + "'", "VARCHAR(300)", to);
            }
        }
    }

    @Test
    public void testCastTimestampToTimestampWithTimeZone() {
        Session session = Session.builder((Session)this.assertions.getDefaultSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Pacific/Apia")).build();
        for (String operator : COMPARISON_OPERATORS) {
            this.validate(session, operator, "timestamp(3)", "TIMESTAMP '2020-07-03 01:23:45.123'", "timestamp(3) with time zone", "TIMESTAMP '2020-07-03 01:23:45 Europe/Warsaw'");
            this.validate(session, operator, "timestamp(3)", "TIMESTAMP '2020-07-03 01:23:45.123'", "timestamp(3) with time zone", "TIMESTAMP '2020-07-03 01:23:45 UTC'");
            this.validate(session, operator, "timestamp(6)", "TIMESTAMP '2020-07-03 01:23:45.123456'", "timestamp(6) with time zone", "TIMESTAMP '2020-07-03 01:23:45 Europe/Warsaw'");
            this.validate(session, operator, "timestamp(6)", "TIMESTAMP '2020-07-03 01:23:45.123456'", "timestamp(6) with time zone", "TIMESTAMP '2020-07-03 01:23:45 UTC'");
            this.validate(session, operator, "timestamp(9)", "TIMESTAMP '2020-07-03 01:23:45.123456789'", "timestamp(9) with time zone", "TIMESTAMP '2020-07-03 01:23:45 Europe/Warsaw'");
            this.validate(session, operator, "timestamp(9)", "TIMESTAMP '2020-07-03 01:23:45.123456789'", "timestamp(9) with time zone", "TIMESTAMP '2020-07-03 01:23:45 UTC'");
            this.validate(session, operator, "timestamp(12)", "TIMESTAMP '2020-07-03 01:23:45.123456789123'", "timestamp(12) with time zone", "TIMESTAMP '2020-07-03 01:23:45 Europe/Warsaw'");
            this.validate(session, operator, "timestamp(12)", "TIMESTAMP '2020-07-03 01:23:45.123456789123'", "timestamp(12) with time zone", "TIMESTAMP '2020-07-03 01:23:45 UTC'");
        }
        List<LocalTime> fromLocalTimes = Arrays.asList(LocalTime.parse("02:59:59.999999999"), LocalTime.parse("03:00:00"), LocalTime.parse("03:00:00.000000001"), LocalTime.parse("03:00:00.000000002"), LocalTime.parse("03:59:59.999999999"), LocalTime.parse("04:00:00"), LocalTime.parse("04:00:00.000000001"), LocalTime.parse("04:00:00.000000002"));
        List<LocalTime> toLocalTimes = Arrays.asList(LocalTime.parse("13:59:59.999999999"), LocalTime.parse("14:00:00"), LocalTime.parse("14:00:00.000000001"), LocalTime.parse("14:00:00.000000002"), LocalTime.parse("14:59:59.999999999"), LocalTime.parse("15:00:00"), LocalTime.parse("15:00:00.000000001"), LocalTime.parse("15:00:00.000000002"));
        for (LocalTime fromLocalTime : fromLocalTimes) {
            for (LocalTime toLocalTime : toLocalTimes) {
                for (int timestampPrecision : Arrays.asList(0, 3, 6, 9, 12)) {
                    for (String operator : COMPARISON_OPERATORS) {
                        this.validate(session, operator, String.format("timestamp(%s)", timestampPrecision), String.format("TIMESTAMP '2017-09-24 %s'", fromLocalTime), String.format("timestamp(%s) with time zone", Math.max(9, timestampPrecision)), String.format("TIMESTAMP '2017-04-01 %s Z'", toLocalTime));
                    }
                }
            }
        }
        fromLocalTimes = Arrays.asList(LocalTime.parse("02:59:59.999999999"), LocalTime.parse("03:00:00"), LocalTime.parse("03:00:00.000000001"), LocalTime.parse("03:00:00.000000002"), LocalTime.parse("03:59:59.999999999"), LocalTime.parse("04:00:00"), LocalTime.parse("04:00:00.000000001"), LocalTime.parse("04:00:00.000000002"));
        toLocalTimes = Arrays.asList(LocalTime.parse("12:59:59.999999999"), LocalTime.parse("13:00:00"), LocalTime.parse("13:00:00.000000001"), LocalTime.parse("13:00:00.000000002"), LocalTime.parse("13:59:59.999999999"), LocalTime.parse("14:00:00"), LocalTime.parse("14:00:00.000000001"), LocalTime.parse("14:00:00.000000002"), LocalTime.parse("14:59:59.999999999"), LocalTime.parse("15:00:00"), LocalTime.parse("15:00:00.000000001"), LocalTime.parse("15:00:00.000000002"));
        for (LocalTime fromLocalTime : fromLocalTimes) {
            for (LocalTime toLocalTime : toLocalTimes) {
                for (int timestampPrecision : Arrays.asList(0, 3, 6, 9, 12)) {
                    for (String operator : COMPARISON_OPERATORS) {
                        this.validate(session, operator, String.format("timestamp(%s)", timestampPrecision), String.format("TIMESTAMP '2017-09-24 %s'", fromLocalTime), String.format("timestamp(%s) with time zone", Math.max(9, timestampPrecision)), String.format("TIMESTAMP '2017-04-01 %s Z'", toLocalTime));
                    }
                }
            }
        }
    }

    private void validate(String operator, String fromType, Object fromValue, String toType, Object toValue) {
        this.validate(this.assertions.getDefaultSession(), operator, fromType, fromValue, toType, toValue);
    }

    private void validate(Session session, String operator, String fromType, Object fromValue, String toType, Object toValue) {
        String query = String.format("SELECT (CAST(v AS %s) %s CAST(%s AS %s)) IS NOT DISTINCT FROM (CAST(%s AS %s) %s CAST(%s AS %s)) FROM (VALUES CAST(%s AS %s)) t(v)", toType, operator, toValue, toType, fromValue, toType, operator, toValue, toType, fromValue, fromType);
        boolean result = (Boolean)((MaterializedRow)this.assertions.execute(session, query).getMaterializedRows().get(0)).getField(0);
        Assertions.assertTrue((boolean)result, (String)("Query evaluated to false: " + query));
    }

    private static List<String> toLiteral(String type, List<Number> values) {
        return (List)values.stream().map(value -> value == null ? "NULL" : type + "'" + value + "'").collect(ImmutableList.toImmutableList());
    }
}

