/*
 * Decompiled with CFR 0.152.
 */
package io.trino.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.SessionTestUtils;
import io.trino.connector.CatalogName;
import io.trino.connector.informationschema.InformationSchemaConnector;
import io.trino.connector.system.SystemConnector;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.CatalogMetadata;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.testing.TestingConnectorContext;
import io.trino.testing.assertions.Assert;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionInfo;
import io.trino.transaction.TransactionManager;
import io.trino.transaction.TransactionManagerConfig;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestTransactionManager {
    private static final String CATALOG = "test_catalog";
    private static final CatalogName CATALOG_NAME = new CatalogName("test_catalog");
    private static final CatalogName SYSTEM_TABLES_ID = CatalogName.createSystemTablesCatalogName((CatalogName)CATALOG_NAME);
    private static final CatalogName INFORMATION_SCHEMA_ID = CatalogName.createInformationSchemaCatalogName((CatalogName)CATALOG_NAME);
    private final ExecutorService finishingExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.finishingExecutor.shutdownNow();
    }

    @Test
    public void testTransactionWorkflow() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            CatalogManager catalogManager = new CatalogManager();
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig(), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)catalogManager, (Executor)this.finishingExecutor);
            Connector c1 = new TpchConnectorFactory().create(CATALOG, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
            TestTransactionManager.registerConnector(catalogManager, transactionManager, CATALOG, CATALOG_NAME, c1);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            org.testng.Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG).get()).getMetadata();
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CATALOG_NAME));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertEquals((Collection)transactionInfo.getCatalogNames(), (Collection)ImmutableList.of((Object)CATALOG_NAME, (Object)INFORMATION_SCHEMA_ID, (Object)SYSTEM_TABLES_ID));
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            MoreFutures.getFutureValue((Future)transactionManager.asyncCommit(transactionId));
            org.testng.Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testAbortedTransactionWorkflow() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            CatalogManager catalogManager = new CatalogManager();
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig(), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)catalogManager, (Executor)this.finishingExecutor);
            Connector c1 = new TpchConnectorFactory().create(CATALOG, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
            TestTransactionManager.registerConnector(catalogManager, transactionManager, CATALOG, CATALOG_NAME, c1);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            org.testng.Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG).get()).getMetadata();
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CATALOG_NAME));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertEquals((Collection)transactionInfo.getCatalogNames(), (Collection)ImmutableList.of((Object)CATALOG_NAME, (Object)INFORMATION_SCHEMA_ID, (Object)SYSTEM_TABLES_ID));
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(transactionId));
            org.testng.Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testFailedTransactionWorkflow() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            CatalogManager catalogManager = new CatalogManager();
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig(), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)catalogManager, (Executor)this.finishingExecutor);
            Connector c1 = new TpchConnectorFactory().create(CATALOG, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
            TestTransactionManager.registerConnector(catalogManager, transactionManager, CATALOG, CATALOG_NAME, c1);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            org.testng.Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG).get()).getMetadata();
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CATALOG_NAME));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertEquals((Collection)transactionInfo.getCatalogNames(), (Collection)ImmutableList.of((Object)CATALOG_NAME, (Object)INFORMATION_SCHEMA_ID, (Object)SYSTEM_TABLES_ID));
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            transactionManager.fail(transactionId);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> transactionManager.getCatalogMetadata(transactionId, CATALOG_NAME)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_ALREADY_ABORTED);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(transactionId));
            org.testng.Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testExpiration() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.MILLISECONDS)).setIdleCheckInterval(new Duration(5.0, TimeUnit.MILLISECONDS)), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)new CatalogManager(), (Executor)this.finishingExecutor);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            org.testng.Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            transactionManager.trySetInactive(transactionId);
            Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> org.testng.Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty()));
        }
    }

    private static void registerConnector(CatalogManager catalogManager, TransactionManager transactionManager, String catalogName, CatalogName catalog, Connector connector) {
        CatalogName systemId = CatalogName.createSystemTablesCatalogName((CatalogName)catalog);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        MetadataManager metadata = MetadataManager.createTestMetadataManager((CatalogManager)catalogManager);
        catalogManager.registerCatalog(new Catalog(catalogName, catalog, "test", connector, Catalog.SecurityManagement.CONNECTOR, CatalogName.createInformationSchemaCatalogName((CatalogName)catalog), (Connector)new InformationSchemaConnector(catalogName, (InternalNodeManager)nodeManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()), systemId, (Connector)new SystemConnector((InternalNodeManager)nodeManager, connector.getSystemTables(), transactionId -> transactionManager.getConnectorTransaction(transactionId, catalog))));
    }

    private static class IdleCheckExecutor
    implements Closeable {
        private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"idle-check"));

        private IdleCheckExecutor() {
        }

        public ScheduledExecutorService getExecutor() {
            return this.executorService;
        }

        @Override
        public void close() {
            this.executorService.shutdownNow();
        }
    }
}

