/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Throwables;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.Convention;
import io.trino.spi.function.FunctionDependency;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestConventionDependencies
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerParametricScalar(RegularConvention.class);
        this.registerParametricScalar(BlockPositionConvention.class);
        this.registerParametricScalar(Add.class);
    }

    @Test
    public void testConventionDependencies() {
        this.assertFunction("regular_convention(1, 1)", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("regular_convention(50, 10)", (Type)IntegerType.INTEGER, 60);
        this.assertFunction("regular_convention(1, 0)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("block_position_convention(ARRAY [1, 2, 3])", (Type)IntegerType.INTEGER, 6);
        this.assertFunction("block_position_convention(ARRAY [25, 0, 5])", (Type)IntegerType.INTEGER, 30);
        this.assertFunction("block_position_convention(ARRAY [56, 275, 36])", (Type)IntegerType.INTEGER, 367);
    }

    @ScalarFunction(value="regular_convention")
    public static final class RegularConvention {
        @SqlType(value="integer")
        public static long testRegularConvention(@FunctionDependency(name="add", argumentTypes={"integer", "integer"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle function, @SqlType(value="integer") long left, @SqlType(value="integer") long right) {
            try {
                return function.invokeExact(left, right);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    @ScalarFunction(value="block_position_convention")
    public static final class BlockPositionConvention {
        @SqlType(value="integer")
        public static long testBlockPositionConvention(@FunctionDependency(name="add", argumentTypes={"integer", "integer"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle function, @SqlType(value="array(integer)") Block array) {
            long sum = 0L;
            for (int i = 0; i < array.getPositionCount(); ++i) {
                try {
                    sum = function.invokeExact(sum, array, i);
                    continue;
                }
                catch (Throwable t) {
                    Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                    Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
                }
            }
            return sum;
        }
    }

    @ScalarFunction(value="add")
    public static final class Add {
        @SqlType(value="integer")
        public static long add(@SqlType(value="integer") long left, @SqlType(value="integer") long right) {
            return Math.addExact((int)left, (int)right);
        }

        @SqlType(value="integer")
        public static long addBlockPosition(@SqlType(value="integer") long first, @BlockPosition @SqlType(value="integer", nativeContainerType=long.class) Block block, @BlockIndex int position) {
            return Math.addExact((int)first, (int)IntegerType.INTEGER.getLong(block, position));
        }
    }
}

