/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.TestingSession;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public class TestDateTimeOperators
extends AbstractTestFunctions {
    private static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin");
    private static final DateTimeZone WEIRD_TIME_ZONE = DateTimeZone.forOffsetHoursMinutes((int)5, (int)9);
    private static final TimeZoneKey WEIRD_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)309L);

    public TestDateTimeOperators() {
        super(TestingSession.testSessionBuilder().setTimeZoneKey(TIME_ZONE_KEY).build());
    }

    @Test
    public void testTimeZoneGap() {
        this.assertFunction("TIMESTAMP '2013-03-31 00:05' + INTERVAL '1' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)1, (int)5, (int)0, (int)0));
        this.session.toConnectorSession();
        this.assertFunction("TIMESTAMP '2013-03-31 00:05' + INTERVAL '2' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)2, (int)5, (int)0, (int)0));
        this.session.toConnectorSession();
        this.assertFunction("TIMESTAMP '2013-03-31 00:05' + INTERVAL '3' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)3, (int)5, (int)0, (int)0));
        this.assertFunction("TIMESTAMP '2013-03-31 04:05' - INTERVAL '3' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)1, (int)5, (int)0, (int)0));
        this.session.toConnectorSession();
        this.assertFunction("TIMESTAMP '2013-03-31 03:05' - INTERVAL '2' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)1, (int)5, (int)0, (int)0));
        this.session.toConnectorSession();
        this.assertFunction("TIMESTAMP '2013-03-31 01:05' - INTERVAL '1' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)3, (int)31, (int)0, (int)5, (int)0, (int)0));
    }

    @Test
    public void testDaylightTimeSaving() {
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '1' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)1, (int)5, (int)0, (int)0));
        this.session.toConnectorSession();
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '2' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)2, (int)5, (int)0, (int)0));
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '3' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)3, (int)5, (int)0, (int)0));
        this.session.toConnectorSession();
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '4' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)4, (int)5, (int)0, (int)0));
        this.assertFunction("TIMESTAMP '2013-10-27 03:05' - INTERVAL '4' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)26, (int)23, (int)5, (int)0, (int)0));
        this.session.toConnectorSession();
        this.assertFunction("TIMESTAMP '2013-10-27 02:05' - INTERVAL '2' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)0, (int)5, (int)0, (int)0));
        this.session.toConnectorSession();
        this.assertFunction("TIMESTAMP '2013-10-27 01:05' - INTERVAL '1' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)0, (int)5, (int)0, (int)0));
        this.assertFunction("TIMESTAMP '2013-10-27 03:05' - INTERVAL '1' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)2, (int)5, (int)0, (int)0));
        this.session.toConnectorSession();
        this.assertFunction("TIMESTAMP '2013-10-27 03:05' - INTERVAL '2' hour", (Type)TimestampType.createTimestampType((int)3), DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)10, (int)27, (int)1, (int)5, (int)0, (int)0));
    }

    @Test
    public void testDatePlusInterval() {
        this.assertFunction("DATE '2001-1-22' + INTERVAL '3' day", (Type)DateType.DATE, TestDateTimeOperators.toDate(new DateTime(2001, 1, 25, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("INTERVAL '3' day + DATE '2001-1-22'", (Type)DateType.DATE, TestDateTimeOperators.toDate(new DateTime(2001, 1, 25, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("DATE '2001-1-22' + INTERVAL '3' month", (Type)DateType.DATE, TestDateTimeOperators.toDate(new DateTime(2001, 4, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("INTERVAL '3' month + DATE '2001-1-22'", (Type)DateType.DATE, TestDateTimeOperators.toDate(new DateTime(2001, 4, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("DATE '2001-1-22' + INTERVAL '3' year", (Type)DateType.DATE, TestDateTimeOperators.toDate(new DateTime(2004, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("INTERVAL '3' year + DATE '2001-1-22'", (Type)DateType.DATE, TestDateTimeOperators.toDate(new DateTime(2004, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertInvalidFunction("DATE '2001-1-22' + INTERVAL '3' hour", "Cannot add hour, minutes or seconds to a date");
        this.assertInvalidFunction("INTERVAL '3' hour + DATE '2001-1-22'", "Cannot add hour, minutes or seconds to a date");
    }

    @Test
    public void testTimestampPlusInterval() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' hour", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)6, (int)4, (int)5, (int)321));
        this.assertFunction("INTERVAL '3' hour + TIMESTAMP '2001-1-22 03:04:05.321'", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)6, (int)4, (int)5, (int)321));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' day", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)25, (int)3, (int)4, (int)5, (int)321));
        this.assertFunction("INTERVAL '3' day + TIMESTAMP '2001-1-22 03:04:05.321'", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)25, (int)3, (int)4, (int)5, (int)321));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' month", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)4, (int)22, (int)3, (int)4, (int)5, (int)321));
        this.assertFunction("INTERVAL '3' month + TIMESTAMP '2001-1-22 03:04:05.321'", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)4, (int)22, (int)3, (int)4, (int)5, (int)321));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' year", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2004, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321));
        this.assertFunction("INTERVAL '3' year + TIMESTAMP '2001-1-22 03:04:05.321'", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2004, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' hour", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' hour + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' day", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 25, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' day + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 25, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' month", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 4, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' month + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 4, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' year", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2004, 1, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' year + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2004, 1, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testDateMinusInterval() {
        this.assertFunction("DATE '2001-1-22' - INTERVAL '3' day", (Type)DateType.DATE, TestDateTimeOperators.toDate(new DateTime(2001, 1, 19, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertInvalidFunction("DATE '2001-1-22' - INTERVAL '3' hour", "Cannot subtract hour, minutes or seconds from a date");
    }

    @Test
    public void testTimestampMinusInterval() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' - INTERVAL '3' day", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)19, (int)3, (int)4, (int)5, (int)321));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' - INTERVAL '3' day", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 19, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' - INTERVAL '3' month", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2000, (int)10, (int)22, (int)3, (int)4, (int)5, (int)321));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' - INTERVAL '3' month", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2000, 10, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testDateToTimestampCoercing() {
        this.assertFunction("date_format(DATE '2013-10-27', '%Y-%m-%d %H:%i:%s')", (Type)VarcharType.VARCHAR, "2013-10-27 00:00:00");
        this.assertFunction("DATE '2013-10-27' = TIMESTAMP '2013-10-27 00:00:00'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2013-10-27' < TIMESTAMP '2013-10-27 00:00:01'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2013-10-27' > TIMESTAMP '2013-10-26 23:59:59'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testDateToTimestampWithZoneCoercing() {
        this.assertFunction("DATE '2013-10-27' = TIMESTAMP '2013-10-27 00:00:00 Europe/Berlin'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2013-10-27' < TIMESTAMP '2013-10-27 00:00:01 Europe/Berlin'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2013-10-27' > TIMESTAMP '2013-10-26 23:59:59 Europe/Berlin'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS DATE) IS DISTINCT FROM CAST(NULL AS DATE)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DATE '2013-10-27' IS DISTINCT FROM TIMESTAMP '2013-10-27 00:00:00'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DATE '2013-10-27' IS DISTINCT FROM TIMESTAMP '2013-10-28 00:00:00'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM DATE '2013-10-27'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2013-10-27' IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testDateCastFromVarchar() {
        this.assertFunction("DATE '2013-02-02'", (Type)DateType.DATE, TestDateTimeOperators.toDate(new DateTime(2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertInvalidFunction("DATE '5881580-07-12'", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to date: 5881580-07-12");
        this.assertInvalidFunction("DATE '392251590-07-12'", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to date: 392251590-07-12");
    }

    private static SqlDate toDate(DateTime dateTime) {
        return new SqlDate((int)TimeUnit.MILLISECONDS.toDays(dateTime.getMillis()));
    }
}

