/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestDecimalCasts
extends AbstractTestFunctions {
    @Test
    public void testBooleanToDecimalCasts() {
        this.assertDecimalFunction("CAST(true AS DECIMAL(2, 0))", TestDecimalCasts.decimal("01"));
        this.assertDecimalFunction("CAST(true AS DECIMAL(3, 1))", TestDecimalCasts.decimal("01.0"));
        this.assertDecimalFunction("CAST(true AS DECIMAL)", TestDecimalCasts.maxPrecisionDecimal(1L));
        this.assertDecimalFunction("CAST(true AS DECIMAL(2))", TestDecimalCasts.decimal("01"));
        this.assertDecimalFunction("CAST(false AS DECIMAL(2, 0))", TestDecimalCasts.decimal("00"));
        this.assertDecimalFunction("CAST(false AS DECIMAL(2))", TestDecimalCasts.decimal("00"));
        this.assertDecimalFunction("CAST(false AS DECIMAL)", TestDecimalCasts.maxPrecisionDecimal(0L));
        this.assertDecimalFunction("CAST(true AS DECIMAL(18, 0))", TestDecimalCasts.decimal("000000000000000001"));
        this.assertDecimalFunction("CAST(false AS DECIMAL(18, 2))", TestDecimalCasts.decimal("0000000000000000.00"));
        this.assertDecimalFunction("CAST(true AS DECIMAL(20, 10))", TestDecimalCasts.decimal("0000000001.0000000000"));
        this.assertDecimalFunction("CAST(false AS DECIMAL(20, 10))", TestDecimalCasts.decimal("0000000000.0000000000"));
        this.assertDecimalFunction("CAST(true as DECIMAL(30, 20))", TestDecimalCasts.decimal("0000000001.00000000000000000000"));
        this.assertDecimalFunction("CAST(false as DECIMAL(30, 20))", TestDecimalCasts.decimal("0000000000.00000000000000000000"));
    }

    @Test
    public void testDecimalToBooleanCasts() {
        this.assertFunction("CAST(DECIMAL '1.1' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(DECIMAL '-1.1' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(DECIMAL '0.0' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(DECIMAL '1234567890.1234567890' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(DECIMAL '-1234567890.1234567890' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(DECIMAL '0.0000000000000000000' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(DECIMAL '00000000000000001.0' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(DECIMAL '000000000000000.000' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(DECIMAL '0000000001.00000000000000000000' as BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(DECIMAL '0000000000.00000000000000000000' as BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBigintToDecimalCasts() {
        this.assertDecimalFunction("CAST(BIGINT '234' AS DECIMAL(4,1))", TestDecimalCasts.decimal("234.0"));
        this.assertDecimalFunction("CAST(BIGINT '234' AS DECIMAL(5,2))", TestDecimalCasts.decimal("234.00"));
        this.assertDecimalFunction("CAST(BIGINT '234' AS DECIMAL(4,0))", TestDecimalCasts.decimal("0234"));
        this.assertDecimalFunction("CAST(BIGINT '-234' AS DECIMAL(4,1))", TestDecimalCasts.decimal("-234.0"));
        this.assertDecimalFunction("CAST(BIGINT '0' AS DECIMAL(4,2))", TestDecimalCasts.decimal("00.00"));
        this.assertDecimalFunction("CAST(BIGINT '12345678901234567' AS DECIMAL(17, 0))", TestDecimalCasts.decimal("12345678901234567"));
        this.assertDecimalFunction("CAST(BIGINT '123456789012345679' AS DECIMAL(18, 0))", TestDecimalCasts.decimal("123456789012345679"));
        this.assertDecimalFunction("CAST(BIGINT '1234567890' AS DECIMAL(20, 10))", TestDecimalCasts.decimal("1234567890.0000000000"));
        this.assertDecimalFunction("CAST(BIGINT '-1234567890' AS DECIMAL(20, 10))", TestDecimalCasts.decimal("-1234567890.0000000000"));
        this.assertDecimalFunction("CAST(BIGINT '1234567890' AS DECIMAL(30, 20))", TestDecimalCasts.decimal("1234567890.00000000000000000000"));
        this.assertDecimalFunction("CAST(BIGINT '-1234567890' AS DECIMAL(30, 20))", TestDecimalCasts.decimal("-1234567890.00000000000000000000"));
        this.assertDecimalFunction("CAST(BIGINT '-1234567' AS DECIMAL(17, 10))", TestDecimalCasts.decimal("-1234567.0000000000"));
        this.assertInvalidCast("CAST(BIGINT '10' AS DECIMAL(38,37))", "Cannot cast BIGINT '10' to DECIMAL(38, 37)");
        this.assertInvalidCast("CAST(BIGINT '1234567890' AS DECIMAL(17,10))", "Cannot cast BIGINT '1234567890' to DECIMAL(17, 10)");
        this.assertInvalidCast("CAST(BIGINT '123' AS DECIMAL(2,1))", "Cannot cast BIGINT '123' to DECIMAL(2, 1)");
        this.assertInvalidCast("CAST(BIGINT '-123' AS DECIMAL(2,1))", "Cannot cast BIGINT '-123' to DECIMAL(2, 1)");
        this.assertInvalidCast("CAST(BIGINT '123456789012345678' AS DECIMAL(17,1))", "Cannot cast BIGINT '123456789012345678' to DECIMAL(17, 1)");
        this.assertInvalidCast("CAST(BIGINT '12345678901' AS DECIMAL(20, 10))", "Cannot cast BIGINT '12345678901' to DECIMAL(20, 10)");
    }

    @Test
    public void testIntegerToDecimalCasts() {
        this.assertDecimalFunction("CAST(INTEGER '234' AS DECIMAL(4,1))", TestDecimalCasts.decimal("234.0"));
        this.assertDecimalFunction("CAST(INTEGER '234' AS DECIMAL(5,2))", TestDecimalCasts.decimal("234.00"));
        this.assertDecimalFunction("CAST(INTEGER '234' AS DECIMAL(4,0))", TestDecimalCasts.decimal("0234"));
        this.assertDecimalFunction("CAST(INTEGER '-234' AS DECIMAL(4,1))", TestDecimalCasts.decimal("-234.0"));
        this.assertDecimalFunction("CAST(INTEGER '0' AS DECIMAL(4,2))", TestDecimalCasts.decimal("00.00"));
        this.assertDecimalFunction("CAST(INTEGER '1345678901' AS DECIMAL(18,8))", TestDecimalCasts.decimal("1345678901.00000000"));
        this.assertDecimalFunction("CAST(INTEGER '1234567890' AS DECIMAL(20, 10))", TestDecimalCasts.decimal("1234567890.0000000000"));
        this.assertDecimalFunction("CAST(INTEGER '-1234567890' AS DECIMAL(20, 10))", TestDecimalCasts.decimal("-1234567890.0000000000"));
        this.assertDecimalFunction("CAST(INTEGER '1234567890' AS DECIMAL(30, 20))", TestDecimalCasts.decimal("1234567890.00000000000000000000"));
        this.assertDecimalFunction("CAST(INTEGER '-1234567890' AS DECIMAL(30, 20))", TestDecimalCasts.decimal("-1234567890.00000000000000000000"));
        this.assertInvalidCast("CAST(INTEGER '10' AS DECIMAL(38,37))", "Cannot cast INTEGER '10' to DECIMAL(38, 37)");
        this.assertInvalidCast("CAST(INTEGER '1234567890' AS DECIMAL(17,10))", "Cannot cast INTEGER '1234567890' to DECIMAL(17, 10)");
        this.assertInvalidCast("CAST(INTEGER '123' AS DECIMAL(2,1))", "Cannot cast INTEGER '123' to DECIMAL(2, 1)");
        this.assertInvalidCast("CAST(INTEGER '-123' AS DECIMAL(2,1))", "Cannot cast INTEGER '-123' to DECIMAL(2, 1)");
    }

    @Test
    public void testSmallintToDecimalCasts() {
        this.assertDecimalFunction("CAST(SMALLINT '234' AS DECIMAL(4,1))", TestDecimalCasts.decimal("234.0"));
        this.assertDecimalFunction("CAST(SMALLINT '234' AS DECIMAL(5,2))", TestDecimalCasts.decimal("234.00"));
        this.assertDecimalFunction("CAST(SMALLINT '234' AS DECIMAL(4,0))", TestDecimalCasts.decimal("0234"));
        this.assertDecimalFunction("CAST(SMALLINT '-234' AS DECIMAL(4,1))", TestDecimalCasts.decimal("-234.0"));
        this.assertDecimalFunction("CAST(SMALLINT '0' AS DECIMAL(4,2))", TestDecimalCasts.decimal("00.00"));
        this.assertDecimalFunction("CAST(SMALLINT '1234' AS DECIMAL(20, 10))", TestDecimalCasts.decimal("0000001234.0000000000"));
        this.assertDecimalFunction("CAST(SMALLINT '-1234' AS DECIMAL(20, 10))", TestDecimalCasts.decimal("-0000001234.0000000000"));
        this.assertDecimalFunction("CAST(SMALLINT '1234' AS DECIMAL(30, 20))", TestDecimalCasts.decimal("0000001234.00000000000000000000"));
        this.assertDecimalFunction("CAST(SMALLINT '-1234' AS DECIMAL(30, 20))", TestDecimalCasts.decimal("-0000001234.00000000000000000000"));
        this.assertDecimalFunction("CAST(SMALLINT '12345' AS DECIMAL(18,13))", TestDecimalCasts.decimal("12345.0000000000000"));
        this.assertInvalidCast("CAST(SMALLINT '10' AS DECIMAL(38,37))", "Cannot cast SMALLINT '10' to DECIMAL(38, 37)");
        this.assertInvalidCast("CAST(SMALLINT '1234' AS DECIMAL(17,14))", "Cannot cast SMALLINT '1234' to DECIMAL(17, 14)");
        this.assertInvalidCast("CAST(SMALLINT '123' AS DECIMAL(2,1))", "Cannot cast SMALLINT '123' to DECIMAL(2, 1)");
        this.assertInvalidCast("CAST(SMALLINT '-123' AS DECIMAL(2,1))", "Cannot cast SMALLINT '-123' to DECIMAL(2, 1)");
    }

    @Test
    public void testTinyintToDecimalCasts() {
        this.assertDecimalFunction("CAST(TINYINT '23' AS DECIMAL(4,1))", TestDecimalCasts.decimal("023.0"));
        this.assertDecimalFunction("CAST(TINYINT '23' AS DECIMAL(5,2))", TestDecimalCasts.decimal("023.00"));
        this.assertDecimalFunction("CAST(TINYINT '23' AS DECIMAL(4,0))", TestDecimalCasts.decimal("0023"));
        this.assertDecimalFunction("CAST(TINYINT '-23' AS DECIMAL(4,1))", TestDecimalCasts.decimal("-023.0"));
        this.assertDecimalFunction("CAST(TINYINT '0' AS DECIMAL(4,2))", TestDecimalCasts.decimal("00.00"));
        this.assertDecimalFunction("CAST(TINYINT '123' AS DECIMAL(20, 10))", TestDecimalCasts.decimal("0000000123.0000000000"));
        this.assertDecimalFunction("CAST(TINYINT '-123' AS DECIMAL(20, 10))", TestDecimalCasts.decimal("-0000000123.0000000000"));
        this.assertDecimalFunction("CAST(TINYINT '123' AS DECIMAL(30, 20))", TestDecimalCasts.decimal("0000000123.00000000000000000000"));
        this.assertDecimalFunction("CAST(TINYINT '-123' AS DECIMAL(30, 20))", TestDecimalCasts.decimal("-0000000123.00000000000000000000"));
        this.assertDecimalFunction("CAST(TINYINT '123' AS DECIMAL(18,15))", TestDecimalCasts.decimal("123.000000000000000"));
        this.assertInvalidCast("CAST(TINYINT '10' AS DECIMAL(38,37))", "Cannot cast TINYINT '10' to DECIMAL(38, 37)");
        this.assertInvalidCast("CAST(TINYINT '123' AS DECIMAL(17,15))", "Cannot cast TINYINT '123' to DECIMAL(17, 15)");
        this.assertInvalidCast("CAST(TINYINT '123' AS DECIMAL(2,1))", "Cannot cast TINYINT '123' to DECIMAL(2, 1)");
        this.assertInvalidCast("CAST(TINYINT '-123' AS DECIMAL(2,1))", "Cannot cast TINYINT '-123' to DECIMAL(2, 1)");
    }

    @Test
    public void testDecimalToBigintCasts() {
        this.assertFunction("CAST(DECIMAL '2.34' AS BIGINT)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CAST(DECIMAL '2.5' AS BIGINT)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("CAST(DECIMAL '2.49' AS BIGINT)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CAST(DECIMAL '20' AS BIGINT)", (Type)BigintType.BIGINT, 20L);
        this.assertFunction("CAST(DECIMAL '1' AS BIGINT)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("CAST(DECIMAL '0' AS BIGINT)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("CAST(DECIMAL '-20' AS BIGINT)", (Type)BigintType.BIGINT, -20L);
        this.assertFunction("CAST(DECIMAL '-1' AS BIGINT)", (Type)BigintType.BIGINT, -1L);
        this.assertFunction("CAST(DECIMAL '-2.49' AS BIGINT)", (Type)BigintType.BIGINT, -2L);
        this.assertFunction("CAST(DECIMAL '-2.5' AS BIGINT)", (Type)BigintType.BIGINT, -3L);
        this.assertFunction("CAST(DECIMAL '0.1234567890123456' AS BIGINT)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("CAST(DECIMAL '0.9999999999999999' AS BIGINT)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("CAST(DECIMAL '0.00000000000000000000' AS BIGINT)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("CAST(DECIMAL '0.99999999999999999999' AS BIGINT)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("CAST(DECIMAL '123.999999999999999' AS BIGINT)", (Type)BigintType.BIGINT, 124L);
        this.assertFunction("CAST(DECIMAL '999999999999999999' AS BIGINT)", (Type)BigintType.BIGINT, 999999999999999999L);
        this.assertFunction("CAST(DECIMAL '1234567890.1234567890' AS BIGINT)", (Type)BigintType.BIGINT, 1234567890L);
        this.assertFunction("CAST(DECIMAL '-1234567890.1234567890' AS BIGINT)", (Type)BigintType.BIGINT, -1234567890L);
        this.assertInvalidCast("CAST(DECIMAL '12345678901234567890' AS BIGINT)", "Cannot cast '12345678901234567890' to BIGINT");
    }

    @Test
    public void testDecimalToIntegerCasts() {
        this.assertFunction("CAST(DECIMAL '2.34' AS INTEGER)", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("CAST(DECIMAL '2.5' AS INTEGER)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("CAST(DECIMAL '2.49' AS INTEGER)", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("CAST(DECIMAL '20' AS INTEGER)", (Type)IntegerType.INTEGER, 20);
        this.assertFunction("CAST(DECIMAL '1' AS INTEGER)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("CAST(DECIMAL '0' AS INTEGER)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("CAST(DECIMAL '-20' AS INTEGER)", (Type)IntegerType.INTEGER, -20);
        this.assertFunction("CAST(DECIMAL '-1' AS INTEGER)", (Type)IntegerType.INTEGER, -1);
        this.assertFunction("CAST(DECIMAL '-2.49' AS INTEGER)", (Type)IntegerType.INTEGER, -2);
        this.assertFunction("CAST(DECIMAL '-2.5' AS INTEGER)", (Type)IntegerType.INTEGER, -3);
        this.assertFunction("CAST(DECIMAL '0.1234567890123456' AS INTEGER)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("CAST(DECIMAL '0.9999999999999999' AS INTEGER)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("CAST(DECIMAL '0.00000000000000000000' AS INTEGER)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("CAST(DECIMAL '0.99999999999999999999' AS INTEGER)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("CAST(DECIMAL '123.999999999999999' AS INTEGER)", (Type)IntegerType.INTEGER, 124);
        this.assertFunction("CAST(DECIMAL '1234567890.1234567890' AS INTEGER)", (Type)IntegerType.INTEGER, 1234567890);
        this.assertFunction("CAST(DECIMAL '-1234567890.1234567890' AS INTEGER)", (Type)IntegerType.INTEGER, -1234567890);
        this.assertInvalidCast("CAST(DECIMAL '12345678901234567890' AS INTEGER)", "Cannot cast '12345678901234567890' to INTEGER");
    }

    @Test
    public void testDecimalToSmallintCasts() {
        this.assertFunction("CAST(DECIMAL '2.34' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)2);
        this.assertFunction("CAST(DECIMAL '2.5' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)3);
        this.assertFunction("CAST(DECIMAL '2.49' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)2);
        this.assertFunction("CAST(DECIMAL '20' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)20);
        this.assertFunction("CAST(DECIMAL '1' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)1);
        this.assertFunction("CAST(DECIMAL '0' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("CAST(DECIMAL '-20' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)-20);
        this.assertFunction("CAST(DECIMAL '-1' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)-1);
        this.assertFunction("CAST(DECIMAL '-2.49' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)-2);
        this.assertFunction("CAST(DECIMAL '-2.5' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)-3);
        this.assertFunction("CAST(DECIMAL '0.1234567890123456' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("CAST(DECIMAL '0.9999999999999999' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)1);
        this.assertFunction("CAST(DECIMAL '0.00000000000000000000' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("CAST(DECIMAL '0.99999999999999999999' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)1);
        this.assertFunction("CAST(DECIMAL '123.999999999999999' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)124);
        this.assertFunction("CAST(DECIMAL '1234.1234567890' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)1234);
        this.assertFunction("CAST(DECIMAL '-1234.1234567890' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)-1234);
        this.assertInvalidCast("CAST(DECIMAL '12345678901234567890' AS SMALLINT)", "Cannot cast '12345678901234567890' to SMALLINT");
    }

    @Test
    public void testDecimalToTinyintCasts() {
        this.assertFunction("CAST(DECIMAL '2.34' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)2);
        this.assertFunction("CAST(DECIMAL '2.5' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)3);
        this.assertFunction("CAST(DECIMAL '2.49' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)2);
        this.assertFunction("CAST(DECIMAL '20' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)20);
        this.assertFunction("CAST(DECIMAL '1' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)1);
        this.assertFunction("CAST(DECIMAL '0' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("CAST(DECIMAL '-20' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)-20);
        this.assertFunction("CAST(DECIMAL '-1' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)-1);
        this.assertFunction("CAST(DECIMAL '-2.49' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)-2);
        this.assertFunction("CAST(DECIMAL '-2.5' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)-3);
        this.assertFunction("CAST(DECIMAL '0.1234567890123456' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("CAST(DECIMAL '0.9999999999999999' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)1);
        this.assertFunction("CAST(DECIMAL '0.00000000000000000000' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("CAST(DECIMAL '0.99999999999999999999' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)1);
        this.assertFunction("CAST(DECIMAL '123.999999999999999' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)124);
        this.assertFunction("CAST(DECIMAL '12.1234567890' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)12);
        this.assertFunction("CAST(DECIMAL '-12.1234567890' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)-12);
        this.assertInvalidCast("CAST(DECIMAL '12345678901234567890' AS TINYINT)", "Cannot cast '12345678901234567890' to TINYINT");
    }

    @Test
    public void testDoubleToShortDecimalCasts() {
        this.assertDecimalFunction("CAST(DOUBLE '234.0' AS DECIMAL(4,1))", TestDecimalCasts.decimal("234.0"));
        this.assertDecimalFunction("CAST(DOUBLE '.01' AS DECIMAL(3,3))", TestDecimalCasts.decimal(".010"));
        this.assertDecimalFunction("CAST(DOUBLE '.0' AS DECIMAL(3,3))", TestDecimalCasts.decimal(".000"));
        this.assertDecimalFunction("CAST(DOUBLE '0.0' AS DECIMAL(1,0))", TestDecimalCasts.decimal("0"));
        this.assertDecimalFunction("CAST(DOUBLE '0.0' AS DECIMAL(4,0))", TestDecimalCasts.decimal("0000"));
        this.assertDecimalFunction("CAST(DOUBLE '1000.0' AS DECIMAL(4,0))", TestDecimalCasts.decimal("1000"));
        this.assertDecimalFunction("CAST(DOUBLE '1000.01' AS DECIMAL(7,2))", TestDecimalCasts.decimal("01000.01"));
        this.assertDecimalFunction("CAST(DOUBLE '-234.0' AS DECIMAL(3,0))", TestDecimalCasts.decimal("-234"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890123456.0' AS DECIMAL(16,0))", TestDecimalCasts.decimal("1234567890123456"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890123456.0' AS DECIMAL(16,0))", TestDecimalCasts.decimal("-1234567890123456"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890123456.0' AS DECIMAL(17,0))", TestDecimalCasts.decimal("01234567890123456"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890123456.0' AS DECIMAL(17,0))", TestDecimalCasts.decimal("-01234567890123456"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890.0' AS DECIMAL(20,10))", TestDecimalCasts.decimal("1234567890.0000000000"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890.0' AS DECIMAL(20,10))", TestDecimalCasts.decimal("-1234567890.0000000000"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890.0' AS DECIMAL(30,20))", TestDecimalCasts.decimal("1234567890.00000000000000000000"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890.0' AS DECIMAL(30,20))", TestDecimalCasts.decimal("-1234567890.00000000000000000000"));
        this.assertDecimalFunction("CAST(DOUBLE '123456789123456784' AS DECIMAL(18,0))", TestDecimalCasts.decimal("123456789123456784"));
        this.assertDecimalFunction("CAST(DOUBLE '123456789.123456790' AS DECIMAL(18,9))", TestDecimalCasts.decimal("123456789.123456790"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890.49' AS DECIMAL(16,0))", TestDecimalCasts.decimal("0000001234567890"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890.51' AS DECIMAL(16,0))", TestDecimalCasts.decimal("0000001234567891"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890.49' AS DECIMAL(16,0))", TestDecimalCasts.decimal("-0000001234567890"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890.51' AS DECIMAL(16,0))", TestDecimalCasts.decimal("-0000001234567891"));
        this.assertInvalidCast("CAST(DOUBLE '100.02' AS DECIMAL(17,16))", "Cannot cast DOUBLE '100.02' to DECIMAL(17, 16)");
        this.assertInvalidCast("CAST(DOUBLE '234.0' AS DECIMAL(2,0))", "Cannot cast DOUBLE '234.0' to DECIMAL(2, 0)");
        this.assertInvalidCast("CAST(DOUBLE '1000.01' AS DECIMAL(5,2))", "Cannot cast DOUBLE '1000.01' to DECIMAL(5, 2)");
        this.assertInvalidCast("CAST(DOUBLE '-234.0' AS DECIMAL(2,0))", "Cannot cast DOUBLE '-234.0' to DECIMAL(2, 0)");
        this.assertInvalidCast("CAST(infinity() AS DECIMAL(17,16))", "Cannot cast DOUBLE 'Infinity' to DECIMAL(17, 16)");
        this.assertInvalidCast("CAST(nan() AS DECIMAL(10,5))", "Cannot cast DOUBLE 'NaN' to DECIMAL(10, 5)");
        this.assertInvalidCast("CAST(infinity() AS DECIMAL(10,1))", "Cannot cast DOUBLE 'Infinity' to DECIMAL(10, 1)");
        this.assertInvalidCast("CAST(-infinity() AS DECIMAL(1,1))", "Cannot cast DOUBLE '-Infinity' to DECIMAL(1, 1)");
    }

    @Test
    public void testDoubleToLongDecimalCasts() {
        this.assertDecimalFunction("CAST(DOUBLE '234.0' AS DECIMAL(20,1))", TestDecimalCasts.decimal("0000000000000000234.0"));
        this.assertDecimalFunction("CAST(DOUBLE '.25' AS DECIMAL(20,5))", TestDecimalCasts.decimal("000000000000000.25000"));
        this.assertDecimalFunction("CAST(DOUBLE '.01' AS DECIMAL(20,3))", TestDecimalCasts.decimal("00000000000000000.010"));
        this.assertDecimalFunction("CAST(DOUBLE '.0' AS DECIMAL(20,3))", TestDecimalCasts.decimal("00000000000000000.000"));
        this.assertDecimalFunction("CAST(DOUBLE '0.0' AS DECIMAL(20,0))", TestDecimalCasts.decimal("00000000000000000000"));
        this.assertDecimalFunction("CAST(DOUBLE '1000.01' AS DECIMAL(20,2))", TestDecimalCasts.decimal("000000000000001000.01"));
        this.assertDecimalFunction("CAST(DOUBLE '-234.0' AS DECIMAL(20,0))", TestDecimalCasts.decimal("-00000000000000000234"));
        this.assertDecimalFunction("CAST(DOUBLE '12345678901234567.0' AS DECIMAL(20,0))", TestDecimalCasts.decimal("00012345678901234568"));
        this.assertDecimalFunction("CAST(DOUBLE '-12345678901234567.0' AS DECIMAL(20,0))", TestDecimalCasts.decimal("-00012345678901234568"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890.0' AS DECIMAL(20,10))", TestDecimalCasts.decimal("1234567890.0000000000"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890.0' AS DECIMAL(20,10))", TestDecimalCasts.decimal("-1234567890.0000000000"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890123456.9' AS DECIMAL(16,0))", TestDecimalCasts.decimal("1234567890123457"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890123456.9' AS DECIMAL(16,0))", TestDecimalCasts.decimal("-1234567890123457"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890123456789012345' AS DECIMAL(30,5))", TestDecimalCasts.decimal("1234567890123456800000000.00000"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890123456789012345' AS DECIMAL(30,5))", TestDecimalCasts.decimal("-1234567890123456800000000.00000"));
        this.assertDecimalFunction("CAST(DOUBLE '1.2345678901234568E24' AS DECIMAL(30,5))", TestDecimalCasts.decimal("1234567890123456800000000.00000"));
        this.assertDecimalFunction("CAST(DOUBLE '-1.2345678901234568E24' AS DECIMAL(30,5))", TestDecimalCasts.decimal("-1234567890123456800000000.00000"));
        this.assertDecimalFunction("CAST(DOUBLE '.1234567890123456789012345' AS DECIMAL(30,30))", TestDecimalCasts.decimal(".123456789012345680000000000000"));
        this.assertDecimalFunction("CAST(DOUBLE '-.1234567890123456789012345' AS DECIMAL(30,30))", TestDecimalCasts.decimal("-.123456789012345680000000000000"));
        this.assertFunction("CAST(CAST(DOUBLE '1234567890123456789012345' AS DECIMAL(30,5)) as DOUBLE) = DOUBLE '1234567890123456789012345'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(CAST(DOUBLE '1.2345678901234568E24' AS DECIMAL(30,5)) as DOUBLE) = DOUBLE '1.2345678901234568E24'", (Type)BooleanType.BOOLEAN, true);
        this.assertDecimalFunction("CAST(DOUBLE '1234567890.49' AS DECIMAL(20,0))", TestDecimalCasts.decimal("00000000001234567890"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890.51' AS DECIMAL(20,0))", TestDecimalCasts.decimal("00000000001234567891"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890.49' AS DECIMAL(20,0))", TestDecimalCasts.decimal("-00000000001234567890"));
        this.assertDecimalFunction("CAST(DOUBLE '-1234567890.51' AS DECIMAL(20,0))", TestDecimalCasts.decimal("-00000000001234567891"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890.49' AS DECIMAL(10,0))", TestDecimalCasts.decimal("1234567890"));
        this.assertDecimalFunction("CAST(DOUBLE '1234567890.51' AS DECIMAL(10,0))", TestDecimalCasts.decimal("1234567891"));
        this.assertInvalidCast("CAST(DOUBLE '100.02' AS DECIMAL(38,37))", "Cannot cast DOUBLE '100.02' to DECIMAL(38, 37)");
        this.assertInvalidCast("CAST(DOUBLE '234000000000000000000.0' AS DECIMAL(20,0))", "Cannot cast DOUBLE '2.34E20' to DECIMAL(20, 0)");
        this.assertInvalidCast("CAST(DOUBLE '1000000000000000000.01' AS DECIMAL(20,2))", "Cannot cast DOUBLE '1.0E18' to DECIMAL(20, 2)");
        this.assertInvalidCast("CAST(DOUBLE '-234000000000000000000.0' AS DECIMAL(20,0))", "Cannot cast DOUBLE '-2.34E20' to DECIMAL(20, 0)");
        this.assertInvalidCast("CAST(DOUBLE '12345678901.1' AS DECIMAL(20, 10))", "Cannot cast DOUBLE '1.23456789011E10' to DECIMAL(20, 10)");
        this.assertInvalidCast("CAST(infinity() AS DECIMAL(38,37))", "Cannot cast DOUBLE 'Infinity' to DECIMAL(38, 37)");
        this.assertInvalidCast("CAST(nan() AS DECIMAL(38,10))", "Cannot cast DOUBLE 'NaN' to DECIMAL(38, 10)");
        this.assertInvalidCast("CAST(infinity() AS DECIMAL(38,2))", "Cannot cast DOUBLE 'Infinity' to DECIMAL(38, 2)");
        this.assertInvalidCast("CAST(-infinity() AS DECIMAL(38,1))", "Cannot cast DOUBLE '-Infinity' to DECIMAL(38, 1)");
        this.assertInvalidCast("CAST(nan() AS DECIMAL(10,5))", "Cannot cast DOUBLE 'NaN' to DECIMAL(10, 5)");
        this.assertInvalidCast("CAST(infinity() AS DECIMAL(10,1))", "Cannot cast DOUBLE 'Infinity' to DECIMAL(10, 1)");
        this.assertInvalidCast("CAST(-infinity() AS DECIMAL(1,1))", "Cannot cast DOUBLE '-Infinity' to DECIMAL(1, 1)");
    }

    @Test
    public void testDecimalToDoubleCasts() {
        this.assertFunction("CAST(DECIMAL '2.34' AS DOUBLE)", (Type)DoubleType.DOUBLE, 2.34);
        this.assertFunction("CAST(DECIMAL '0' AS DOUBLE)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("CAST(DECIMAL '1' AS DOUBLE)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("CAST(DECIMAL '-2.49' AS DOUBLE)", (Type)DoubleType.DOUBLE, -2.49);
        this.assertFunction("CAST(DECIMAL '123456789123456784' AS DOUBLE)", (Type)DoubleType.DOUBLE, 1.2345678912345678E17);
        this.assertFunction("CAST(DECIMAL '123456789.123456791' AS DOUBLE)", (Type)DoubleType.DOUBLE, 1.2345678912345679E8);
        this.assertFunction("CAST(CAST(DECIMAL '0' AS DECIMAL(20, 2)) AS DOUBLE)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("CAST(CAST(DECIMAL '12.12' AS DECIMAL(20, 2)) AS DOUBLE)", (Type)DoubleType.DOUBLE, 12.12);
        this.assertFunction("CAST(DECIMAL '1234567890.1234567890' AS DOUBLE)", (Type)DoubleType.DOUBLE, 1.2345678901234567E9);
        this.assertFunction("CAST(DECIMAL '-1234567890.1234567890' AS DOUBLE)", (Type)DoubleType.DOUBLE, -1.2345678901234567E9);
        this.assertFunction("CAST(DECIMAL '1234567890.12345678900000000000' AS DOUBLE)", (Type)DoubleType.DOUBLE, 1.2345678901234567E9);
        this.assertFunction("CAST(DECIMAL '-1234567890.12345678900000000000' AS DOUBLE)", (Type)DoubleType.DOUBLE, -1.2345678901234567E9);
        this.assertFunction("CAST(DECIMAL '-1234567890123456789012345678' AS DOUBLE)", (Type)DoubleType.DOUBLE, -1.2345678901234569E27);
        this.assertFunction("CAST(DECIMAL '99999999999999999999999999999999999999' AS DOUBLE)", (Type)DoubleType.DOUBLE, 1.0E38);
    }

    @Test
    public void testFloatToDecimalCasts() {
        this.assertDecimalFunction("CAST(REAL '234.0' AS DECIMAL(4,1))", TestDecimalCasts.decimal("234.0"));
        this.assertDecimalFunction("CAST(REAL '.01' AS DECIMAL(3,3))", TestDecimalCasts.decimal(".010"));
        this.assertDecimalFunction("CAST(REAL '.0' AS DECIMAL(3,3))", TestDecimalCasts.decimal(".000"));
        this.assertDecimalFunction("CAST(REAL '0' AS DECIMAL(1,0))", TestDecimalCasts.decimal("0"));
        this.assertDecimalFunction("CAST(REAL '0' AS DECIMAL(4,0))", TestDecimalCasts.decimal("0000"));
        this.assertDecimalFunction("CAST(REAL '1000' AS DECIMAL(4,0))", TestDecimalCasts.decimal("1000"));
        this.assertDecimalFunction("CAST(REAL '1000.01' AS DECIMAL(7,2))", TestDecimalCasts.decimal("01000.01"));
        this.assertDecimalFunction("CAST(REAL '-234.0' AS DECIMAL(3,0))", TestDecimalCasts.decimal("-234"));
        this.assertDecimalFunction("CAST(REAL '12345678400000000' AS DECIMAL(17,0))", TestDecimalCasts.decimal("12345678400000000"));
        this.assertDecimalFunction("CAST(REAL '-12345678400000000' AS DECIMAL(17,0))", TestDecimalCasts.decimal("-12345678400000000"));
        this.assertDecimalFunction("CAST(REAL '1234567940' AS DECIMAL(20,10))", TestDecimalCasts.decimal("1234567940.0000000000"));
        this.assertDecimalFunction("CAST(REAL '-1234567940' AS DECIMAL(20,10))", TestDecimalCasts.decimal("-1234567940.0000000000"));
        this.assertDecimalFunction("CAST(REAL '1234567940' AS DECIMAL(30,20))", TestDecimalCasts.decimal("1234567940.00000000000000000000"));
        this.assertDecimalFunction("CAST(REAL '-1234567940' AS DECIMAL(30,20))", TestDecimalCasts.decimal("-1234567940.00000000000000000000"));
        this.assertDecimalFunction("CAST(REAL '123456790519087104' AS DECIMAL(18,0))", TestDecimalCasts.decimal("123456791000000000"));
        this.assertDecimalFunction("CAST(REAL '-123456790519087104' AS DECIMAL(18,0))", TestDecimalCasts.decimal("-123456791000000000"));
        this.assertDecimalFunction("CAST(REAL '123456790519087104' AS DECIMAL(20,2))", TestDecimalCasts.decimal("123456791000000000.00"));
        this.assertDecimalFunction("CAST(REAL '-123456790519087104' AS DECIMAL(20,2))", TestDecimalCasts.decimal("-123456791000000000.00"));
        this.assertDecimalFunction("CAST(REAL '1234567905190871' AS DECIMAL(18,2))", TestDecimalCasts.decimal("1234567950000000.00"));
        this.assertDecimalFunction("CAST(REAL '-1234567905190871' AS DECIMAL(18,2))", TestDecimalCasts.decimal("-1234567950000000.00"));
        this.assertDecimalFunction("CAST(REAL '1456213.432632456' AS DECIMAL(18,9))", TestDecimalCasts.decimal("001456213.400000000"));
        this.assertFunction("CAST(CAST(DOUBLE '123456790519087104' AS DECIMAL(18,0)) as DOUBLE) = DOUBLE '123456790519087104'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(CAST(DOUBLE '123456790519087104' AS DECIMAL(30,0)) as DOUBLE) = DOUBLE '123456790519087104'", (Type)BooleanType.BOOLEAN, true);
        this.assertInvalidCast("CAST(REAL '100.02' AS DECIMAL(38,37))", "Cannot cast REAL '100.02' to DECIMAL(38, 37)");
        this.assertInvalidCast("CAST(REAL '100.02' AS DECIMAL(17,16))", "Cannot cast REAL '100.02' to DECIMAL(17, 16)");
        this.assertInvalidCast("CAST(REAL '234.0' AS DECIMAL(2,0))", "Cannot cast REAL '234.0' to DECIMAL(2, 0)");
        this.assertInvalidCast("CAST(REAL '1000.01' AS DECIMAL(5,2))", "Cannot cast REAL '1000.01' to DECIMAL(5, 2)");
        this.assertInvalidCast("CAST(REAL '-234.0' AS DECIMAL(2,0))", "Cannot cast REAL '-234.0' to DECIMAL(2, 0)");
        this.assertInvalidCast("CAST(REAL '98765430784.0' AS DECIMAL(20, 10))", "Cannot cast REAL '9.8765431E10' to DECIMAL(20, 10)");
        this.assertInvalidCast("CAST(CAST(nan() as REAL) AS DECIMAL(10,5))", "Cannot cast REAL 'NaN' to DECIMAL(10, 5)");
        this.assertInvalidCast("CAST(CAST(infinity() as REAL) AS DECIMAL(10,1))", "Cannot cast REAL 'Infinity' to DECIMAL(10, 1)");
        this.assertInvalidCast("CAST(CAST(-infinity() as REAL) AS DECIMAL(1,1))", "Cannot cast REAL '-Infinity' to DECIMAL(1, 1)");
        this.assertInvalidCast("CAST(CAST(nan() as REAL) AS DECIMAL(38,10))", "Cannot cast REAL 'NaN' to DECIMAL(38, 10)");
        this.assertInvalidCast("CAST(CAST(infinity() as REAL) AS DECIMAL(38,2))", "Cannot cast REAL 'Infinity' to DECIMAL(38, 2)");
        this.assertInvalidCast("CAST(CAST(-infinity() as REAL) AS DECIMAL(38,1))", "Cannot cast REAL '-Infinity' to DECIMAL(38, 1)");
    }

    @Test
    public void testDecimalToFloatCasts() {
        this.assertFunction("CAST(DECIMAL '2.34' AS REAL)", (Type)RealType.REAL, Float.valueOf(2.34f));
        this.assertFunction("CAST(DECIMAL '0' AS REAL)", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("CAST(DECIMAL '-0' AS REAL)", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("CAST(DECIMAL '1' AS REAL)", (Type)RealType.REAL, Float.valueOf(1.0f));
        this.assertFunction("CAST(DECIMAL '-2.49' AS REAL)", (Type)RealType.REAL, Float.valueOf(-2.49f));
        this.assertFunction("CAST(DECIMAL '123456790519087104' AS REAL)", (Type)RealType.REAL, Float.valueOf(1.2345679E17f));
        this.assertFunction("CAST(DECIMAL '121456.213432632456' AS REAL)", (Type)RealType.REAL, Float.valueOf(121456.21f));
        this.assertFunction("CAST(CAST(DECIMAL '0' AS DECIMAL(20, 2)) AS REAL)", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("CAST(CAST(DECIMAL '12.12' AS DECIMAL(20, 2)) AS REAL)", (Type)RealType.REAL, Float.valueOf(12.12f));
        this.assertFunction("CAST(DECIMAL '1234567890.1234567890' AS REAL)", (Type)RealType.REAL, Float.valueOf(1.234568E9f));
        this.assertFunction("CAST(DECIMAL '-1234567890.1234567890' AS REAL)", (Type)RealType.REAL, Float.valueOf(-1.234568E9f));
        this.assertFunction("CAST(DECIMAL '1234567890.12345678900000000000' AS REAL)", (Type)RealType.REAL, Float.valueOf(1.234568E9f));
        this.assertFunction("CAST(DECIMAL '-1234567890.12345678900000000000' AS REAL)", (Type)RealType.REAL, Float.valueOf(-1.234568E9f));
        this.assertFunction("CAST(DECIMAL '-1234567890123456789012345678' AS REAL)", (Type)RealType.REAL, Float.valueOf(-1.2345679E27f));
        this.assertFunction("CAST(DECIMAL '99999999999999999999999999999999999999' AS REAL)", (Type)RealType.REAL, Float.valueOf(1.0E38f));
    }

    @Test
    public void testVarcharToDecimalCasts() {
        this.assertDecimalFunction("CAST('234.0' AS DECIMAL(4,1))", TestDecimalCasts.decimal("234.0"));
        this.assertDecimalFunction("CAST('.01' AS DECIMAL(3,3))", TestDecimalCasts.decimal(".010"));
        this.assertDecimalFunction("CAST('.0' AS DECIMAL(3,3))", TestDecimalCasts.decimal(".000"));
        this.assertDecimalFunction("CAST('0' AS DECIMAL(1,0))", TestDecimalCasts.decimal("0"));
        this.assertDecimalFunction("CAST('0' AS DECIMAL(4,0))", TestDecimalCasts.decimal("0000"));
        this.assertDecimalFunction("CAST('1000' AS DECIMAL(4,0))", TestDecimalCasts.decimal("1000"));
        this.assertDecimalFunction("CAST('1000.01' AS DECIMAL(7,2))", TestDecimalCasts.decimal("01000.01"));
        this.assertDecimalFunction("CAST('-234.0' AS DECIMAL(3,0))", TestDecimalCasts.decimal("-234"));
        this.assertDecimalFunction("CAST('12345678901234567' AS DECIMAL(17,0))", TestDecimalCasts.decimal("12345678901234567"));
        this.assertDecimalFunction("CAST('123456789012345679' AS DECIMAL(18,0))", TestDecimalCasts.decimal("123456789012345679"));
        this.assertDecimalFunction("CAST('1234567890.12345679' AS DECIMAL(18,8))", TestDecimalCasts.decimal("1234567890.12345679"));
        this.assertDecimalFunction("CAST('-12345678901234567' AS DECIMAL(17,0))", TestDecimalCasts.decimal("-12345678901234567"));
        this.assertDecimalFunction("CAST('1234567890' AS DECIMAL(20,10))", TestDecimalCasts.decimal("1234567890.0000000000"));
        this.assertDecimalFunction("CAST('-1234567890' AS DECIMAL(20,10))", TestDecimalCasts.decimal("-1234567890.0000000000"));
        this.assertDecimalFunction("CAST('1234567890' AS DECIMAL(30,20))", TestDecimalCasts.decimal("1234567890.00000000000000000000"));
        this.assertDecimalFunction("CAST('-1234567890' AS DECIMAL(30,20))", TestDecimalCasts.decimal("-1234567890.00000000000000000000"));
        this.assertInvalidCast("CAST('234.0' AS DECIMAL(2,0))", "Cannot cast VARCHAR '234.0' to DECIMAL(2, 0). Value too large.");
        this.assertInvalidCast("CAST('1000.01' AS DECIMAL(5,2))", "Cannot cast VARCHAR '1000.01' to DECIMAL(5, 2). Value too large.");
        this.assertInvalidCast("CAST('-234.0' AS DECIMAL(2,0))", "Cannot cast VARCHAR '-234.0' to DECIMAL(2, 0). Value too large.");
        this.assertInvalidCast("CAST('12345678901' AS DECIMAL(20, 10))", "Cannot cast VARCHAR '12345678901' to DECIMAL(20, 10). Value too large.");
        this.assertInvalidCast("CAST('foo' AS DECIMAL(2, 0))", "Cannot cast VARCHAR 'foo' to DECIMAL(2, 0). Value is not a number.");
        this.assertInvalidCast("CAST('bar' AS DECIMAL)", "Cannot cast VARCHAR 'bar' to DECIMAL(38, 0). Value is not a number.");
    }

    @Test
    public void testDecimalToVarcharCasts() {
        this.assertFunction("CAST(DECIMAL '2.34' AS VARCHAR)", (Type)VarcharType.VARCHAR, "2.34");
        this.assertFunction("CAST(DECIMAL '23400' AS VARCHAR)", (Type)VarcharType.VARCHAR, "23400");
        this.assertFunction("CAST(DECIMAL '0.0034' AS VARCHAR)", (Type)VarcharType.VARCHAR, "0.0034");
        this.assertFunction("CAST(DECIMAL '0' AS VARCHAR)", (Type)VarcharType.VARCHAR, "0");
        this.assertFunction("CAST(DECIMAL '0.1234567890123456' AS VARCHAR)", (Type)VarcharType.VARCHAR, "0.1234567890123456");
        this.assertFunction("CAST(DECIMAL '0.12345678901234567' AS VARCHAR)", (Type)VarcharType.VARCHAR, "0.12345678901234567");
        this.assertFunction("CAST(DECIMAL '-10' AS VARCHAR)", (Type)VarcharType.VARCHAR, "-10");
        this.assertFunction("CAST(DECIMAL '-1.0' AS VARCHAR)", (Type)VarcharType.VARCHAR, "-1.0");
        this.assertFunction("CAST(DECIMAL '-1.00' AS VARCHAR)", (Type)VarcharType.VARCHAR, "-1.00");
        this.assertFunction("CAST(DECIMAL '-1.00000' AS VARCHAR)", (Type)VarcharType.VARCHAR, "-1.00000");
        this.assertFunction("CAST(DECIMAL '-0.1' AS VARCHAR)", (Type)VarcharType.VARCHAR, "-0.1");
        this.assertFunction("CAST(DECIMAL '-.001' AS VARCHAR)", (Type)VarcharType.VARCHAR, "-0.001");
        this.assertFunction("CAST(DECIMAL '-1234567890.1234567' AS VARCHAR)", (Type)VarcharType.VARCHAR, "-1234567890.1234567");
        this.assertFunction("CAST(DECIMAL '1234567890.1234567890' AS VARCHAR)", (Type)VarcharType.VARCHAR, "1234567890.1234567890");
        this.assertFunction("CAST(DECIMAL '-1234567890.1234567890' AS VARCHAR)", (Type)VarcharType.VARCHAR, "-1234567890.1234567890");
        this.assertFunction("CAST(DECIMAL '1234567890.12345678900000000000' AS VARCHAR)", (Type)VarcharType.VARCHAR, "1234567890.12345678900000000000");
        this.assertFunction("CAST(DECIMAL '-1234567890.12345678900000000000' AS VARCHAR)", (Type)VarcharType.VARCHAR, "-1234567890.12345678900000000000");
        this.assertFunction("cast(DECIMAL '12.4' as varchar(4))", (Type)VarcharType.createVarcharType((int)4), "12.4");
        this.assertFunction("cast(DECIMAL '12.4' as varchar(50))", (Type)VarcharType.createVarcharType((int)50), "12.4");
        this.assertInvalidCast("cast(DECIMAL '12.4' as varchar(3))", "Value 12.4 cannot be represented as varchar(3)");
        this.assertFunction("cast(DECIMAL '100000000000000000.1' as varchar(20))", (Type)VarcharType.createVarcharType((int)20), "100000000000000000.1");
        this.assertFunction("cast(DECIMAL '100000000000000000.1' as varchar(50))", (Type)VarcharType.createVarcharType((int)50), "100000000000000000.1");
        this.assertInvalidCast("cast(DECIMAL '100000000000000000.1' as varchar(19))", "Value 100000000000000000.1 cannot be represented as varchar(19)");
    }
}

