/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.SqlVarbinaryTestingUtil;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import io.trino.util.StructuralTestUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestMapOperators
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
    }

    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice uncheckedToJson(@SqlType(value="varchar(x)") Slice slice) {
        return slice;
    }

    @Test
    public void testConstructor() {
        this.assertFunction("MAP(ARRAY ['1','3'], ARRAY [2,4])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"1", (Object)2, (Object)"3", (Object)4));
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 2);
        map.put(3, null);
        this.assertFunction("MAP(ARRAY [1, 3], ARRAY[2, NULL])", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), map);
        this.assertFunction("MAP(ARRAY [1, 3], ARRAY [2.0E0, 4.0E0])", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)1, (Object)2.0, (Object)3, (Object)4.0));
        this.assertFunction("MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3])", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)29, (int)14), (Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableMap.of((Object)TestMapOperators.decimal("000000000000001.00000000000000"), (Object)TestMapOperators.decimal("2.2"), (Object)TestMapOperators.decimal("383838383838383.12324234234234"), (Object)TestMapOperators.decimal("3.3")));
        this.assertFunction("MAP(ARRAY[1.0E0, 2.0E0], ARRAY[ ARRAY[BIGINT '1', BIGINT '2'], ARRAY[ BIGINT '3' ]])", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)BigintType.BIGINT)), ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)2.0, (Object)ImmutableList.of((Object)3L)));
        this.assertFunction("MAP(ARRAY['puppies'], ARRAY['kittens'])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)7), (Type)VarcharType.createVarcharType((int)7)), ImmutableMap.of((Object)"puppies", (Object)"kittens"));
        this.assertFunction("MAP(ARRAY[TRUE, FALSE], ARRAY[2,4])", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)true, (Object)2, (Object)false, (Object)4));
        this.assertFunction("MAP(ARRAY['1', '100'], ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01'])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)3), (Type)TimestampType.createTimestampType((int)0)), ImmutableMap.of((Object)"1", (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0), (Object)"100", (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0)));
        this.assertFunction("MAP(ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01'], ARRAY[1.0E0, 100.0E0])", (Type)StructuralTestUtil.mapType((Type)TimestampType.createTimestampType((int)0), (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0), (Object)1.0, (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0), (Object)100.0));
        this.assertInvalidFunction("MAP(ARRAY [1], ARRAY [2, 4])", "Key and value arrays must be the same length");
        this.assertInvalidFunction("MAP(ARRAY [1, 2, 3, 2], ARRAY [4, 5, 6, 7])", "Duplicate map keys (2) are not allowed");
        this.assertInvalidFunction("MAP(ARRAY [ARRAY [1, 2], ARRAY [1, 3], ARRAY [1, 2]], ARRAY [1, 2, 3])", "Duplicate map keys ([1, 2]) are not allowed");
        this.assertCachedInstanceHasBoundedRetainedSize("MAP(ARRAY ['1','3'], ARRAY [2,4])");
        this.assertFunction("MAP(ARRAY [ARRAY[1]], ARRAY[2])", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)ImmutableList.of((Object)1), (Object)2));
        this.assertInvalidFunction("MAP(ARRAY [NULL], ARRAY[2])", "map key cannot be null");
        this.assertInvalidFunction("MAP(ARRAY [ARRAY[NULL]], ARRAY[2])", "map key cannot be indeterminate: [null]");
    }

    @Test
    public void testEmptyMapConstructor() {
        this.assertFunction("MAP()", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
    }

    @Test
    public void testCardinality() {
        this.assertFunction("CARDINALITY(MAP(ARRAY ['1','3'], ARRAY [2,4]))", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CARDINALITY(MAP(ARRAY [1, 3], ARRAY[2, NULL]))", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CARDINALITY(MAP(ARRAY [1, 3], ARRAY [2.0E0, 4.0E0]))", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CARDINALITY(MAP(ARRAY[1.0E0, 2.0E0], ARRAY[ ARRAY[1, 2], ARRAY[3]]))", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CARDINALITY(MAP(ARRAY['puppies'], ARRAY['kittens']))", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("CARDINALITY(MAP(ARRAY[TRUE], ARRAY[2]))", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("CARDINALITY(MAP(ARRAY['1'], ARRAY[from_unixtime(1)]))", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("CARDINALITY(MAP(ARRAY[from_unixtime(1)], ARRAY[1.0E0]))", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("CARDINALITY(MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3]))", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CARDINALITY(MAP(ARRAY [1.0], ARRAY [2.2]))", (Type)BigintType.BIGINT, 1L);
    }

    @Test
    public void testMapToJson() {
        this.assertFunction("CAST(MAP(ARRAY[7,5,3,1], ARRAY[8,6,4,2]) AS JSON)", (Type)JsonType.JSON, "{\"1\":2,\"3\":4,\"5\":6,\"7\":8}");
        this.assertFunction("CAST(MAP(ARRAY[1,3,5,7], ARRAY[2,4,6,8]) AS JSON)", (Type)JsonType.JSON, "{\"1\":2,\"3\":4,\"5\":6,\"7\":8}");
        this.assertFunction("cast(cast (null as MAP<BIGINT, BIGINT>) AS JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(MAP() AS JSON)", (Type)JsonType.JSON, "{}");
        this.assertFunction("cast(MAP(ARRAY[1, 2], ARRAY[null, null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":null,\"2\":null}");
        this.assertFunction("CAST(MAP(ARRAY[true, false], ARRAY[1, 2]) AS JSON)", (Type)JsonType.JSON, "{\"false\":2,\"true\":1}");
        this.assertFunction("cast(MAP(cast(ARRAY[1, 2, 3] AS ARRAY<TINYINT>), ARRAY[5, 8, null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":5,\"2\":8,\"3\":null}");
        this.assertFunction("cast(MAP(cast(ARRAY[12345, 12346, 12347] AS ARRAY<SMALLINT>), ARRAY[5, 8, null]) AS JSON)", (Type)JsonType.JSON, "{\"12345\":5,\"12346\":8,\"12347\":null}");
        this.assertFunction("cast(MAP(cast(ARRAY[123456789,123456790,123456791] AS ARRAY<INTEGER>), ARRAY[5, 8, null]) AS JSON)", (Type)JsonType.JSON, "{\"123456789\":5,\"123456790\":8,\"123456791\":null}");
        this.assertFunction("cast(MAP(cast(ARRAY[1234567890123456111,1234567890123456222,1234567890123456777] AS ARRAY<BIGINT>), ARRAY[111, 222, null]) AS JSON)", (Type)JsonType.JSON, "{\"1234567890123456111\":111,\"1234567890123456222\":222,\"1234567890123456777\":null}");
        this.assertFunction("cast(MAP(cast(ARRAY[3.14E0, 1e10, 1e20] AS ARRAY<REAL>), ARRAY[null, 10, 20]) AS JSON)", (Type)JsonType.JSON, "{\"1.0E10\":10,\"1.0E20\":20,\"3.14\":null}");
        this.assertFunction("cast(MAP(ARRAY[1e-323,1e308,nan()], ARRAY[-323,308,null]) AS JSON)", (Type)JsonType.JSON, "{\"1.0E-323\":-323,\"1.0E308\":308,\"NaN\":null}");
        this.assertFunction("cast(MAP(ARRAY[DECIMAL '3.14', DECIMAL '0.01'], ARRAY[0.14, null]) AS JSON)", (Type)JsonType.JSON, "{\"0.01\":null,\"3.14\":0.14}");
        this.assertFunction("cast(MAP(ARRAY[DECIMAL '12345678901234567890.1234567890666666', DECIMAL '0.0'], ARRAY[666666, null]) AS JSON)", (Type)JsonType.JSON, "{\"0.0000000000000000\":null,\"12345678901234567890.1234567890666666\":666666}");
        this.assertFunction("CAST(MAP(ARRAY['a', 'bb', 'ccc'], ARRAY[1, 2, 3]) AS JSON)", (Type)JsonType.JSON, "{\"a\":1,\"bb\":2,\"ccc\":3}");
        this.assertFunction("cast(MAP(ARRAY[1, 2, 3], ARRAY[true, false, null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":true,\"2\":false,\"3\":null}");
        this.assertFunction("cast(MAP(ARRAY[1, 2, 3], cast(ARRAY[5, 8, null] AS ARRAY<TINYINT>)) AS JSON)", (Type)JsonType.JSON, "{\"1\":5,\"2\":8,\"3\":null}");
        this.assertFunction("cast(MAP(ARRAY[1, 2, 3], cast(ARRAY[12345, -12345, null] AS ARRAY<SMALLINT>)) AS JSON)", (Type)JsonType.JSON, "{\"1\":12345,\"2\":-12345,\"3\":null}");
        this.assertFunction("cast(MAP(ARRAY[1, 2, 3], cast(ARRAY[123456789, -123456789, null] AS ARRAY<INTEGER>)) AS JSON)", (Type)JsonType.JSON, "{\"1\":123456789,\"2\":-123456789,\"3\":null}");
        this.assertFunction("cast(MAP(ARRAY[1, 2, 3], cast(ARRAY[1234567890123456789, -1234567890123456789, null] AS ARRAY<BIGINT>)) AS JSON)", (Type)JsonType.JSON, "{\"1\":1234567890123456789,\"2\":-1234567890123456789,\"3\":null}");
        this.assertFunction("CAST(MAP(ARRAY[1, 2, 3, 5, 8], CAST(ARRAY[3.14E0, nan(), infinity(), -infinity(), null] AS ARRAY<REAL>)) AS JSON)", (Type)JsonType.JSON, "{\"1\":3.14,\"2\":\"NaN\",\"3\":\"Infinity\",\"5\":\"-Infinity\",\"8\":null}");
        this.assertFunction("CAST(MAP(ARRAY[1, 2, 3, 5, 8, 13, 21], ARRAY[3.14E0, 1e-323, 1e308, nan(), infinity(), -infinity(), null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":3.14,\"13\":\"-Infinity\",\"2\":1.0E-323,\"21\":null,\"3\":1.0E308,\"5\":\"NaN\",\"8\":\"Infinity\"}");
        this.assertFunction("CAST(MAP(ARRAY[1, 2], ARRAY[DECIMAL '3.14', null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":3.14,\"2\":null}");
        this.assertFunction("CAST(MAP(ARRAY[1, 2], ARRAY[DECIMAL '12345678901234567890.123456789012345678', null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":12345678901234567890.123456789012345678,\"2\":null}");
        this.assertFunction("cast(MAP(ARRAY[1, 2, 3], ARRAY['a', 'bb', null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":\"a\",\"2\":\"bb\",\"3\":null}");
        this.assertFunction("CAST(MAP(ARRAY[1, 2, 3, 5, 8, 13, 21, 34], ARRAY[JSON '123', JSON '3.14', JSON 'false', JSON '\"abc\"', JSON '[1, \"a\", null]', JSON '{\"a\": 1, \"b\": \"str\", \"c\": null}', JSON 'null', null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":123,\"13\":{\"a\":1,\"b\":\"str\",\"c\":null},\"2\":3.14,\"21\":null,\"3\":false,\"34\":null,\"5\":\"abc\",\"8\":[1,\"a\",null]}");
        this.assertFunction("CAST(MAP(ARRAY[1, 2], ARRAY[TIMESTAMP '1970-01-01 00:00:01', null]) AS JSON)", (Type)JsonType.JSON, String.format("{\"1\":\"%s\",\"2\":null}", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
        this.assertFunction("CAST(MAP(ARRAY[2, 5, 3], ARRAY[DATE '2001-08-22', DATE '2001-08-23', null]) AS JSON)", (Type)JsonType.JSON, "{\"2\":\"2001-08-22\",\"3\":null,\"5\":\"2001-08-23\"}");
        this.assertFunction("cast(MAP(ARRAY[1, 2, 3, 5, 8], ARRAY[ARRAY[1, 2], ARRAY[3, null], ARRAY[], ARRAY[null, null], null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":[1,2],\"2\":[3,null],\"3\":[],\"5\":[null,null],\"8\":null}");
        this.assertFunction("cast(MAP(ARRAY[1, 2, 8, 5, 3], ARRAY[MAP(ARRAY['b', 'a'], ARRAY[2, 1]), MAP(ARRAY['three', 'none'], ARRAY[3, null]), MAP(), MAP(ARRAY['h2', 'h1'], ARRAY[null, null]), null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":{\"a\":1,\"b\":2},\"2\":{\"none\":null,\"three\":3},\"3\":null,\"5\":{\"h1\":null,\"h2\":null},\"8\":{}}");
        this.assertFunction("cast(MAP(ARRAY[1, 2, 3, 5], ARRAY[ROW(1, 2), ROW(3, CAST(null as INTEGER)), CAST(ROW(null, null) AS ROW(INTEGER, INTEGER)), null]) AS JSON)", (Type)JsonType.JSON, "{\"1\":{\"\":1,\"\":2},\"2\":{\"\":3,\"\":null},\"3\":{\"\":null,\"\":null},\"5\":null}");
        this.assertFunction("CAST(MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3]) AS JSON)", (Type)JsonType.JSON, "{\"1.00000000000000\":2.2,\"383838383838383.12324234234234\":3.3}");
        this.assertFunction("CAST(MAP(ARRAY [1.0], ARRAY [2.2]) AS JSON)", (Type)JsonType.JSON, "{\"1.0\":2.2}");
    }

    @Test
    public void testJsonToMap() {
        this.assertFunction("CAST(CAST (null AS JSON) AS MAP<BIGINT, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), null);
        this.assertFunction("CAST(JSON 'null' AS MAP<BIGINT, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), null);
        this.assertFunction("CAST(JSON '{}' AS MAP<BIGINT, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), ImmutableMap.of());
        this.assertFunction("CAST(JSON '{\"1\": null, \"2\": null}' AS MAP<BIGINT, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L), Arrays.asList(null, null)));
        this.assertInvalidCast("CAST(CAST(MAP(ARRAY[12345.12345], ARRAY[12345.12345]) AS JSON) AS MAP<DECIMAL(10,5), DECIMAL(2,1)>)");
        this.assertFunction("CAST(JSON '{\"true\": 1, \"false\": 0}' AS MAP<BOOLEAN, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT), ImmutableMap.of((Object)true, (Object)1L, (Object)false, (Object)0L));
        this.assertFunction("CAST(JSON '{\"1\": 5, \"2\": 8, \"3\": 13}' AS MAP<TINYINT, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)BigintType.BIGINT), ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)8L, (Object)3, (Object)13L));
        this.assertFunction("CAST(JSON '{\"12345\": 5, \"12346\": 8, \"12347\": 13}' AS MAP<SMALLINT, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)SmallintType.SMALLINT, (Type)BigintType.BIGINT), ImmutableMap.of((Object)12345, (Object)5L, (Object)12346, (Object)8L, (Object)12347, (Object)13L));
        this.assertFunction("CAST(JSON '{\"123456789\": 5, \"123456790\": 8, \"123456791\": 13}' AS MAP<INTEGER, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)BigintType.BIGINT), ImmutableMap.of((Object)123456789, (Object)5L, (Object)123456790, (Object)8L, (Object)123456791, (Object)13L));
        this.assertFunction("CAST(JSON '{\"1234567890123456111\": 5, \"1234567890123456222\": 8, \"1234567890123456777\": 13}' AS MAP<BIGINT, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), ImmutableMap.of((Object)1234567890123456111L, (Object)5L, (Object)1234567890123456222L, (Object)8L, (Object)1234567890123456777L, (Object)13L));
        this.assertFunction("CAST(JSON '{\"3.14\": 5, \"NaN\": 8, \"Infinity\": 13, \"-Infinity\": 21}' AS MAP<REAL, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)RealType.REAL, (Type)BigintType.BIGINT), ImmutableMap.of((Object)Float.valueOf(3.14f), (Object)5L, (Object)Float.valueOf(Float.NaN), (Object)8L, (Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)13L, (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)21L));
        this.assertFunction("CAST(JSON '{\"3.1415926\": 5, \"NaN\": 8, \"Infinity\": 13, \"-Infinity\": 21}' AS MAP<DOUBLE, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT), ImmutableMap.of((Object)3.1415926, (Object)5L, (Object)Double.NaN, (Object)8L, (Object)Double.POSITIVE_INFINITY, (Object)13L, (Object)Double.NEGATIVE_INFINITY, (Object)21L));
        this.assertFunction("CAST(JSON '{\"123.456\": 5, \"3.14\": 8}' AS MAP<DECIMAL(10, 5), BIGINT>)", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)10, (int)5), (Type)BigintType.BIGINT), ImmutableMap.of((Object)TestMapOperators.decimal("123.45600"), (Object)5L, (Object)TestMapOperators.decimal("3.14000"), (Object)8L));
        this.assertFunction("CAST(JSON '{\"12345678.12345678\": 5, \"3.1415926\": 8}' AS MAP<DECIMAL(38, 8), BIGINT>)", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)38, (int)8), (Type)BigintType.BIGINT), ImmutableMap.of((Object)TestMapOperators.decimal("12345678.12345678"), (Object)5L, (Object)TestMapOperators.decimal("3.14159260"), (Object)8L));
        this.assertFunction("CAST(JSON '{\"a\": 5, \"bb\": 8, \"ccc\": 13}' AS MAP<VARCHAR, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT), ImmutableMap.of((Object)"a", (Object)5L, (Object)"bb", (Object)8L, (Object)"ccc", (Object)13L));
        this.assertFunction("CAST(JSON '{\"1\": true, \"2\": false, \"3\": 12, \"5\": 0, \"8\": 12.3, \"13\": 0.0, \"21\": \"true\", \"34\": \"false\", \"55\": null}' AS MAP<BIGINT, BOOLEAN>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L, (Object)21L, (Object)34L, (Object)55L), Arrays.asList(true, false, true, false, true, false, true, false, null)));
        this.assertFunction("CAST(JSON '{\"1\": true, \"2\": false, \"3\": 12, \"5\": 12.7, \"8\": \"12\", \"13\": null}' AS MAP<BIGINT, TINYINT>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)TinyintType.TINYINT), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList((byte)1, (byte)0, (byte)12, (byte)13, (byte)12, null)));
        this.assertFunction("CAST(JSON '{\"1\": true, \"2\": false, \"3\": 12345, \"5\": 12345.6, \"8\": \"12345\", \"13\": null}' AS MAP<BIGINT, SMALLINT>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)SmallintType.SMALLINT), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList((short)1, (short)0, (short)12345, (short)12346, (short)12345, null)));
        this.assertFunction("CAST(JSON '{\"1\": true, \"2\": false, \"3\": 12345678, \"5\": 12345678.9, \"8\": \"12345678\", \"13\": null}' AS MAP<BIGINT, INTEGER>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList(1, 0, 12345678, 12345679, 12345678, null)));
        this.assertFunction("CAST(JSON '{\"1\": true, \"2\": false, \"3\": 1234567891234567, \"5\": 1234567891234567.8, \"8\": \"1234567891234567\", \"13\": null}' AS MAP<BIGINT, BIGINT>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList(1L, 0L, 1234567891234567L, 1234567891234568L, 1234567891234567L, null)));
        this.assertFunction("CAST(JSON '{\"1\": true, \"2\": false, \"3\": 12345, \"5\": 12345.67, \"8\": \"3.14\", \"13\": \"NaN\", \"21\": \"Infinity\", \"34\": \"-Infinity\", \"55\": null}' AS MAP<BIGINT, REAL>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)RealType.REAL), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L, (Object)21L, (Object)34L, (Object)55L), Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(12345.0f), Float.valueOf(12345.67f), Float.valueOf(3.14f), Float.valueOf(Float.NaN), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), null)));
        this.assertFunction("CAST(JSON '{\"1\": true, \"2\": false, \"3\": 1234567890, \"5\": 1234567890.1, \"8\": \"3.14\", \"13\": \"NaN\", \"21\": \"Infinity\", \"34\": \"-Infinity\", \"55\": null}' AS MAP<BIGINT, DOUBLE>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L, (Object)21L, (Object)34L, (Object)55L), Arrays.asList(1.0, 0.0, 1.23456789E9, 1.2345678901E9, 3.14, Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, null)));
        this.assertFunction("CAST(JSON '{\"1\": true, \"2\": false, \"3\": 128, \"5\": 123.456, \"8\": \"3.14\", \"13\": null}' AS MAP<BIGINT, DECIMAL(10, 5)>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)10, (int)5)), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList(TestMapOperators.decimal("1.00000"), TestMapOperators.decimal("0.00000"), TestMapOperators.decimal("128.00000"), TestMapOperators.decimal("123.45600"), TestMapOperators.decimal("3.14000"), null)));
        this.assertFunction("CAST(JSON '{\"1\": true, \"2\": false, \"3\": 128, \"5\": 12345678.12345678, \"8\": \"3.14\", \"13\": null}' AS MAP<BIGINT, DECIMAL(38, 8)>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)38, (int)8)), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList(TestMapOperators.decimal("1.00000000"), TestMapOperators.decimal("0.00000000"), TestMapOperators.decimal("128.00000000"), TestMapOperators.decimal("12345678.12345678"), TestMapOperators.decimal("3.14000000"), null)));
        this.assertFunction("CAST(JSON '{\"1\": true, \"2\": false, \"3\": 12, \"5\": 12.3, \"8\": \"puppies\", \"13\": \"kittens\", \"21\": \"null\", \"34\": \"\", \"55\": null}' AS MAP<BIGINT, VARCHAR>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L, (Object)21L, (Object)34L, (Object)55L), Arrays.asList("true", "false", "12", "12.3", "puppies", "kittens", "null", "", null)));
        this.assertFunction("CAST(JSON '{\"k1\": 5, \"k2\": 3.14, \"k3\":[1, 2, 3], \"k4\":\"e\", \"k5\":{\"a\": \"b\"}, \"k6\":null, \"k7\":\"null\", \"k8\":[null]}' AS MAP<VARCHAR, JSON>)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)JsonType.JSON), ImmutableMap.builder().put((Object)"k1", (Object)"5").put((Object)"k2", (Object)"3.14").put((Object)"k3", (Object)"[1,2,3]").put((Object)"k4", (Object)"\"e\"").put((Object)"k5", (Object)"{\"a\":\"b\"}").put((Object)"k6", (Object)"null").put((Object)"k7", (Object)"\"null\"").put((Object)"k8", (Object)"[null]").build());
        this.assertFunction("CAST(JSON '{\"k1\": {\"1klmnopq\":1, \"2klmnopq\":2, \"3klmnopq\":3, \"4klmnopq\":4, \"5klmnopq\":5, \"6klmnopq\":6, \"7klmnopq\":7}}' AS MAP<VARCHAR, JSON>)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)JsonType.JSON), ImmutableMap.of((Object)"k1", (Object)"{\"1klmnopq\":1,\"2klmnopq\":2,\"3klmnopq\":3,\"4klmnopq\":4,\"5klmnopq\":5,\"6klmnopq\":6,\"7klmnopq\":7}"));
        this.assertFunction("CAST(unchecked_to_json('{\"k1\": {\"7klmnopq\":7, \"6klmnopq\":6, \"5klmnopq\":5, \"4klmnopq\":4, \"3klmnopq\":3, \"2klmnopq\":2, \"1klmnopq\":1}}') AS MAP<VARCHAR, JSON>)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)JsonType.JSON), ImmutableMap.of((Object)"k1", (Object)"{\"7klmnopq\":7,\"6klmnopq\":6,\"5klmnopq\":5,\"4klmnopq\":4,\"3klmnopq\":3,\"2klmnopq\":2,\"1klmnopq\":1}"));
        this.assertFunction("CAST(JSON '{\"1\": [1, 2], \"2\": [3, null], \"3\": [], \"5\": [null, null], \"8\": null}' AS MAP<BIGINT, ARRAY<BIGINT>>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)BigintType.BIGINT)), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L), Arrays.asList(Arrays.asList(1L, 2L), Arrays.asList(3L, null), Collections.emptyList(), Arrays.asList(null, null), null)));
        this.assertFunction("CAST(JSON '{\"1\": {\"a\": 1, \"b\": 2}, \"2\": {\"none\": null, \"three\": 3}, \"3\": {}, \"5\": {\"h1\": null,\"h2\": null}, \"8\": null}' AS MAP<BIGINT, MAP<VARCHAR, BIGINT>>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), TestMapOperators.asMap(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L), Arrays.asList(ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)2L), TestMapOperators.asMap(ImmutableList.of((Object)"none", (Object)"three"), Arrays.asList(null, 3L)), ImmutableMap.of(), TestMapOperators.asMap(ImmutableList.of((Object)"h1", (Object)"h2"), Arrays.asList(null, null)), null)));
        this.assertFunction("CAST(JSON '{\"row1\": [1, \"two\"], \"row2\": [3, null], \"row3\": {\"k1\": 1, \"k2\": \"two\"}, \"row4\": {\"k2\": null, \"k1\": 3}, \"row5\": null}' AS MAP<VARCHAR, ROW(k1 BIGINT, k2 VARCHAR)>)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k2", (Type)VarcharType.VARCHAR)))), TestMapOperators.asMap(ImmutableList.of((Object)"row1", (Object)"row2", (Object)"row3", (Object)"row4", (Object)"row5"), Arrays.asList(Arrays.asList(1L, "two"), Arrays.asList(3L, null), Arrays.asList(1L, "two"), Arrays.asList(3L, null), null)));
        this.assertInvalidFunction("CAST(JSON '{\"[]\": 1}' AS MAP<ARRAY<BIGINT>, BIGINT>)", (ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, "line 1:1: Cannot cast json to map(array(bigint), bigint)");
        this.assertInvalidCast("CAST(JSON '[1, 2]' AS MAP<BIGINT, BIGINT>)", "Cannot cast to map(bigint, bigint). Expected a json object, but got [\n[1,2]");
        this.assertInvalidCast("CAST(JSON '{\"a\": 1, \"b\": 2}' AS MAP<VARCHAR, MAP<VARCHAR, BIGINT>>)", "Cannot cast to map(varchar, map(varchar, bigint)). Expected a json object, but got 1\n{\"a\":1,\"b\":2}");
        this.assertInvalidCast("CAST(JSON '{\"a\": 1, \"b\": []}' AS MAP<VARCHAR, BIGINT>)", "Cannot cast to map(varchar, bigint). Unexpected token when cast to bigint: [\n{\"a\":1,\"b\":[]}");
        this.assertInvalidCast("CAST(JSON '{\"1\": {\"a\": 1}, \"2\": []}' AS MAP<VARCHAR, MAP<VARCHAR, BIGINT>>)", "Cannot cast to map(varchar, map(varchar, bigint)). Expected a json object, but got [\n{\"1\":{\"a\":1},\"2\":[]}");
        this.assertInvalidCast("CAST(unchecked_to_json('\"a\": 1, \"b\": 2') AS MAP<VARCHAR, BIGINT>)", "Cannot cast to map(varchar, bigint). Expected a json object, but got a\n\"a\": 1, \"b\": 2");
        this.assertInvalidCast("CAST(unchecked_to_json('{\"a\": 1} 2') AS MAP<VARCHAR, BIGINT>)", "Cannot cast to map(varchar, bigint). Unexpected trailing token: 2\n{\"a\": 1} 2");
        this.assertInvalidCast("CAST(unchecked_to_json('{\"a\": 1') AS MAP<VARCHAR, BIGINT>)", "Cannot cast to map(varchar, bigint).\n{\"a\": 1");
        this.assertInvalidCast("CAST(JSON '{\"a\": \"b\"}' AS MAP<VARCHAR, BIGINT>)", "Cannot cast to map(varchar, bigint). Cannot cast 'b' to BIGINT\n{\"a\":\"b\"}");
        this.assertInvalidCast("CAST(JSON '{\"a\": 1234567890123.456}' AS MAP<VARCHAR, INTEGER>)", "Cannot cast to map(varchar, integer). Out of range for integer: 1.234567890123456E12\n{\"a\":1.234567890123456E12}");
        this.assertInvalidCast("CAST(JSON '{\"1\":1, \"01\": 2}' AS MAP<BIGINT, BIGINT>)", "Cannot cast to map(bigint, bigint). Duplicate keys are not allowed\n{\"01\":2,\"1\":1}");
        this.assertInvalidCast("CAST(JSON '[{\"1\":1, \"01\": 2}]' AS ARRAY<MAP<BIGINT, BIGINT>>)", "Cannot cast to array(map(bigint, bigint)). Duplicate keys are not allowed\n[{\"01\":2,\"1\":1}]");
        this.assertFunction("CAST(JSON '{\"puppies\":\"kittens\"}' AS MAP<VARCHAR, VARCHAR>)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)"puppies", (Object)"kittens"));
        this.assertFunction("CAST(JSON '{\"true\":\"kittens\"}' AS MAP<BOOLEAN, VARCHAR>)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)true, (Object)"kittens"));
        this.assertFunction("CAST(JSON 'null' AS MAP<BOOLEAN, VARCHAR>)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)VarcharType.VARCHAR), null);
        this.assertFunction("CAST(CAST(MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3]) AS JSON) AS MAP<DECIMAL(29,14), DECIMAL(2,1)>)", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)29, (int)14), (Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableMap.of((Object)TestMapOperators.decimal("000000000000001.00000000000000"), (Object)TestMapOperators.decimal("2.2"), (Object)TestMapOperators.decimal("383838383838383.12324234234234"), (Object)TestMapOperators.decimal("3.3")));
        this.assertFunction("CAST(CAST(MAP(ARRAY[2.2, 3.3], ARRAY[1.0, 383838383838383.12324234234234]) AS JSON) AS MAP<DECIMAL(2,1), DECIMAL(29,14)>)", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)29, (int)14)), ImmutableMap.of((Object)TestMapOperators.decimal("2.2"), (Object)TestMapOperators.decimal("000000000000001.00000000000000"), (Object)TestMapOperators.decimal("3.3"), (Object)TestMapOperators.decimal("383838383838383.12324234234234")));
        this.assertInvalidCast("CAST(CAST(MAP(ARRAY[12345.12345], ARRAY[12345.12345]) AS JSON) AS MAP<DECIMAL(2,1), DECIMAL(10,5)>)");
        this.assertInvalidCast("CAST(CAST(MAP(ARRAY[12345.12345], ARRAY[12345.12345]) AS JSON) AS MAP<DECIMAL(10,5), DECIMAL(2,1)>)");
    }

    @Test
    public void testElementAt() {
        this.assertFunction("element_at(MAP(CAST(ARRAY [] AS ARRAY(BIGINT)), CAST(ARRAY [] AS ARRAY(BIGINT))), 1)", (Type)BigintType.BIGINT, null);
        this.assertFunction("element_at(MAP(ARRAY [1], ARRAY [1e0]), 2)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("element_at(MAP(ARRAY [1.0], ARRAY ['a']), 2.0)", (Type)VarcharType.createVarcharType((int)1), null);
        this.assertFunction("element_at(MAP(ARRAY ['a'], ARRAY [true]), 'b')", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("element_at(MAP(ARRAY [true], ARRAY [ARRAY [1]]), false)", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("element_at(MAP(ARRAY [ARRAY [1]], ARRAY [1]), ARRAY [2])", (Type)IntegerType.INTEGER, null);
        this.assertFunction("element_at(MAP(ARRAY [1], ARRAY [null]), 1)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("element_at(MAP(ARRAY [1.0E0], ARRAY [null]), 1.0E0)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("element_at(MAP(ARRAY [TRUE], ARRAY [null]), TRUE)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("element_at(MAP(ARRAY ['puppies'], ARRAY [null]), 'puppies')", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("element_at(MAP(ARRAY [ARRAY [1]], ARRAY [null]), ARRAY [1])", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("element_at(MAP(ARRAY [1, 3], ARRAY [2, 4]), 3)", (Type)IntegerType.INTEGER, 4);
        this.assertFunction("element_at(MAP(ARRAY [BIGINT '1', 3], ARRAY [BIGINT '2', 4]), 3)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("element_at(MAP(ARRAY [1, 3], ARRAY [2, NULL]), 3)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("element_at(MAP(ARRAY [BIGINT '1', 3], ARRAY [2, NULL]), 3)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("element_at(MAP(ARRAY [1, 3], ARRAY [2.0E0, 4.0E0]), 1)", (Type)DoubleType.DOUBLE, 2.0);
        this.assertFunction("element_at(MAP(ARRAY [1.0E0, 2.0E0], ARRAY [ARRAY [1, 2], ARRAY [3]]), 1.0E0)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("element_at(MAP(ARRAY ['puppies'], ARRAY ['kittens']), 'puppies')", (Type)VarcharType.createVarcharType((int)7), "kittens");
        this.assertFunction("element_at(MAP(ARRAY [TRUE, FALSE], ARRAY [2, 4]), TRUE)", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("element_at(MAP(ARRAY [ARRAY [1, 2], ARRAY [3]], ARRAY [1e0, 2e0]), ARRAY [1, 2])", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("element_at(MAP(ARRAY ['1', '100'], ARRAY [TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '2005-09-10 13:00:00']), '1')", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0));
        this.assertFunction("element_at(MAP(ARRAY [from_unixtime(1), from_unixtime(100)], ARRAY [1.0E0, 100.0E0]), from_unixtime(1))", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("element_at(MAP(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '2222-05-10 12:34:56.123456789'], ARRAY [1, 2]), TIMESTAMP '2222-05-10 12:34:56.123456789')", (Type)IntegerType.INTEGER, 2);
    }

    @Test
    public void testSubscript() {
        this.assertFunction("MAP(ARRAY [1], ARRAY [null])[1]", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("MAP(ARRAY [1.0E0], ARRAY [null])[1.0E0]", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("MAP(ARRAY [TRUE], ARRAY [null])[TRUE]", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("MAP(ARRAY['puppies'], ARRAY [null])['puppies']", (Type)UnknownType.UNKNOWN, null);
        this.assertInvalidFunction("MAP(ARRAY [CAST(null as bigint)], ARRAY [1])", "map key cannot be null");
        this.assertInvalidFunction("MAP(ARRAY [CAST(null as bigint)], ARRAY [CAST(null as bigint)])", "map key cannot be null");
        this.assertInvalidFunction("MAP(ARRAY [1,null], ARRAY [null,2])", "map key cannot be null");
        this.assertFunction("MAP(ARRAY [1, 3], ARRAY [2, 4])[3]", (Type)IntegerType.INTEGER, 4);
        this.assertFunction("MAP(ARRAY [BIGINT '1', 3], ARRAY [BIGINT '2', 4])[3]", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("MAP(ARRAY [1, 3], ARRAY[2, NULL])[3]", (Type)IntegerType.INTEGER, null);
        this.assertFunction("MAP(ARRAY [BIGINT '1', 3], ARRAY[2, NULL])[3]", (Type)IntegerType.INTEGER, null);
        this.assertFunction("MAP(ARRAY [1, 3], ARRAY [2.0E0, 4.0E0])[1]", (Type)DoubleType.DOUBLE, 2.0);
        this.assertFunction("MAP(ARRAY[1.0E0, 2.0E0], ARRAY[ ARRAY[1, 2], ARRAY[3]])[1.0E0]", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("MAP(ARRAY['puppies'], ARRAY['kittens'])['puppies']", (Type)VarcharType.createVarcharType((int)7), "kittens");
        this.assertFunction("MAP(ARRAY[TRUE,FALSE],ARRAY[2,4])[TRUE]", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("MAP(ARRAY['1', '100'], ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01'])['1']", (Type)TimestampType.createTimestampType((int)0), DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0));
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[1.0E0, 100.0E0])[from_unixtime(1)]", (Type)DoubleType.DOUBLE, 1.0);
        this.assertInvalidFunction("MAP(ARRAY [BIGINT '1'], ARRAY [BIGINT '2'])[3]", "Key not present in map: 3");
        this.assertInvalidFunction("MAP(ARRAY ['hi'], ARRAY [2])['missing']", "Key not present in map: missing");
        this.assertFunction("MAP(ARRAY[array[1,1]], ARRAY['a'])[ARRAY[1,1]]", (Type)VarcharType.createVarcharType((int)1), "a");
        this.assertFunction("MAP(ARRAY[('a', 'b')], ARRAY[ARRAY[100, 200]])[('a', 'b')]", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)100, (Object)200));
        this.assertFunction("MAP(ARRAY[1.0], ARRAY [2.2])[1.0]", (Type)DecimalType.createDecimalType((int)2, (int)1), TestMapOperators.decimal("2.2"));
        this.assertFunction("MAP(ARRAY[000000000000001.00000000000000], ARRAY [2.2])[000000000000001.00000000000000]", (Type)DecimalType.createDecimalType((int)2, (int)1), TestMapOperators.decimal("2.2"));
        this.assertFunction("MAP(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '2222-05-10 12:34:56.123456789'], ARRAY [1, 2])[TIMESTAMP '2222-05-10 12:34:56.123456789']", (Type)IntegerType.INTEGER, 2);
    }

    @Test
    public void testMapKeys() {
        this.assertFunction("MAP_KEYS(MAP(ARRAY['1', '3'], ARRAY['2', '4']))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"1", (Object)"3"));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[1.0E0, 2.0E0], ARRAY[ARRAY[1, 2], ARRAY[3]]))", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)2.0));
        this.assertFunction("MAP_KEYS(MAP(ARRAY['puppies'], ARRAY['kittens']))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"puppies"));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[TRUE], ARRAY[2]))", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[TIMESTAMP '1970-01-01 00:00:01'], ARRAY[1.0E0]))", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)0)), ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[CAST('puppies' as varbinary)], ARRAY['kittens']))", (Type)new ArrayType((Type)VarbinaryType.VARBINARY), ImmutableList.of((Object)SqlVarbinaryTestingUtil.sqlVarbinary((String)"puppies")));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[1,2],  ARRAY[ARRAY[1, 2], ARRAY[3]]))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[1,4], ARRAY[MAP(ARRAY[2], ARRAY[3]), MAP(ARRAY[5], ARRAY[6])]))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)4));
        this.assertFunction("MAP_KEYS(MAP(ARRAY [ARRAY [1], ARRAY [2, 3]],  ARRAY [ARRAY [3, 4], ARRAY [5]]))", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2, (Object)3)));
        this.assertFunction("MAP_KEYS(MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3]))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)29, (int)14)), ImmutableList.of((Object)TestMapOperators.decimal("000000000000001.00000000000000"), (Object)TestMapOperators.decimal("383838383838383.12324234234234")));
        this.assertFunction("MAP_KEYS(MAP(ARRAY [1.0, 2.01], ARRAY [2.2, 3.3]))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)2)), ImmutableList.of((Object)TestMapOperators.decimal("1.00"), (Object)TestMapOperators.decimal("2.01")));
    }

    @Test
    public void testMapValues() {
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1'], ARRAY[ARRAY[TRUE, FALSE, NULL]]))", (Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN)), ImmutableList.of((Object)Lists.newArrayList((Object[])new Boolean[]{true, false, null})));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1'], ARRAY[ARRAY[ARRAY[1, 2]]]))", (Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))), ImmutableList.of((Object)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2))));
        this.assertFunction("MAP_VALUES(MAP(ARRAY [1, 3], ARRAY ['2', '4']))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"2", (Object)"4"));
        this.assertFunction("MAP_VALUES(MAP(ARRAY[1.0E0,2.0E0], ARRAY[ARRAY[1, 2], ARRAY[3]]))", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3)));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['puppies'], ARRAY['kittens']))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"kittens"));
        this.assertFunction("MAP_VALUES(MAP(ARRAY[TRUE], ARRAY[2]))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)2));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1'], ARRAY[NULL]))", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Lists.newArrayList((Object[])new Object[]{null}));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1'], ARRAY[TRUE]))", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1'], ARRAY[1.0E0]))", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1', '2'], ARRAY[ARRAY[1.0E0, 2.0E0], ARRAY[3.0E0, 4.0E0]]))", (Type)new ArrayType((Type)new ArrayType((Type)DoubleType.DOUBLE)), ImmutableList.of((Object)ImmutableList.of((Object)1.0, (Object)2.0), (Object)ImmutableList.of((Object)3.0, (Object)4.0)));
        this.assertFunction("MAP_VALUES(MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3]))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableList.of((Object)TestMapOperators.decimal("2.2"), (Object)TestMapOperators.decimal("3.3")));
        this.assertFunction("MAP_VALUES(MAP(ARRAY [1.0, 2.01], ARRAY [383838383838383.12324234234234, 3.3]))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)29, (int)14)), ImmutableList.of((Object)TestMapOperators.decimal("383838383838383.12324234234234"), (Object)TestMapOperators.decimal("000000000000003.30000000000000")));
    }

    @Test
    public void testEquals() {
        this.assertFunction("MAP(ARRAY[1], ARRAY[2]) = MAP(ARRAY[1], ARRAY[2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1], ARRAY[2]) = MAP(ARRAY[1], ARRAY[4])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[3], ARRAY[1]) = MAP(ARRAY[2], ARRAY[1])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[2.2], ARRAY[3.1]) = MAP(ARRAY[2.2], ARRAY[3.1])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[2.2], ARRAY[3.1]) = MAP(ARRAY[2.2], ARRAY[3.0])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000]) = MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000]) = MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000013.30000000000000])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1], ARRAY[2]) = MAP(ARRAY[1, 3], ARRAY[2, 4])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY[2, 4]) = MAP(ARRAY[1], ARRAY[2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY[2, 4]) = MAP(ARRAY[3, 1], ARRAY[4, 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY[2, 4]) = MAP(ARRAY[3, 1], ARRAY[2, 4])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY['1', '3'], ARRAY[2.0E0, 4.0E0]) = MAP(ARRAY['3', '1'], ARRAY[4.0E0, 2.0E0])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY['1', '3'], ARRAY[2.0E0, 4.0E0]) = MAP(ARRAY['3', '1'], ARRAY[2.0E0, 4.0E0])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[TRUE, FALSE], ARRAY['2', '4']) = MAP(ARRAY[FALSE, TRUE], ARRAY['4', '2'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[TRUE, FALSE], ARRAY['2', '4']) = MAP(ARRAY[FALSE, TRUE], ARRAY['2', '4'])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1.0E0, 3.0E0], ARRAY[TRUE, FALSE]) = MAP(ARRAY[3.0E0, 1.0E0], ARRAY[FALSE, TRUE])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1.0E0, 3.0E0], ARRAY[TRUE, FALSE]) = MAP(ARRAY[3.0E0, 1.0E0], ARRAY[TRUE, FALSE])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1.0E0, 3.0E0], ARRAY[from_unixtime(1), from_unixtime(100)]) = MAP(ARRAY[3.0E0, 1.0E0], ARRAY[from_unixtime(100), from_unixtime(1)])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1.0E0, 3.0E0], ARRAY[from_unixtime(1), from_unixtime(100)]) = MAP(ARRAY[3.0E0, 1.0E0], ARRAY[from_unixtime(1), from_unixtime(100)])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY['kittens', 'puppies']) = MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY['puppies', 'kittens'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY['kittens', 'puppies']) = MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY['kittens', 'puppies'])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]]) = MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]]) = MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[3], ARRAY[1, 2]])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['dog', 'cat']], ARRAY[ARRAY[1, 2], ARRAY[3]]) = MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['dog', 'cat']], ARRAY[ARRAY[1, 2], ARRAY[3]])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['dog', 'cat']], ARRAY[ARRAY[1, 2], ARRAY[3]]) = MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['dog', 'cat']], ARRAY[ARRAY[3], ARRAY[1, 2]])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['cat', 'dog']], ARRAY[ARRAY[1, 2], ARRAY[3]]) = MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['dog', 'cat']], ARRAY[ARRAY[1, 2], ARRAY[3]])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3]) = MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3]) = MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3]) = MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[3, 3]) = MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3]) = MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, NULL]) = MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[NULL, FALSE]) = MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY[FALSE, NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[TRUE, NULL]) = MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY[TRUE, NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, null]) = MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, null])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY [1.0, 2.1], ARRAY [null, null]) = MAP(ARRAY [1.0, 2.1], ARRAY [null, null])", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testNotEquals() {
        this.assertFunction("MAP(ARRAY[1], ARRAY[2]) != MAP(ARRAY[1], ARRAY[2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1], ARRAY[2]) != MAP(ARRAY[1], ARRAY[4])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[3], ARRAY[1]) != MAP(ARRAY[2], ARRAY[1])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[2.2], ARRAY[3.1]) != MAP(ARRAY[2.2], ARRAY[3.1])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[2.2], ARRAY[3.1]) != MAP(ARRAY[2.2], ARRAY[3.0])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000]) != MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000]) != MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000013.30000000000000])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1], ARRAY[2]) != MAP(ARRAY[1, 3], ARRAY[2, 4])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY[2, 4]) != MAP(ARRAY[1], ARRAY[2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY[2, 4]) != MAP(ARRAY[3, 1], ARRAY[4, 2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY[2, 4]) != MAP(ARRAY[3, 1], ARRAY[2, 4])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY['1', '3'], ARRAY[2.0E0, 4.0E0]) != MAP(ARRAY['3', '1'], ARRAY[4.0E0, 2.0E0])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY['1', '3'], ARRAY[2.0E0, 4.0E0]) != MAP(ARRAY['3', '1'], ARRAY[2.0E0, 4.0E0])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[TRUE, FALSE], ARRAY['2', '4']) != MAP(ARRAY[FALSE, TRUE], ARRAY['4', '2'])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[TRUE, FALSE], ARRAY['2', '4']) != MAP(ARRAY[FALSE, TRUE], ARRAY['2', '4'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1.0E0, 3.0E0], ARRAY[TRUE, FALSE]) != MAP(ARRAY[3.0E0, 1.0E0], ARRAY[FALSE, TRUE])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1.0E0, 3.0E0], ARRAY[TRUE, FALSE]) != MAP(ARRAY[3.0E0, 1.0E0], ARRAY[TRUE, FALSE])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1.0E0, 3.0E0], ARRAY[from_unixtime(1), from_unixtime(100)]) != MAP(ARRAY[3.0E0, 1.0E0], ARRAY[from_unixtime(100), from_unixtime(1)])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1.0E0, 3.0E0], ARRAY[from_unixtime(1), from_unixtime(100)]) != MAP(ARRAY[3.0E0, 1.0E0], ARRAY[from_unixtime(1), from_unixtime(100)])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY['kittens','puppies']) != MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY['puppies', 'kittens'])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY['kittens','puppies']) != MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY['kittens', 'puppies'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]]) != MAP(ARRAY['kittens','puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]]) != MAP(ARRAY['kittens','puppies'], ARRAY[ARRAY[3], ARRAY[1, 2]])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3]) != MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3]) != MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3]) != MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[3, 3]) != MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3]) != MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, NULL]) != MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[NULL, FALSE]) != MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY[FALSE, NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[TRUE, NULL]) != MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY[TRUE, NULL])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, null]) != MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, null])", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("MAP(ARRAY [1.0, 2.1], ARRAY [null, null]) != MAP(ARRAY [1.0, 2.1], ARRAY [null, null])", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testDistinctFrom() {
        this.assertFunction("CAST(NULL AS MAP<INTEGER, VARCHAR>) IS DISTINCT FROM CAST(NULL AS MAP<INTEGER, VARCHAR>)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1], ARRAY[2]) IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM MAP(ARRAY[1], ARRAY[2])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1], ARRAY[2]) IS DISTINCT FROM MAP(ARRAY[1], ARRAY[2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1], ARRAY[NULL]) IS DISTINCT FROM MAP(ARRAY[1], ARRAY[NULL])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1], ARRAY[0]) IS DISTINCT FROM MAP(ARRAY[1], ARRAY[NULL])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1], ARRAY[NULL]) IS DISTINCT FROM MAP(ARRAY[1], ARRAY[0])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1, 2], ARRAY['kittens','puppies']) IS DISTINCT FROM MAP(ARRAY[1, 2], ARRAY['puppies', 'kittens'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1, 2], ARRAY['kittens','puppies']) IS DISTINCT FROM MAP(ARRAY[1, 2], ARRAY['kittens', 'puppies'])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY['kittens','puppies']) IS DISTINCT FROM MAP(ARRAY[1, 2], ARRAY['kittens', 'puppies'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY['kittens','puppies']) IS DISTINCT FROM MAP(ARRAY[1, 2], ARRAY['kittens', 'pupp111'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY['kittens','puppies']) IS DISTINCT FROM MAP(ARRAY[1, 2], ARRAY['kittens', NULL])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY['kittens','puppies']) IS DISTINCT FROM MAP(ARRAY[1, 2], ARRAY[NULL, NULL])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY[MAP(ARRAY['kittens'], ARRAY[1e0]), MAP(ARRAY['puppies'], ARRAY[3e0])]) IS DISTINCT FROM MAP(ARRAY[1, 3], ARRAY[MAP(ARRAY['kittens'], ARRAY[1e0]), MAP(ARRAY['puppies'], ARRAY[3e0])])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("MAP(ARRAY[1, 3], ARRAY[MAP(ARRAY['kittens'], ARRAY[1e0]), MAP(ARRAY['puppies'], ARRAY[3e0])]) IS DISTINCT FROM MAP(ARRAY[1, 3], ARRAY[MAP(ARRAY['kittens'], ARRAY[1e0]), MAP(ARRAY['puppies'], ARRAY[4e0])])", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testMapConcat() {
        this.assertFunction("MAP_CONCAT(MAP (ARRAY [TRUE], ARRAY [1]), MAP (CAST(ARRAY [] AS ARRAY(BOOLEAN)), CAST(ARRAY [] AS ARRAY(INTEGER))))", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)true, (Object)1));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY [TRUE], ARRAY [1]), MAP (ARRAY [TRUE, FALSE], ARRAY [10, 20]))", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)true, (Object)10, (Object)false, (Object)20));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY [TRUE, FALSE], ARRAY [1, 2]), MAP (ARRAY [TRUE, FALSE], ARRAY [10, 20]))", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)true, (Object)10, (Object)false, (Object)20));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY [TRUE, FALSE], ARRAY [1, 2]), MAP (ARRAY [TRUE], ARRAY [10]))", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)true, (Object)10, (Object)false, (Object)2));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY ['1', '2', '3'], ARRAY [1, 2, 3]), MAP (ARRAY ['1', '2', '3', '4'], ARRAY [10, 20, 30, 40]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"1", (Object)10, (Object)"2", (Object)20, (Object)"3", (Object)30, (Object)"4", (Object)40));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY ['1', '2', '3', '4'], ARRAY [1, 2, 3, 4]), MAP (ARRAY ['1', '2', '3', '4'], ARRAY [10, 20, 30, 40]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"1", (Object)10, (Object)"2", (Object)20, (Object)"3", (Object)30, (Object)"4", (Object)40));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY ['1', '2', '3', '4'], ARRAY [1, 2, 3, 4]), MAP (ARRAY ['1', '2', '3'], ARRAY [10, 20, 30]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"1", (Object)10, (Object)"2", (Object)20, (Object)"3", (Object)30, (Object)"4", (Object)4));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY [1, 2, 3], ARRAY [ARRAY [1.0E0], ARRAY [2.0E0], ARRAY [3.0E0]]), MAP (ARRAY [1, 2, 3, 4], ARRAY [ARRAY [10.0E0], ARRAY [20.0E0], ARRAY [30.0E0], ARRAY [40.0E0]]))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)DoubleType.DOUBLE)), ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)10.0), (Object)2, (Object)ImmutableList.of((Object)20.0), (Object)3, (Object)ImmutableList.of((Object)30.0), (Object)4, (Object)ImmutableList.of((Object)40.0)));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY [1, 2, 3, 4], ARRAY [ARRAY [1.0E0], ARRAY [2.0E0], ARRAY [3.0E0], ARRAY [4.0E0]]), MAP (ARRAY [1, 2, 3, 4], ARRAY [ARRAY [10.0E0], ARRAY [20.0E0], ARRAY [30.0E0], ARRAY [40.0E0]]))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)DoubleType.DOUBLE)), ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)10.0), (Object)2, (Object)ImmutableList.of((Object)20.0), (Object)3, (Object)ImmutableList.of((Object)30.0), (Object)4, (Object)ImmutableList.of((Object)40.0)));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY [1, 2, 3, 4], ARRAY [ARRAY [1.0E0], ARRAY [2.0E0], ARRAY [3.0E0], ARRAY [4.0E0]]), MAP (ARRAY [1, 2, 3], ARRAY [ARRAY [10.0E0], ARRAY [20.0E0], ARRAY [30.0E0]]))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)DoubleType.DOUBLE)), ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)10.0), (Object)2, (Object)ImmutableList.of((Object)20.0), (Object)3, (Object)ImmutableList.of((Object)30.0), (Object)4, (Object)ImmutableList.of((Object)4.0)));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY [ARRAY [1.0E0], ARRAY [2.0E0], ARRAY [3.0E0]], ARRAY ['1', '2', '3']), MAP (ARRAY [ARRAY [1.0E0], ARRAY [2.0E0], ARRAY [3.0E0], ARRAY [4.0E0]], ARRAY ['10', '20', '30', '40']))", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)DoubleType.DOUBLE), (Type)VarcharType.createVarcharType((int)2)), ImmutableMap.of((Object)ImmutableList.of((Object)1.0), (Object)"10", (Object)ImmutableList.of((Object)2.0), (Object)"20", (Object)ImmutableList.of((Object)3.0), (Object)"30", (Object)ImmutableList.of((Object)4.0), (Object)"40"));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY [ARRAY [1.0E0], ARRAY [2.0E0], ARRAY [3.0E0]], ARRAY ['1', '2', '3']), MAP (ARRAY [ARRAY [1.0E0], ARRAY [2.0E0], ARRAY [3.0E0], ARRAY [4.0E0]], ARRAY ['10', '20', '30', '40']))", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)DoubleType.DOUBLE), (Type)VarcharType.createVarcharType((int)2)), ImmutableMap.of((Object)ImmutableList.of((Object)1.0), (Object)"10", (Object)ImmutableList.of((Object)2.0), (Object)"20", (Object)ImmutableList.of((Object)3.0), (Object)"30", (Object)ImmutableList.of((Object)4.0), (Object)"40"));
        this.assertFunction("MAP_CONCAT(MAP (ARRAY [ARRAY [1.0E0], ARRAY [2.0E0], ARRAY [3.0E0], ARRAY [4.0E0]], ARRAY ['1', '2', '3', '4']), MAP (ARRAY [ARRAY [1.0E0], ARRAY [2.0E0], ARRAY [3.0E0]], ARRAY ['10', '20', '30']))", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)DoubleType.DOUBLE), (Type)VarcharType.createVarcharType((int)2)), ImmutableMap.of((Object)ImmutableList.of((Object)1.0), (Object)"10", (Object)ImmutableList.of((Object)2.0), (Object)"20", (Object)ImmutableList.of((Object)3.0), (Object)"30", (Object)ImmutableList.of((Object)4.0), (Object)"4"));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY[1], ARRAY[-1]), NULL, MAP(ARRAY[3], ARRAY[-3]))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), null);
        this.assertFunction("MAP_CONCAT(MAP(ARRAY[1], ARRAY[-1]), MAP(ARRAY[2], ARRAY[-2]), MAP(ARRAY[3], ARRAY[-3]))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1, (Object)-1, (Object)2, (Object)-2, (Object)3, (Object)-3));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY[1], ARRAY[-1]), MAP(ARRAY[1], ARRAY[-2]), MAP(ARRAY[1], ARRAY[-3]))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1, (Object)-3));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY[1], ARRAY[-1]), MAP(ARRAY[], ARRAY[]), MAP(ARRAY[3], ARRAY[-3]))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1, (Object)-1, (Object)3, (Object)-3));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY[], ARRAY[]), MAP(ARRAY['a_string'], ARRAY['b_string']), cast(MAP(ARRAY[], ARRAY[]) AS MAP(VARCHAR, VARCHAR)))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)"a_string", (Object)"b_string"));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY[], ARRAY[]), MAP(ARRAY[], ARRAY[]), MAP(ARRAY[], ARRAY[]))", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("MAP_CONCAT(MAP(), MAP(), MAP())", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("MAP_CONCAT(MAP(ARRAY[1], ARRAY[-1]), MAP(), MAP(ARRAY[3], ARRAY[-3]))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1, (Object)-1, (Object)3, (Object)-3));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY[TRUE], ARRAY[1]), MAP(ARRAY[TRUE, FALSE], ARRAY[10, 20]), MAP(ARRAY[FALSE], ARRAY[0]))", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)true, (Object)10, (Object)false, (Object)0));
        this.assertCachedInstanceHasBoundedRetainedSize("MAP_CONCAT(MAP (ARRAY ['1', '2', '3'], ARRAY [1, 2, 3]), MAP (ARRAY ['1', '2', '3', '4'], ARRAY [10, 20, 30, 40]))");
        this.assertFunction("MAP_CONCAT(MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.2, 3.3]), MAP(ARRAY [1.0, 383838383838383.12324234234234], ARRAY [2.1, 3.2]))", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)29, (int)14), (Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableMap.of((Object)TestMapOperators.decimal("000000000000001.00000000000000"), (Object)TestMapOperators.decimal("2.1"), (Object)TestMapOperators.decimal("383838383838383.12324234234234"), (Object)TestMapOperators.decimal("3.2")));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY [1.0], ARRAY [2.2]), MAP(ARRAY [5.1], ARRAY [3.2]))", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableMap.of((Object)TestMapOperators.decimal("1.0"), (Object)TestMapOperators.decimal("2.2"), (Object)TestMapOperators.decimal("5.1"), (Object)TestMapOperators.decimal("3.2")));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY [1.0], ARRAY [2.2]), MAP(ARRAY [5.1], ARRAY [33.2]))", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)3, (int)1)), ImmutableMap.of((Object)TestMapOperators.decimal("1.0"), (Object)TestMapOperators.decimal("2.2"), (Object)TestMapOperators.decimal("5.1"), (Object)TestMapOperators.decimal("33.2")));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY [1.0], ARRAY [2.2]), MAP(ARRAY [55.1], ARRAY [33.2]))", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)3, (int)1), (Type)DecimalType.createDecimalType((int)3, (int)1)), ImmutableMap.of((Object)TestMapOperators.decimal("01.0"), (Object)TestMapOperators.decimal("2.2"), (Object)TestMapOperators.decimal("55.1"), (Object)TestMapOperators.decimal("33.2")));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY [1.0], ARRAY [2.2]), MAP(ARRAY [5.1], ARRAY [33.22]))", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)4, (int)2)), ImmutableMap.of((Object)TestMapOperators.decimal("5.1"), (Object)TestMapOperators.decimal("33.22"), (Object)TestMapOperators.decimal("1.0"), (Object)TestMapOperators.decimal("2.20")));
        this.assertFunction("MAP_CONCAT(MAP(ARRAY [1.0], ARRAY [2.2]), MAP(ARRAY [5.1], ARRAY [00000000000000002.2]))", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableMap.of((Object)TestMapOperators.decimal("1.0"), (Object)TestMapOperators.decimal("2.2"), (Object)TestMapOperators.decimal("5.1"), (Object)TestMapOperators.decimal("2.2")));
    }

    @Test
    public void testMapToMapCast() {
        this.assertFunction("CAST(MAP(ARRAY[1], ARRAY[MAP(ARRAY[1.0E0], ARRAY[false])]) AS MAP<varchar, MAP(bigint,bigint)>)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)), ImmutableMap.of((Object)"1", (Object)ImmutableMap.of((Object)1L, (Object)0L)));
        this.assertFunction("CAST(MAP(ARRAY['1', '100'], ARRAY[true, false]) AS MAP<varchar,bigint>)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT), ImmutableMap.of((Object)"1", (Object)1L, (Object)"100", (Object)0L));
        this.assertFunction("CAST(MAP(ARRAY[1,2], ARRAY[1,2]) AS MAP<bigint, boolean>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)1L, (Object)true, (Object)2L, (Object)true));
        this.assertFunction("CAST(MAP(ARRAY[1,2], ARRAY[array[1],array[2]]) AS MAP<bigint, array<boolean>>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)BooleanType.BOOLEAN)), ImmutableMap.of((Object)1L, (Object)ImmutableList.of((Object)true), (Object)2L, (Object)ImmutableList.of((Object)true)));
        this.assertFunction("CAST(MAP(ARRAY[1], ARRAY[MAP(ARRAY[1.0E0], ARRAY[false])]) AS MAP<varchar, MAP(bigint,bigint)>)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)), ImmutableMap.of((Object)"1", (Object)ImmutableMap.of((Object)1L, (Object)0L)));
        this.assertFunction("CAST(MAP(ARRAY[1,2], ARRAY[DATE '2016-01-02', DATE '2016-02-03']) AS MAP(bigint, varchar))", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)1L, (Object)"2016-01-02", (Object)2L, (Object)"2016-02-03"));
        this.assertFunction("CAST(MAP(ARRAY[1,2], ARRAY[TIMESTAMP '2016-01-02 01:02:03', TIMESTAMP '2016-02-03 03:04:05']) AS MAP(bigint, varchar))", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)1L, (Object)"2016-01-02 01:02:03", (Object)2L, (Object)"2016-02-03 03:04:05"));
        this.assertFunction("CAST(MAP(ARRAY['123', '456'], ARRAY[1.23456E0, 2.34567E0]) AS MAP(integer, real))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)RealType.REAL), ImmutableMap.of((Object)123, (Object)Float.valueOf(1.23456f), (Object)456, (Object)Float.valueOf(2.34567f)));
        this.assertFunction("CAST(MAP(ARRAY['123', '456'], ARRAY[1.23456E0, 2.34567E0]) AS MAP(smallint, decimal(6,5)))", (Type)StructuralTestUtil.mapType((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)6, (int)5)), ImmutableMap.of((Object)123, (Object)SqlDecimal.of((String)"1.23456"), (Object)456, (Object)SqlDecimal.of((String)"2.34567")));
        this.assertFunction("CAST(MAP(ARRAY[json '1'], ARRAY[1]) AS MAP(bigint, bigint))", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), ImmutableMap.of((Object)1L, (Object)1L));
        this.assertFunction("CAST(MAP(ARRAY['1'], ARRAY[json '1']) AS MAP(bigint, bigint))", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), ImmutableMap.of((Object)1L, (Object)1L));
        HashMap<Long, Double> expected = new HashMap<Long, Double>();
        expected.put(0L, 1.0);
        expected.put(1L, null);
        expected.put(2L, null);
        expected.put(3L, 2.0);
        this.assertFunction("CAST(MAP(ARRAY[0, 1, 2, 3], ARRAY[1,NULL, NULL, 2]) AS MAP<BIGINT, DOUBLE>)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE), expected);
        this.assertInvalidCast("CAST(MAP(ARRAY[1, 2], ARRAY[6, 9]) AS MAP<boolean, bigint>)", "duplicate keys");
        this.assertInvalidCast("CAST(MAP(ARRAY[json 'null'], ARRAY[1]) AS MAP<bigint, bigint>)", "map key is null");
    }

    @Test
    public void testMapFromEntries() {
        this.assertFunction("map_from_entries(null)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), null);
        this.assertFunction("map_from_entries(ARRAY[])", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("map_from_entries(CAST(ARRAY[] AS ARRAY(ROW(DOUBLE, BIGINT))))", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT), ImmutableMap.of());
        this.assertFunction("map_from_entries(ARRAY[(1, 3)])", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1, (Object)3));
        this.assertFunction("map_from_entries(ARRAY[(1, 'x'), (2, 'y')])", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1)), ImmutableMap.of((Object)1, (Object)"x", (Object)2, (Object)"y"));
        this.assertFunction("map_from_entries(ARRAY[('x', 1.0E0), ('y', 2.0E0)])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)"x", (Object)1.0, (Object)"y", (Object)2.0));
        this.assertFunction("map_from_entries(ARRAY[('x', ARRAY[1, 2]), ('y', ARRAY[3, 4])])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2), (Object)"y", (Object)ImmutableList.of((Object)3, (Object)4)));
        this.assertFunction("map_from_entries(ARRAY[(ARRAY[1, 2], 'x'), (ARRAY[3, 4], 'y')])", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)VarcharType.createVarcharType((int)1)), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)"x", (Object)ImmutableList.of((Object)3, (Object)4), (Object)"y"));
        this.assertFunction("map_from_entries(ARRAY[('x', MAP(ARRAY[1], ARRAY[2])), ('y', MAP(ARRAY[3], ARRAY[4]))])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), ImmutableMap.of((Object)"x", (Object)ImmutableMap.of((Object)1, (Object)2), (Object)"y", (Object)ImmutableMap.of((Object)3, (Object)4)));
        this.assertFunction("map_from_entries(ARRAY[(MAP(ARRAY[1], ARRAY[2]), 'x'), (MAP(ARRAY[3], ARRAY[4]), 'y')])", (Type)StructuralTestUtil.mapType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)VarcharType.createVarcharType((int)1)), ImmutableMap.of((Object)ImmutableMap.of((Object)1, (Object)2), (Object)"x", (Object)ImmutableMap.of((Object)3, (Object)4), (Object)"y"));
        HashMap<String, Object> expectedNullValueMap = new HashMap<String, Object>();
        expectedNullValueMap.put("x", null);
        expectedNullValueMap.put("y", null);
        this.assertFunction("map_from_entries(ARRAY[('x', null), ('y', null)])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)UnknownType.UNKNOWN), expectedNullValueMap);
        this.assertInvalidFunction("map_from_entries(ARRAY[('a', 1), ('a', 2)])", "Duplicate keys (a) are not allowed");
        this.assertInvalidFunction("map_from_entries(ARRAY[(1, 1), (1, 2)])", "Duplicate keys (1) are not allowed");
        this.assertInvalidFunction("map_from_entries(ARRAY[(1.0, 1), (1.0, 2)])", "Duplicate keys (1.0) are not allowed");
        this.assertInvalidFunction("map_from_entries(ARRAY[(ARRAY[1, 2], 1), (ARRAY[1, 2], 2)])", "Duplicate keys ([1, 2]) are not allowed");
        this.assertInvalidFunction("map_from_entries(ARRAY[(MAP(ARRAY[1], ARRAY[2]), 1), (MAP(ARRAY[1], ARRAY[2]), 2)])", "Duplicate keys ({1=2}) are not allowed");
        this.assertInvalidFunction("map_from_entries(ARRAY[(null, 1), (null, 2)])", "map key cannot be null");
        this.assertInvalidFunction("map_from_entries(ARRAY[null])", "map entry cannot be null");
        this.assertInvalidFunction("map_from_entries(ARRAY[(1, 2), null])", "map entry cannot be null");
        this.assertCachedInstanceHasBoundedRetainedSize("map_from_entries(ARRAY[('a', 1.0), ('b', 2.0), ('c', 3.0), ('d', 4.0), ('e', 5.0), ('f', 6.0)])");
    }

    @Test
    public void testMultimapFromEntries() {
        this.assertFunction("multimap_from_entries(null)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)new ArrayType((Type)UnknownType.UNKNOWN)), null);
        this.assertFunction("multimap_from_entries(ARRAY[])", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)new ArrayType((Type)UnknownType.UNKNOWN)), ImmutableMap.of());
        this.assertFunction("multimap_from_entries(CAST(ARRAY[] AS ARRAY(ROW(DOUBLE, BIGINT))))", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)BigintType.BIGINT)), ImmutableMap.of());
        this.assertFunction("multimap_from_entries(ARRAY[(1, 3), (2, 4), (1, 6), (1, 8), (2, 10)])", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)3, (Object)6, (Object)8), (Object)2, (Object)ImmutableList.of((Object)4, (Object)10)));
        this.assertFunction("multimap_from_entries(ARRAY[(1, 'x'), (2, 'y'), (1, 'a'), (3, 'b'), (2, 'c'), (3, null)])", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)"x", (Object)"a"), (Object)2, (Object)ImmutableList.of((Object)"y", (Object)"c"), (Object)3, Arrays.asList("b", null)));
        this.assertFunction("multimap_from_entries(ARRAY[('x', 1.0E0), ('y', 2.0E0), ('z', null), ('x', 1.5E0), ('y', 2.5E0)])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)new ArrayType((Type)DoubleType.DOUBLE)), ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1.0, (Object)1.5), (Object)"y", (Object)ImmutableList.of((Object)2.0, (Object)2.5), (Object)"z", Collections.singletonList(null)));
        this.assertInvalidFunction("multimap_from_entries(ARRAY[(null, 1), (null, 2)])", "map key cannot be null");
        this.assertInvalidFunction("multimap_from_entries(ARRAY[null])", "map entry cannot be null");
        this.assertInvalidFunction("multimap_from_entries(ARRAY[(1, 2), null])", "map entry cannot be null");
        this.assertCachedInstanceHasBoundedRetainedSize("multimap_from_entries(ARRAY[('a', 1.0), ('b', 2.0), ('a', 3.0), ('c', 4.0), ('b', 5.0), ('c', 6.0)])");
    }

    @Test
    public void testMapEntries() {
        Type unknownEntryType = TestMapOperators.entryType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN);
        this.assertFunction("map_entries(null)", unknownEntryType, null);
        this.assertFunction("map_entries(MAP(ARRAY[], null))", unknownEntryType, null);
        this.assertFunction("map_entries(MAP(null, ARRAY[]))", unknownEntryType, null);
        this.assertFunction("map_entries(MAP(ARRAY[1, 2, 3], null))", TestMapOperators.entryType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN), null);
        this.assertFunction("map_entries(MAP(null, ARRAY[1, 2, 3]))", TestMapOperators.entryType((Type)UnknownType.UNKNOWN, (Type)IntegerType.INTEGER), null);
        this.assertFunction("map_entries(MAP(ARRAY[], ARRAY[]))", unknownEntryType, ImmutableList.of());
        this.assertFunction("map_entries(MAP(ARRAY[1], ARRAY['x']))", TestMapOperators.entryType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"x")));
        this.assertFunction("map_entries(MAP(ARRAY[1, 2], ARRAY['x', 'y']))", TestMapOperators.entryType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"x"), (Object)ImmutableList.of((Object)2, (Object)"y")));
        this.assertFunction("map_entries(MAP(ARRAY['x', 'y'], ARRAY[ARRAY[1, 2], ARRAY[3, 4]]))", TestMapOperators.entryType((Type)VarcharType.createVarcharType((int)1), (Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2)), (Object)ImmutableList.of((Object)"y", (Object)ImmutableList.of((Object)3, (Object)4))));
        this.assertFunction("map_entries(MAP(ARRAY[ARRAY[1.0E0, 2.0E0], ARRAY[3.0E0, 4.0E0]], ARRAY[5.0E0, 6.0E0]))", TestMapOperators.entryType((Type)new ArrayType((Type)DoubleType.DOUBLE), (Type)DoubleType.DOUBLE), ImmutableList.of((Object)ImmutableList.of((Object)ImmutableList.of((Object)1.0, (Object)2.0), (Object)5.0), (Object)ImmutableList.of((Object)ImmutableList.of((Object)3.0, (Object)4.0), (Object)6.0)));
        this.assertFunction("map_entries(MAP(ARRAY['x', 'y'], ARRAY[MAP(ARRAY[1], ARRAY[2]), MAP(ARRAY[3], ARRAY[4])]))", TestMapOperators.entryType((Type)VarcharType.createVarcharType((int)1), (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)"x", (Object)ImmutableMap.of((Object)1, (Object)2)), (Object)ImmutableList.of((Object)"y", (Object)ImmutableMap.of((Object)3, (Object)4))));
        this.assertFunction("map_entries(MAP(ARRAY[MAP(ARRAY[1], ARRAY[2]), MAP(ARRAY[3], ARRAY[4])], ARRAY['x', 'y']))", TestMapOperators.entryType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)ImmutableList.of((Object)ImmutableMap.of((Object)1, (Object)2), (Object)"x"), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)3, (Object)4), (Object)"y")));
        ImmutableList expectedEntries = ImmutableList.of(Arrays.asList("x", null), Arrays.asList("y", null));
        this.assertFunction("map_entries(MAP(ARRAY['x', 'y'], ARRAY[null, null]))", TestMapOperators.entryType((Type)VarcharType.createVarcharType((int)1), (Type)UnknownType.UNKNOWN), expectedEntries);
        this.assertCachedInstanceHasBoundedRetainedSize("map_entries(MAP(ARRAY[1, 2], ARRAY['x', 'y']))");
    }

    @Test
    public void testEntryMappings() {
        this.assertFunction("map_from_entries(map_entries(MAP(ARRAY[1, 2, 3], ARRAY['x', 'y', 'z'])))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1)), ImmutableMap.of((Object)1, (Object)"x", (Object)2, (Object)"y", (Object)3, (Object)"z"));
        this.assertFunction("map_entries(map_from_entries(ARRAY[(1, 'x'), (2, 'y'), (3, 'z')]))", TestMapOperators.entryType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"x"), (Object)ImmutableList.of((Object)2, (Object)"y"), (Object)ImmutableList.of((Object)3, (Object)"z")));
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as map(bigint, bigint))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1,2], array[3,4])", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1,2], array[1.0,2.0])", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1,2], array[null, 3])", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1,2], array[null, 3.0])", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1,2], array[array[11], array[22]])", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1,2], array[array[11], array[null]])", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1,2], array[array[11], array[22,null]])", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1,2], array[array[11, null], array[22,null]])", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1,2], array[array[null], array[null]])", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[array[1], array[2]], array[array[11], array[22]])", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[row(1), row(2)], array[array[11], array[22]])", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[row(1), row(2)], array[array[11], array[22, null]])", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1E0, 2E0], array[11E0, null])", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[1E0, 2E0], array[11E0, 12E0])", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array['a', 'b'], array['c', null])", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array['a', 'b'], array['c', 'd'])", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[true,false], array[false,true])", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "map(array[true,false], array[false,null])", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testMapHashOperator() {
        this.assertMapHashOperator("MAP(ARRAY[1], ARRAY[2])", (Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, (List<Object>)ImmutableList.of((Object)1, (Object)2));
        this.assertMapHashOperator("MAP(ARRAY[1, 2147483647], ARRAY[2147483647, 2])", (Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, (List<Object>)ImmutableList.of((Object)1, (Object)Integer.MAX_VALUE, (Object)Integer.MAX_VALUE, (Object)2));
        this.assertMapHashOperator("MAP(ARRAY[8589934592], ARRAY[2])", (Type)BigintType.BIGINT, (Type)IntegerType.INTEGER, (List<Object>)ImmutableList.of((Object)0x200000000L, (Object)2));
        this.assertMapHashOperator("MAP(ARRAY[true], ARRAY[false])", (Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN, (List<Object>)ImmutableList.of((Object)true, (Object)false));
        this.assertMapHashOperator("MAP(ARRAY['123'], ARRAY['456'])", (Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)"123"), (Object)Slices.utf8Slice((String)"456")));
    }

    private void assertMapHashOperator(String inputString, Type keyType, Type valueType, List<Object> elements) {
        Preconditions.checkArgument((elements.size() % 2 == 0 ? 1 : 0) != 0, (Object)"the size of elements should be even number");
        MapType mapType = StructuralTestUtil.mapType(keyType, valueType);
        BlockBuilder mapArrayBuilder = mapType.createBlockBuilder(null, 1);
        BlockBuilder singleMapWriter = mapArrayBuilder.beginBlockEntry();
        for (int i = 0; i < elements.size(); i += 2) {
            StructuralTestUtil.appendToBlockBuilder(keyType, elements.get(i), singleMapWriter);
            StructuralTestUtil.appendToBlockBuilder(valueType, elements.get(i + 1), singleMapWriter);
        }
        mapArrayBuilder.closeEntry();
        long hashResult = this.functionAssertions.getBlockTypeOperators().getHashCodeOperator((Type)mapType).hashCode(mapArrayBuilder.build(), 0);
        this.assertOperator(OperatorType.HASH_CODE, inputString, (Type)BigintType.BIGINT, hashResult);
        long xxHash64Result = this.functionAssertions.getBlockTypeOperators().getXxHash64Operator((Type)mapType).xxHash64(mapArrayBuilder.build(), 0);
        this.assertOperator(OperatorType.XX_HASH_64, inputString, (Type)BigintType.BIGINT, xxHash64Result);
    }

    private static Type entryType(Type keyType, Type valueType) {
        return new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)keyType, (Object)valueType)));
    }
}

