/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.iterative.GroupReference;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OptimizeDuplicateInsensitiveJoins
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(aggregation -> aggregation.getAggregations().isEmpty());
    private final Metadata metadata;

    public OptimizeDuplicateInsensitiveJoins(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isOptimizeDuplicateInsensitiveJoins(session);
    }

    @Override
    public Rule.Result apply(AggregationNode aggregation, Captures captures, Rule.Context context) {
        return aggregation.getSource().accept(new Rewriter(this.metadata, context.getLookup()), null).map(rewrittenSource -> Rule.Result.ofPlanNode(aggregation.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource)))).orElse(Rule.Result.empty());
    }

    private static class Rewriter
    extends PlanVisitor<Optional<PlanNode>, Void> {
        private final Metadata metadata;
        private final Lookup lookup;

        private Rewriter(Metadata metadata, Lookup lookup) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        protected Optional<PlanNode> visitPlan(PlanNode node, Void context) {
            return Optional.empty();
        }

        @Override
        public Optional<PlanNode> visitFilter(FilterNode node, Void context) {
            if (!DeterminismEvaluator.isDeterministic(node.getPredicate(), this.metadata)) {
                return Optional.empty();
            }
            return node.getSource().accept(this, null).map(source -> node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)source)));
        }

        @Override
        public Optional<PlanNode> visitProject(ProjectNode node, Void context) {
            boolean isDeterministic = node.getAssignments().getExpressions().stream().allMatch(expression -> DeterminismEvaluator.isDeterministic(expression, this.metadata));
            if (!isDeterministic) {
                return Optional.empty();
            }
            return node.getSource().accept(this, null).map(source -> node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)source)));
        }

        @Override
        public Optional<PlanNode> visitJoin(JoinNode node, Void context) {
            if (!DeterminismEvaluator.isDeterministic(node.getFilter().orElse((Expression)BooleanLiteral.TRUE_LITERAL), this.metadata)) {
                if (node.isMaySkipOutputDuplicates()) {
                    return Optional.empty();
                }
                return Optional.of(node.withMaySkipOutputDuplicates());
            }
            Optional<PlanNode> rewrittenLeft = node.getLeft().accept(this, null);
            Optional<PlanNode> rewrittenRight = node.getRight().accept(this, null);
            if (node.isMaySkipOutputDuplicates() && rewrittenLeft.isEmpty() && rewrittenRight.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(node.withMaySkipOutputDuplicates().replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenLeft.orElse(node.getLeft()), (Object)rewrittenRight.orElse(node.getRight()))));
        }

        @Override
        public Optional<PlanNode> visitGroupReference(GroupReference node, Void context) {
            return this.lookup.resolve(node).accept(this, null);
        }
    }
}

