/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.AggregationDecorrelation;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.optimizations.PlanNodeDecorrelator;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TransformCorrelatedGlobalAggregationWithoutProjection
implements Rule<CorrelatedJoinNode> {
    private static final Capture<AggregationNode> AGGREGATION = Capture.newCapture();
    private static final Capture<PlanNode> SOURCE = Capture.newCapture();
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Pattern.nonEmpty(Patterns.CorrelatedJoin.correlation())).with(Patterns.CorrelatedJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL)).with(Patterns.CorrelatedJoin.subquery().matching(Patterns.aggregation().with(Pattern.empty(Patterns.Aggregation.groupingColumns())).with(Patterns.source().capturedAs(SOURCE)).capturedAs(AGGREGATION)));
    private final PlannerContext plannerContext;

    public TransformCorrelatedGlobalAggregationWithoutProjection(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        PlanNodeDecorrelator decorrelator;
        Optional<PlanNodeDecorrelator.DecorrelatedNode> decorrelatedSource;
        Preconditions.checkArgument((correlatedJoinNode.getType() == CorrelatedJoinNode.Type.INNER || correlatedJoinNode.getType() == CorrelatedJoinNode.Type.LEFT ? 1 : 0) != 0, (Object)("unexpected correlated join type: " + correlatedJoinNode.getType()));
        PlanNode source = (PlanNode)captures.get(SOURCE);
        AggregationNode distinct = null;
        if (AggregationDecorrelation.isDistinctOperator(source)) {
            distinct = (AggregationNode)source;
            source = distinct.getSource();
        }
        if ((decorrelatedSource = (decorrelator = new PlanNodeDecorrelator(this.plannerContext, context.getSymbolAllocator(), context.getLookup())).decorrelateFilters(source, correlatedJoinNode.getCorrelation())).isEmpty()) {
            return Rule.Result.empty();
        }
        source = decorrelatedSource.get().getNode();
        Symbol nonNull = context.getSymbolAllocator().newSymbol("non_null", (Type)BooleanType.BOOLEAN);
        source = new ProjectNode(context.getIdAllocator().getNextId(), source, Assignments.builder().putIdentities(source.getOutputSymbols()).put(nonNull, (Expression)BooleanLiteral.TRUE_LITERAL).build());
        AssignUniqueId inputWithUniqueId = new AssignUniqueId(context.getIdAllocator().getNextId(), correlatedJoinNode.getInput(), context.getSymbolAllocator().newSymbol("unique", (Type)BigintType.BIGINT));
        JoinNode join = new JoinNode(context.getIdAllocator().getNextId(), JoinNode.Type.LEFT, inputWithUniqueId, source, (List<JoinNode.EquiJoinClause>)ImmutableList.of(), ((PlanNode)inputWithUniqueId).getOutputSymbols(), source.getOutputSymbols(), false, decorrelatedSource.get().getCorrelatedPredicates(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty());
        PlanNode root = join;
        if (distinct != null) {
            root = new AggregationNode(distinct.getId(), join, distinct.getAggregations(), AggregationNode.singleGroupingSet((List<Symbol>)ImmutableList.builder().addAll(join.getLeftOutputSymbols()).add((Object)nonNull).addAll(distinct.getGroupingKeys()).build()), (List<Symbol>)ImmutableList.of(), distinct.getStep(), Optional.empty(), Optional.empty());
        }
        AggregationNode globalAggregation = (AggregationNode)captures.get(AGGREGATION);
        ImmutableMap.Builder masks = ImmutableMap.builder();
        Assignments.Builder assignmentsBuilder = Assignments.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : globalAggregation.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            if (aggregation.getMask().isPresent()) {
                Symbol newMask = context.getSymbolAllocator().newSymbol("mask", (Type)BooleanType.BOOLEAN);
                Expression expression = ExpressionUtils.and(new Expression[]{aggregation.getMask().get().toSymbolReference(), nonNull.toSymbolReference()});
                assignmentsBuilder.put(newMask, expression);
                masks.put((Object)entry.getKey(), (Object)newMask);
                continue;
            }
            masks.put((Object)entry.getKey(), (Object)nonNull);
        }
        Assignments maskAssignments = assignmentsBuilder.build();
        if (!maskAssignments.isEmpty()) {
            root = new ProjectNode(context.getIdAllocator().getNextId(), root, Assignments.builder().putIdentities(root.getOutputSymbols()).putAll(maskAssignments).build());
        }
        globalAggregation = new AggregationNode(globalAggregation.getId(), root, AggregationDecorrelation.rewriteWithMasks(globalAggregation.getAggregations(), (Map<Symbol, Symbol>)masks.build()), AggregationNode.singleGroupingSet((List<Symbol>)ImmutableList.builder().addAll(join.getLeftOutputSymbols()).addAll(globalAggregation.getGroupingKeys()).build()), (List<Symbol>)ImmutableList.of(), globalAggregation.getStep(), Optional.empty(), Optional.empty());
        Optional<PlanNode> project = Util.restrictOutputs(context.getIdAllocator(), globalAggregation, (Set<Symbol>)ImmutableSet.copyOf(correlatedJoinNode.getOutputSymbols()));
        return Rule.Result.ofPlanNode(project.orElse(globalAggregation));
    }
}

