/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.execution.StateMachine;
import io.trino.execution.buffer.BufferInfo;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PagesSerde;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.spi.exchange.ExchangeSink;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class SpoolingExchangeOutputBuffer
implements OutputBuffer {
    private final StateMachine<BufferState> state;
    private final OutputBuffers outputBuffers;
    private final ExchangeSink exchangeSink;
    private final Supplier<LocalMemoryContext> memoryContextSupplier;
    private final AtomicLong peakMemoryUsage = new AtomicLong();
    private final AtomicLong totalPagesAdded = new AtomicLong();
    private final AtomicLong totalRowsAdded = new AtomicLong();

    public SpoolingExchangeOutputBuffer(StateMachine<BufferState> state, OutputBuffers outputBuffers, ExchangeSink exchangeSink, Supplier<LocalMemoryContext> memoryContextSupplier) {
        this.state = Objects.requireNonNull(state, "state is null");
        this.outputBuffers = Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        Preconditions.checkArgument((outputBuffers.getType() == OutputBuffers.BufferType.SPOOL ? 1 : 0) != 0, (Object)"Expected a SPOOL output buffer");
        this.exchangeSink = Objects.requireNonNull(exchangeSink, "exchangeSink is null");
        this.memoryContextSupplier = Objects.requireNonNull(memoryContextSupplier, "memoryContextSupplier is null");
        state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_BUFFERS);
    }

    @Override
    public OutputBufferInfo getInfo() {
        BufferState state = this.state.get();
        return new OutputBufferInfo("EXTERNAL", state, false, state.canAddPages(), this.exchangeSink.getMemoryUsage(), this.totalPagesAdded.get(), this.totalRowsAdded.get(), this.totalPagesAdded.get(), (List<BufferInfo>)ImmutableList.of());
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == BufferState.FINISHED;
    }

    @Override
    public double getUtilization() {
        return 0.0;
    }

    @Override
    public boolean isOverutilized() {
        return false;
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        if (this.state.get().isTerminal() || this.outputBuffers.getVersion() >= newOutputBuffers.getVersion()) {
            return;
        }
        this.outputBuffers.checkValidTransition(newOutputBuffers);
    }

    @Override
    public ListenableFuture<BufferResult> get(OutputBuffers.OutputBufferId bufferId, long token, DataSize maxSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acknowledge(OutputBuffers.OutputBufferId bufferId, long token) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void abort(OutputBuffers.OutputBufferId bufferId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Void> isFull() {
        return MoreFutures.asVoid((ListenableFuture)MoreFutures.toListenableFuture((CompletableFuture)this.exchangeSink.isBlocked()));
    }

    @Override
    public void enqueue(List<Slice> pages) {
        this.enqueue(0, pages);
    }

    @Override
    public void enqueue(int partition, List<Slice> pages) {
        Objects.requireNonNull(pages, "pages is null");
        if (!this.state.get().canAddPages()) {
            return;
        }
        for (Slice page : pages) {
            this.exchangeSink.add(partition, page);
            this.totalRowsAdded.addAndGet(PagesSerde.getSerializedPagePositionCount(page));
        }
        this.updateMemoryUsage(this.exchangeSink.getMemoryUsage());
        this.totalPagesAdded.addAndGet(pages.size());
    }

    @Override
    public void setNoMorePages() {
        if (this.state.compareAndSet(BufferState.NO_MORE_BUFFERS, BufferState.FLUSHING)) {
            this.destroy();
        }
    }

    @Override
    public void destroy() {
        if (this.state.setIf(BufferState.FINISHED, oldState -> !oldState.isTerminal())) {
            try {
                this.exchangeSink.finish();
            }
            finally {
                this.updateMemoryUsage(this.exchangeSink.getMemoryUsage());
            }
        }
    }

    @Override
    public void fail() {
        if (this.state.setIf(BufferState.FAILED, oldState -> !oldState.isTerminal())) {
            try {
                this.exchangeSink.abort();
            }
            finally {
                this.updateMemoryUsage(0L);
            }
        }
    }

    @Override
    public long getPeakMemoryUsage() {
        return this.peakMemoryUsage.get();
    }

    private void updateMemoryUsage(long bytes) {
        LocalMemoryContext context = this.getSystemMemoryContextOrNull();
        if (context != null) {
            context.setBytes(bytes);
        }
        this.updatePeakMemoryUsage(bytes);
    }

    private void updatePeakMemoryUsage(long bytes) {
        long currentValue;
        do {
            if ((currentValue = this.peakMemoryUsage.get()) < bytes) continue;
            return;
        } while (!this.peakMemoryUsage.compareAndSet(currentValue, bytes));
    }

    private LocalMemoryContext getSystemMemoryContextOrNull() {
        try {
            return this.memoryContextSupplier.get();
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }
}

