/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.trino.connector.CatalogName;
import io.trino.spi.HostAddress;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class NodeRequirements {
    private final Optional<CatalogName> catalogName;
    private final Set<HostAddress> addresses;

    public NodeRequirements(Optional<CatalogName> catalogName, Set<HostAddress> addresses) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.addresses = ImmutableSet.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
    }

    public Optional<CatalogName> getCatalogName() {
        return this.catalogName;
    }

    public Set<HostAddress> getAddresses() {
        return this.addresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeRequirements that = (NodeRequirements)o;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.addresses, that.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.addresses);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", this.catalogName).add("addresses", this.addresses).toString();
    }
}

