/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.Lifespan;
import io.trino.execution.RemoteTask;
import io.trino.execution.TableExecuteContext;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.scheduler.FixedSourcePartitionedScheduler;
import io.trino.execution.scheduler.PartitionIdAllocator;
import io.trino.execution.scheduler.ScheduleResult;
import io.trino.execution.scheduler.SourceScheduler;
import io.trino.execution.scheduler.SplitPlacementPolicy;
import io.trino.execution.scheduler.SplitPlacementResult;
import io.trino.execution.scheduler.StageExecution;
import io.trino.execution.scheduler.StageScheduler;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.server.DynamicFilterService;
import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.spi.connector.NotPartitionedPartitionHandle;
import io.trino.split.EmptySplit;
import io.trino.split.SplitSource;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BooleanSupplier;

public class SourcePartitionedScheduler
implements SourceScheduler {
    private final StageExecution stageExecution;
    private final SplitSource splitSource;
    private final SplitPlacementPolicy splitPlacementPolicy;
    private final int splitBatchSize;
    private final PlanNodeId partitionedNode;
    private final boolean groupedExecution;
    private final DynamicFilterService dynamicFilterService;
    private final TableExecuteContextManager tableExecuteContextManager;
    private final BooleanSupplier anySourceTaskBlocked;
    private final PartitionIdAllocator partitionIdAllocator;
    private final Map<InternalNode, RemoteTask> scheduledTasks;
    private final Map<Lifespan, ScheduleGroup> scheduleGroups = new HashMap<Lifespan, ScheduleGroup>();
    private boolean noMoreScheduleGroups;
    private State state = State.INITIALIZED;
    private SettableFuture<Void> whenFinishedOrNewLifespanAdded = SettableFuture.create();

    private SourcePartitionedScheduler(StageExecution stageExecution, PlanNodeId partitionedNode, SplitSource splitSource, SplitPlacementPolicy splitPlacementPolicy, int splitBatchSize, boolean groupedExecution, DynamicFilterService dynamicFilterService, TableExecuteContextManager tableExecuteContextManager, BooleanSupplier anySourceTaskBlocked, PartitionIdAllocator partitionIdAllocator, Map<InternalNode, RemoteTask> scheduledTasks) {
        this.stageExecution = Objects.requireNonNull(stageExecution, "stageExecution is null");
        this.splitSource = Objects.requireNonNull(splitSource, "splitSource is null");
        this.splitPlacementPolicy = Objects.requireNonNull(splitPlacementPolicy, "splitPlacementPolicy is null");
        Preconditions.checkArgument((splitBatchSize > 0 ? 1 : 0) != 0, (Object)"splitBatchSize must be at least one");
        this.splitBatchSize = splitBatchSize;
        this.partitionedNode = Objects.requireNonNull(partitionedNode, "partitionedNode is null");
        this.groupedExecution = groupedExecution;
        this.dynamicFilterService = Objects.requireNonNull(dynamicFilterService, "dynamicFilterService is null");
        this.tableExecuteContextManager = Objects.requireNonNull(tableExecuteContextManager, "tableExecuteContextManager is null");
        this.anySourceTaskBlocked = Objects.requireNonNull(anySourceTaskBlocked, "anySourceTaskBlocked is null");
        this.partitionIdAllocator = Objects.requireNonNull(partitionIdAllocator, "partitionIdAllocator is null");
        this.scheduledTasks = Objects.requireNonNull(scheduledTasks, "scheduledTasks is null");
    }

    @Override
    public PlanNodeId getPlanNodeId() {
        return this.partitionedNode;
    }

    public static StageScheduler newSourcePartitionedSchedulerAsStageScheduler(StageExecution stageExecution, PlanNodeId partitionedNode, SplitSource splitSource, SplitPlacementPolicy splitPlacementPolicy, int splitBatchSize, DynamicFilterService dynamicFilterService, TableExecuteContextManager tableExecuteContextManager, BooleanSupplier anySourceTaskBlocked) {
        final SourcePartitionedScheduler sourcePartitionedScheduler = new SourcePartitionedScheduler(stageExecution, partitionedNode, splitSource, splitPlacementPolicy, splitBatchSize, false, dynamicFilterService, tableExecuteContextManager, anySourceTaskBlocked, new PartitionIdAllocator(), new HashMap<InternalNode, RemoteTask>());
        sourcePartitionedScheduler.startLifespan(Lifespan.taskWide(), NotPartitionedPartitionHandle.NOT_PARTITIONED);
        sourcePartitionedScheduler.noMoreLifespans();
        return new StageScheduler(){

            @Override
            public ScheduleResult schedule() {
                ScheduleResult scheduleResult = sourcePartitionedScheduler.schedule();
                sourcePartitionedScheduler.drainCompletedLifespans();
                return scheduleResult;
            }

            @Override
            public void close() {
                sourcePartitionedScheduler.close();
            }
        };
    }

    public static SourceScheduler newSourcePartitionedSchedulerAsSourceScheduler(StageExecution stageExecution, PlanNodeId partitionedNode, SplitSource splitSource, SplitPlacementPolicy splitPlacementPolicy, int splitBatchSize, boolean groupedExecution, DynamicFilterService dynamicFilterService, TableExecuteContextManager tableExecuteContextManager, BooleanSupplier anySourceTaskBlocked, PartitionIdAllocator partitionIdAllocator, Map<InternalNode, RemoteTask> scheduledTasks) {
        return new SourcePartitionedScheduler(stageExecution, partitionedNode, splitSource, splitPlacementPolicy, splitBatchSize, groupedExecution, dynamicFilterService, tableExecuteContextManager, anySourceTaskBlocked, partitionIdAllocator, scheduledTasks);
    }

    @Override
    public synchronized void startLifespan(Lifespan lifespan, ConnectorPartitionHandle partitionHandle) {
        Preconditions.checkState((this.state == State.INITIALIZED || this.state == State.SPLITS_ADDED ? 1 : 0) != 0);
        this.scheduleGroups.put(lifespan, new ScheduleGroup(partitionHandle));
        this.whenFinishedOrNewLifespanAdded.set(null);
        this.whenFinishedOrNewLifespanAdded = SettableFuture.create();
    }

    @Override
    public synchronized void noMoreLifespans() {
        Preconditions.checkState((this.state == State.INITIALIZED || this.state == State.SPLITS_ADDED ? 1 : 0) != 0);
        this.noMoreScheduleGroups = true;
        this.whenFinishedOrNewLifespanAdded.set(null);
        this.whenFinishedOrNewLifespanAdded = SettableFuture.create();
    }

    @Override
    public synchronized ScheduleResult schedule() {
        boolean anySourceTaskBlocked;
        this.dropListenersFromWhenFinishedOrNewLifespansAdded();
        int overallSplitAssignmentCount = 0;
        ImmutableSet.Builder overallNewTasks = ImmutableSet.builder();
        ArrayList<Object> overallBlockedFutures = new ArrayList<Object>();
        boolean anyBlockedOnPlacements = false;
        boolean anyBlockedOnNextSplitBatch = false;
        boolean anyNotBlocked = false;
        for (Map.Entry<Lifespan, ScheduleGroup> entry : this.scheduleGroups.entrySet()) {
            Lifespan lifespan = entry.getKey();
            ScheduleGroup scheduleGroup = entry.getValue();
            Set<Split> pendingSplits = scheduleGroup.pendingSplits;
            if (scheduleGroup.state == ScheduleGroupState.NO_MORE_SPLITS || scheduleGroup.state == ScheduleGroupState.DONE) {
                Verify.verify((scheduleGroup.nextSplitBatchFuture == null ? 1 : 0) != 0);
            } else if (pendingSplits.isEmpty()) {
                if (scheduleGroup.nextSplitBatchFuture == null) {
                    scheduleGroup.nextSplitBatchFuture = this.splitSource.getNextBatch(scheduleGroup.partitionHandle, lifespan, this.splitBatchSize - pendingSplits.size());
                    long start = System.nanoTime();
                    MoreFutures.addSuccessCallback(scheduleGroup.nextSplitBatchFuture, () -> this.stageExecution.recordGetSplitTime(start));
                }
                if (scheduleGroup.nextSplitBatchFuture.isDone()) {
                    SplitSource.SplitBatch nextSplits = (SplitSource.SplitBatch)MoreFutures.getFutureValue(scheduleGroup.nextSplitBatchFuture);
                    scheduleGroup.nextSplitBatchFuture = null;
                    pendingSplits.addAll(nextSplits.getSplits());
                    if (nextSplits.isLastBatch()) {
                        if (scheduleGroup.state == ScheduleGroupState.INITIALIZED && pendingSplits.isEmpty()) {
                            pendingSplits.add(new Split(this.splitSource.getCatalogName(), new EmptySplit(this.splitSource.getCatalogName()), lifespan));
                        }
                        scheduleGroup.state = ScheduleGroupState.NO_MORE_SPLITS;
                    }
                } else {
                    overallBlockedFutures.add(scheduleGroup.nextSplitBatchFuture);
                    anyBlockedOnNextSplitBatch = true;
                    continue;
                }
            }
            Multimap<InternalNode, Split> splitAssignment = ImmutableMultimap.of();
            if (!pendingSplits.isEmpty()) {
                if (!scheduleGroup.placementFuture.isDone()) {
                    anyBlockedOnPlacements = true;
                    continue;
                }
                if (scheduleGroup.state == ScheduleGroupState.INITIALIZED) {
                    scheduleGroup.state = ScheduleGroupState.SPLITS_ADDED;
                }
                if (this.state == State.INITIALIZED) {
                    this.state = State.SPLITS_ADDED;
                }
                SplitPlacementResult splitPlacementResult = this.splitPlacementPolicy.computeAssignments(pendingSplits);
                splitAssignment = splitPlacementResult.getAssignments();
                splitAssignment.values().forEach(pendingSplits::remove);
                overallSplitAssignmentCount += splitAssignment.size();
                if (!pendingSplits.isEmpty()) {
                    scheduleGroup.placementFuture = splitPlacementResult.getBlocked();
                    overallBlockedFutures.add(scheduleGroup.placementFuture);
                    anyBlockedOnPlacements = true;
                }
            }
            ImmutableMultimap noMoreSplitsNotification = ImmutableMultimap.of();
            if (pendingSplits.isEmpty() && scheduleGroup.state == ScheduleGroupState.NO_MORE_SPLITS) {
                scheduleGroup.state = ScheduleGroupState.DONE;
                if (!lifespan.isTaskWide()) {
                    InternalNode node = ((FixedSourcePartitionedScheduler.BucketedSplitPlacementPolicy)this.splitPlacementPolicy).getNodeForBucket(lifespan.getId());
                    noMoreSplitsNotification = ImmutableMultimap.of((Object)node, (Object)lifespan);
                }
            }
            overallNewTasks.addAll(this.assignSplits(splitAssignment, (Multimap<InternalNode, Lifespan>)noMoreSplitsNotification));
            if (scheduleGroup.nextSplitBatchFuture != null || !scheduleGroup.pendingSplits.isEmpty() || scheduleGroup.state == ScheduleGroupState.DONE) continue;
            anyNotBlocked = true;
        }
        if (this.state == State.NO_MORE_SPLITS || this.state == State.FINISHED || this.noMoreScheduleGroups && this.scheduleGroups.isEmpty() && this.splitSource.isFinished()) {
            switch (this.state) {
                case INITIALIZED: {
                    throw new IllegalStateException("At least 1 split should have been scheduled for this plan node");
                }
                case SPLITS_ADDED: {
                    this.state = State.NO_MORE_SPLITS;
                    Optional<List<Object>> tableExecuteSplitsInfo = this.splitSource.getTableExecuteSplitsInfo();
                    tableExecuteSplitsInfo.ifPresent(info -> {
                        TableExecuteContext tableExecuteContext = this.tableExecuteContextManager.getTableExecuteContextForQuery(this.stageExecution.getStageId().getQueryId());
                        tableExecuteContext.setSplitsInfo((List<Object>)info);
                    });
                    this.splitSource.close();
                }
                case NO_MORE_SPLITS: {
                    this.state = State.FINISHED;
                    this.whenFinishedOrNewLifespanAdded.set(null);
                }
                case FINISHED: {
                    return new ScheduleResult(true, (Iterable<? extends RemoteTask>)overallNewTasks.build(), overallSplitAssignmentCount);
                }
            }
            throw new IllegalStateException("Unknown state");
        }
        if (anyNotBlocked) {
            return new ScheduleResult(false, (Iterable<? extends RemoteTask>)overallNewTasks.build(), overallSplitAssignmentCount);
        }
        if (anyBlockedOnNextSplitBatch && this.scheduledTasks.isEmpty() && this.dynamicFilterService.isCollectingTaskNeeded(this.stageExecution.getStageId().getQueryId(), this.stageExecution.getFragment())) {
            this.createTaskOnRandomNode().ifPresent(arg_0 -> ((ImmutableSet.Builder)overallNewTasks).add(arg_0));
        }
        if (anySourceTaskBlocked = this.anySourceTaskBlocked.getAsBoolean()) {
            this.dynamicFilterService.unblockStageDynamicFilters(this.stageExecution.getStageId().getQueryId(), this.stageExecution.getAttemptId(), this.stageExecution.getFragment());
        }
        if (this.groupedExecution) {
            overallNewTasks.addAll(this.finalizeTaskCreationIfNecessary());
        } else if (anyBlockedOnPlacements && anySourceTaskBlocked) {
            overallNewTasks.addAll(this.finalizeTaskCreationIfNecessary());
        }
        ScheduleResult.BlockedReason blockedReason = anyBlockedOnNextSplitBatch ? (anyBlockedOnPlacements ? ScheduleResult.BlockedReason.MIXED_SPLIT_QUEUES_FULL_AND_WAITING_FOR_SOURCE : ScheduleResult.BlockedReason.WAITING_FOR_SOURCE) : (anyBlockedOnPlacements ? ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL : ScheduleResult.BlockedReason.NO_ACTIVE_DRIVER_GROUP);
        overallBlockedFutures.add(this.whenFinishedOrNewLifespanAdded);
        return new ScheduleResult(false, (Iterable<? extends RemoteTask>)overallNewTasks.build(), (ListenableFuture<Void>)Futures.nonCancellationPropagating(SourcePartitionedScheduler.asVoid(MoreFutures.whenAnyComplete(overallBlockedFutures))), blockedReason, overallSplitAssignmentCount);
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    private synchronized void dropListenersFromWhenFinishedOrNewLifespansAdded() {
        if (this.whenFinishedOrNewLifespanAdded.isDone()) {
            return;
        }
        this.whenFinishedOrNewLifespanAdded.cancel(true);
        this.whenFinishedOrNewLifespanAdded = SettableFuture.create();
    }

    @Override
    public void close() {
        this.splitSource.close();
    }

    @Override
    public synchronized List<Lifespan> drainCompletedLifespans() {
        if (this.scheduleGroups.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        Iterator<Map.Entry<Lifespan, ScheduleGroup>> entryIterator = this.scheduleGroups.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<Lifespan, ScheduleGroup> entry = entryIterator.next();
            if (entry.getValue().state != ScheduleGroupState.DONE) continue;
            result.add((Object)entry.getKey());
            entryIterator.remove();
        }
        if (this.scheduleGroups.isEmpty() && this.splitSource.isFinished()) {
            this.whenFinishedOrNewLifespanAdded.set(null);
            this.whenFinishedOrNewLifespanAdded = SettableFuture.create();
        }
        return result.build();
    }

    private Set<RemoteTask> assignSplits(Multimap<InternalNode, Split> splitAssignment, Multimap<InternalNode, Lifespan> noMoreSplitsNotification) {
        ImmutableSet.Builder newTasks = ImmutableSet.builder();
        ImmutableSet nodes = ImmutableSet.builder().addAll((Iterable)splitAssignment.keySet()).addAll((Iterable)noMoreSplitsNotification.keySet()).build();
        for (InternalNode node : nodes) {
            RemoteTask task;
            ImmutableMultimap splits = ImmutableMultimap.builder().putAll((Object)this.partitionedNode, (Iterable)splitAssignment.get((Object)node)).build();
            ImmutableMultimap.Builder noMoreSplits = ImmutableMultimap.builder();
            if (noMoreSplitsNotification.containsKey((Object)node)) {
                noMoreSplits.putAll((Object)this.partitionedNode, (Iterable)noMoreSplitsNotification.get((Object)node));
            }
            if ((task = this.scheduledTasks.get(node)) != null) {
                task.addSplits((Multimap<PlanNodeId, Split>)splits);
                noMoreSplits.build().forEach(task::noMoreSplits);
                continue;
            }
            this.scheduleTask(node, (Multimap<PlanNodeId, Split>)splits, (Multimap<PlanNodeId, Lifespan>)noMoreSplits.build()).ifPresent(arg_0 -> ((ImmutableSet.Builder)newTasks).add(arg_0));
        }
        return newTasks.build();
    }

    private Optional<RemoteTask> createTaskOnRandomNode() {
        Preconditions.checkState((boolean)this.scheduledTasks.isEmpty(), (Object)"Stage task is already scheduled on node");
        List<InternalNode> allNodes = this.splitPlacementPolicy.allNodes();
        Preconditions.checkState((allNodes.size() > 0 ? 1 : 0) != 0, (Object)"No nodes available");
        InternalNode node = allNodes.get(ThreadLocalRandom.current().nextInt(0, allNodes.size()));
        return this.scheduleTask(node, (Multimap<PlanNodeId, Split>)ImmutableMultimap.of(), (Multimap<PlanNodeId, Lifespan>)ImmutableMultimap.of());
    }

    private Set<RemoteTask> finalizeTaskCreationIfNecessary() {
        if (this.stageExecution.getFragment().isLeaf()) {
            return ImmutableSet.of();
        }
        this.splitPlacementPolicy.lockDownNodes();
        Set newTasks = (Set)this.splitPlacementPolicy.allNodes().stream().filter(node -> !this.scheduledTasks.containsKey(node)).map(node -> this.scheduleTask((InternalNode)node, (Multimap<PlanNodeId, Split>)ImmutableMultimap.of(), (Multimap<PlanNodeId, Lifespan>)ImmutableMultimap.of())).filter(Optional::isPresent).map(Optional::get).collect(ImmutableSet.toImmutableSet());
        this.stageExecution.transitionToSchedulingSplits();
        return newTasks;
    }

    private Optional<RemoteTask> scheduleTask(InternalNode node, Multimap<PlanNodeId, Split> initialSplits, Multimap<PlanNodeId, Lifespan> noMoreSplitsForLifespan) {
        Optional<RemoteTask> remoteTask = this.stageExecution.scheduleTask(node, this.partitionIdAllocator.getNextId(), initialSplits, noMoreSplitsForLifespan);
        remoteTask.ifPresent(task -> this.scheduledTasks.put(node, (RemoteTask)task));
        return remoteTask;
    }

    private static enum ScheduleGroupState {
        INITIALIZED,
        SPLITS_ADDED,
        NO_MORE_SPLITS,
        DONE;

    }

    private static class ScheduleGroup {
        public final ConnectorPartitionHandle partitionHandle;
        public ListenableFuture<SplitSource.SplitBatch> nextSplitBatchFuture;
        public ListenableFuture<Void> placementFuture = Futures.immediateVoidFuture();
        public final Set<Split> pendingSplits = new HashSet<Split>();
        public ScheduleGroupState state = ScheduleGroupState.INITIALIZED;

        public ScheduleGroup(ConnectorPartitionHandle partitionHandle) {
            this.partitionHandle = Objects.requireNonNull(partitionHandle, "partitionHandle is null");
        }
    }

    private static enum State {
        INITIALIZED,
        SPLITS_ADDED,
        NO_MORE_SPLITS,
        FINISHED;

    }
}

