/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.memory.MemoryInfo;
import io.trino.memory.MemoryPool;
import io.trino.memory.NodeMemoryConfig;
import io.trino.spi.memory.MemoryPoolId;
import io.trino.spi.memory.MemoryPoolInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public final class LocalMemoryManager {
    public static final MemoryPoolId GENERAL_POOL = new MemoryPoolId("general");
    public static final MemoryPoolId RESERVED_POOL = new MemoryPoolId("reserved");
    private static final OperatingSystemMXBean OPERATING_SYSTEM_MX_BEAN = ManagementFactory.getOperatingSystemMXBean();
    private DataSize maxMemory;
    private Map<MemoryPoolId, MemoryPool> pools;

    @Inject
    public LocalMemoryManager(NodeMemoryConfig config) {
        this(config, Runtime.getRuntime().maxMemory());
    }

    @VisibleForTesting
    LocalMemoryManager(NodeMemoryConfig config, long availableMemory) {
        Objects.requireNonNull(config, "config is null");
        this.configureMemoryPools(config, availableMemory);
    }

    private void configureMemoryPools(NodeMemoryConfig config, long availableMemory) {
        this.validateHeapHeadroom(config, availableMemory);
        this.maxMemory = DataSize.ofBytes((long)(availableMemory - config.getHeapHeadroom().toBytes()));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        long generalPoolSize = this.maxMemory.toBytes();
        if (!config.isReservedPoolDisabled()) {
            builder.put((Object)RESERVED_POOL, (Object)new MemoryPool(RESERVED_POOL, config.getMaxQueryMemoryPerNode()));
            generalPoolSize -= config.getMaxQueryMemoryPerNode().toBytes();
        }
        Verify.verify((generalPoolSize > 0L ? 1 : 0) != 0, (String)"general memory pool size is 0", (Object[])new Object[0]);
        builder.put((Object)GENERAL_POOL, (Object)new MemoryPool(GENERAL_POOL, DataSize.ofBytes((long)generalPoolSize)));
        this.pools = builder.buildOrThrow();
    }

    private void validateHeapHeadroom(NodeMemoryConfig config, long availableMemory) {
        long maxQueryTotalMemoryPerNode = config.getMaxQueryMemoryPerNode().toBytes();
        long heapHeadroom = config.getHeapHeadroom().toBytes();
        if (heapHeadroom < 0L || heapHeadroom + maxQueryTotalMemoryPerNode > availableMemory) {
            throw new IllegalArgumentException(String.format("Invalid memory configuration. The sum of max query memory per node (%s) and heap headroom (%s) cannot be larger than the available heap memory (%s)", maxQueryTotalMemoryPerNode, heapHeadroom, availableMemory));
        }
    }

    public MemoryInfo getInfo() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<MemoryPoolId, MemoryPool> entry : this.pools.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getInfo());
        }
        return new MemoryInfo(OPERATING_SYSTEM_MX_BEAN.getAvailableProcessors(), this.maxMemory, (Map<MemoryPoolId, MemoryPoolInfo>)builder.buildOrThrow());
    }

    public List<MemoryPool> getPools() {
        return ImmutableList.copyOf(this.pools.values());
    }

    public MemoryPool getGeneralPool() {
        return this.pools.get(GENERAL_POOL);
    }

    public Optional<MemoryPool> getReservedPool() {
        return Optional.ofNullable(this.pools.get(RESERVED_POOL));
    }
}

