/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.AbstractPropertyManager;
import io.trino.metadata.Properties;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.PlannerContext;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Property;
import java.util.List;
import java.util.Map;

abstract class AbstractCatalogPropertyManager
extends AbstractPropertyManager<CatalogName> {
    protected AbstractCatalogPropertyManager(String propertyType, ErrorCodeSupplier propertyError) {
        super(propertyType, propertyError);
    }

    public void addProperties(CatalogName catalogName, List<PropertyMetadata<?>> properties) {
        this.doAddProperties(catalogName, properties);
    }

    public void removeProperties(CatalogName catalogName) {
        this.doRemoveProperties(catalogName);
    }

    public Map<String, Object> getProperties(CatalogName catalog, String catalogNameForDiagnostics, Iterable<Property> properties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        return this.doGetProperties(catalog, catalogNameForDiagnostics, properties, session, plannerContext, accessControl, parameters);
    }

    public Properties getOnlySpecifiedProperties(CatalogName catalog, String catalogNameForDiagnostics, Iterable<Property> properties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        return this.doGetOnlySpecifiedProperties(catalog, catalogNameForDiagnostics, properties, session, plannerContext, accessControl, parameters);
    }

    public Map<CatalogName, Map<String, PropertyMetadata<?>>> getAllProperties() {
        return this.doGetAllProperties();
    }

    @Override
    protected String formatPropertiesKeyForMessage(String catalogName, CatalogName ignored) {
        return "Catalog '" + catalogName + "'";
    }
}

