/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.metadata.Properties;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.ParameterRewriter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Property;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class AbstractPropertyManager<K> {
    protected final ConcurrentMap<K, Map<String, PropertyMetadata<?>>> connectorProperties = new ConcurrentHashMap();
    private final String propertyType;
    private final ErrorCodeSupplier propertyError;

    protected AbstractPropertyManager(String propertyType, ErrorCodeSupplier propertyError) {
        Objects.requireNonNull(propertyType, "propertyType is null");
        this.propertyType = propertyType;
        this.propertyError = Objects.requireNonNull(propertyError, "propertyError is null");
    }

    protected final void doAddProperties(K propertiesKey, List<PropertyMetadata<?>> properties) {
        Objects.requireNonNull(propertiesKey, "propertiesKey is null");
        Objects.requireNonNull(properties, "properties is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(properties, PropertyMetadata::getName);
        Preconditions.checkState((this.connectorProperties.putIfAbsent(propertiesKey, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"Properties for key %s are already registered", propertiesKey);
    }

    protected final void doRemoveProperties(K propertiesKey) {
        this.connectorProperties.remove(propertiesKey);
    }

    protected final Properties doGetOnlySpecifiedProperties(K propertiesKey, String catalogNameForDiagnostics, Iterable<Property> properties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        Map<String, PropertyMetadata<?>> supportedPropertiesMetadata = this.getSupportedPropertiesMetadata(propertiesKey, catalogNameForDiagnostics);
        SeparatedProperties separatedProperties = this.separateProperties(propertiesKey, catalogNameForDiagnostics, properties);
        ImmutableMap.Builder<String, Object> nonNullPropertiesBuilder = this.evaluateSqlProperties(propertiesKey, supportedPropertiesMetadata, catalogNameForDiagnostics, separatedProperties.nonDefaultProperties, session, plannerContext, accessControl, parameters);
        ImmutableSet.Builder nullPropertyNamesBuilder = ImmutableSet.builder();
        for (String name : separatedProperties.defaultPropertyNames) {
            PropertyMetadata<?> propertyMetadata = supportedPropertiesMetadata.get(name);
            if (propertyMetadata == null) {
                throw new TrinoException(this.propertyError, String.format("%s does not support %s property '%s'", this.formatPropertiesKeyForMessage(catalogNameForDiagnostics, propertiesKey), this.propertyType, name));
            }
            Object value = propertyMetadata.getDefaultValue();
            if (value != null) {
                nonNullPropertiesBuilder.put((Object)name, value);
                continue;
            }
            nullPropertyNamesBuilder.add((Object)name);
        }
        return new Properties((Map<String, Object>)nonNullPropertiesBuilder.build(), (Set<String>)nullPropertyNamesBuilder.build());
    }

    protected final Map<String, Object> doGetProperties(K propertiesKey, String catalogNameForDiagnostics, Iterable<Property> properties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        Map<String, PropertyMetadata<?>> supportedPropertiesMetadata = this.getSupportedPropertiesMetadata(propertiesKey, catalogNameForDiagnostics);
        SeparatedProperties separatedProperties = this.separateProperties(propertiesKey, catalogNameForDiagnostics, properties);
        for (String name : separatedProperties.defaultPropertyNames) {
            if (supportedPropertiesMetadata.containsKey(name)) continue;
            throw new TrinoException(this.propertyError, String.format("%s does not support %s property '%s'", this.formatPropertiesKeyForMessage(catalogNameForDiagnostics, propertiesKey), this.propertyType, name));
        }
        return this.doGetProperties(propertiesKey, catalogNameForDiagnostics, separatedProperties.nonDefaultProperties, session, plannerContext, accessControl, parameters);
    }

    protected final Map<String, Object> doGetProperties(K propertiesKey, String catalogNameForDiagnostics, Map<String, Expression> sqlProperties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        Map<String, PropertyMetadata<?>> supportedPropertiesMetadata = this.getSupportedPropertiesMetadata(propertiesKey, catalogNameForDiagnostics);
        ImmutableMap.Builder<String, Object> propertiesBuilder = this.evaluateSqlProperties(propertiesKey, supportedPropertiesMetadata, catalogNameForDiagnostics, sqlProperties, session, plannerContext, accessControl, parameters);
        ImmutableMap specifiedProperties = propertiesBuilder.build();
        for (PropertyMetadata<?> propertyMetadata : supportedPropertiesMetadata.values()) {
            Object value;
            if (specifiedProperties.containsKey(propertyMetadata.getName()) || (value = propertyMetadata.getDefaultValue()) == null) continue;
            propertiesBuilder.put((Object)propertyMetadata.getName(), value);
        }
        return propertiesBuilder.build();
    }

    protected final Map<K, Map<String, PropertyMetadata<?>>> doGetAllProperties() {
        return ImmutableMap.copyOf(this.connectorProperties);
    }

    private SeparatedProperties separateProperties(K propertiesKey, String catalogNameForDiagnostics, Iterable<Property> properties) {
        HashMap<String, Expression> nonDefaultProperties = new HashMap<String, Expression>();
        HashSet<String> defaultPropertyNames = new HashSet<String>();
        for (Property property : properties) {
            String name = property.getName().getValue().toLowerCase(Locale.ENGLISH);
            if (nonDefaultProperties.containsKey(name) || defaultPropertyNames.contains(name)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DUPLICATE_PROPERTY, String.format("%s %s property '%s' is specified more than once", this.formatPropertiesKeyForMessage(catalogNameForDiagnostics, propertiesKey), this.propertyType, name));
            }
            if (!property.isSetToDefault()) {
                nonDefaultProperties.put(name, property.getNonDefaultValue());
                continue;
            }
            defaultPropertyNames.add(name);
        }
        return new SeparatedProperties(nonDefaultProperties, defaultPropertyNames);
    }

    private Map<String, PropertyMetadata<?>> getSupportedPropertiesMetadata(K propertiesKey, String catalogNameForDiagnostics) {
        Map supportedPropertiesMetadata = (Map)this.connectorProperties.get(propertiesKey);
        if (supportedPropertiesMetadata == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, this.formatPropertiesKeyForMessage(catalogNameForDiagnostics, propertiesKey) + " not found");
        }
        return supportedPropertiesMetadata;
    }

    private ImmutableMap.Builder<String, Object> evaluateSqlProperties(K propertiesKey, Map<String, PropertyMetadata<?>> supportedPropertiesMetadata, String catalogNameForDiagnostics, Map<String, Expression> sqlProperties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Expression> sqlProperty : sqlProperties.entrySet()) {
            Object value;
            Object sqlObjectValue;
            String propertyName = sqlProperty.getKey().toLowerCase(Locale.ENGLISH);
            PropertyMetadata<?> propertyMetadata = supportedPropertiesMetadata.get(propertyName);
            if (propertyMetadata == null) {
                throw new TrinoException(this.propertyError, String.format("%s does not support %s property '%s'", this.formatPropertiesKeyForMessage(catalogNameForDiagnostics, propertiesKey), this.propertyType, propertyName));
            }
            try {
                sqlObjectValue = this.evaluatePropertyValue(sqlProperty.getValue(), propertyMetadata.getSqlType(), session, plannerContext, accessControl, parameters);
            }
            catch (TrinoException e) {
                throw new TrinoException(this.propertyError, String.format("Invalid value for %s property '%s': Cannot convert [%s] to %s", this.propertyType, propertyMetadata.getName(), sqlProperty.getValue(), propertyMetadata.getSqlType()), (Throwable)e);
            }
            try {
                value = propertyMetadata.decode(sqlObjectValue);
            }
            catch (Exception e) {
                throw new TrinoException(this.propertyError, String.format("Unable to set %s property '%s' to [%s]: %s", this.propertyType, propertyMetadata.getName(), sqlProperty.getValue(), e.getMessage()), (Throwable)e);
            }
            propertiesBuilder.put((Object)propertyMetadata.getName(), value);
        }
        return propertiesBuilder;
    }

    private Object evaluatePropertyValue(Expression expression, Type expectedType, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameters), (Expression)expression);
        Object value = ExpressionInterpreter.evaluateConstantExpression(rewritten, expectedType, plannerContext, session, accessControl, parameters);
        BlockBuilder blockBuilder = expectedType.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)expectedType, (BlockBuilder)blockBuilder, (Object)value);
        Object objectValue = expectedType.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
        if (objectValue == null) {
            throw new TrinoException(this.propertyError, String.format("Invalid null value for %s property", this.propertyType));
        }
        return objectValue;
    }

    protected abstract String formatPropertiesKeyForMessage(String var1, K var2);

    private static class SeparatedProperties {
        final Map<String, Expression> nonDefaultProperties;
        final Set<String> defaultPropertyNames;

        SeparatedProperties(Map<String, Expression> nonDefaultProperties, Set<String> defaultPropertyNames) {
            this.nonDefaultProperties = ImmutableMap.copyOf(Objects.requireNonNull(nonDefaultProperties, "nonDefaultProperties is null"));
            this.defaultPropertyNames = ImmutableSet.copyOf((Collection)Objects.requireNonNull(defaultPropertyNames, "defaultPropertyNames is null"));
        }
    }
}

