/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import io.trino.plugin.base.cache.NonEvictableCache;
import io.trino.plugin.base.cache.SafeCaches;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public abstract class AbstractTypedJacksonModule<T>
extends SimpleModule {
    private static final String TYPE_PROPERTY = "@type";

    protected AbstractTypedJacksonModule(Class<T> baseClass, Function<T, String> nameResolver, Function<String, Class<? extends T>> classResolver) {
        super(baseClass.getSimpleName() + "Module", Version.unknownVersion());
        InternalTypeResolver<? extends T> typeResolver = new InternalTypeResolver<T>(nameResolver, classResolver);
        this.addSerializer(baseClass, (JsonSerializer)new InternalTypeSerializer<T>(baseClass, (TypeIdResolver)typeResolver));
        this.addDeserializer(baseClass, (JsonDeserializer)new InternalTypeDeserializer<T>(baseClass, (TypeIdResolver)typeResolver));
    }

    private static class InternalTypeResolver<T>
    extends TypeIdResolverBase {
        private final Function<T, String> nameResolver;
        private final Function<String, Class<? extends T>> classResolver;

        public InternalTypeResolver(Function<T, String> nameResolver, Function<String, Class<? extends T>> classResolver) {
            this.nameResolver = Objects.requireNonNull(nameResolver, "nameResolver is null");
            this.classResolver = Objects.requireNonNull(classResolver, "classResolver is null");
        }

        public String idFromValue(Object value) {
            return this.idFromValueAndType(value, value.getClass());
        }

        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            Objects.requireNonNull(value, "value is null");
            String type = this.nameResolver.apply(value);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown class: %s", (Object)suggestedType.getSimpleName());
            return type;
        }

        public JavaType typeFromId(DatabindContext context, String id) {
            Objects.requireNonNull(id, "id is null");
            Class<? extends T> typeClass = this.classResolver.apply(id);
            Preconditions.checkArgument((typeClass != null ? 1 : 0) != 0, (String)"Unknown type ID: %s", (Object)id);
            return context.getTypeFactory().constructType(typeClass);
        }

        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.NAME;
        }
    }

    private static class InternalTypeSerializer<T>
    extends StdSerializer<T> {
        private final TypeSerializer typeSerializer;
        private final NonEvictableCache<Class<?>, JsonSerializer<T>> serializerCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder());

        public InternalTypeSerializer(Class<T> baseClass, TypeIdResolver typeIdResolver) {
            super(baseClass);
            this.typeSerializer = new AsPropertyTypeSerializer(typeIdResolver, null, AbstractTypedJacksonModule.TYPE_PROPERTY);
        }

        public void serialize(T value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (value == null) {
                provider.defaultSerializeNull(generator);
                return;
            }
            try {
                Class<?> type = value.getClass();
                JsonSerializer serializer = (JsonSerializer)this.serializerCache.get(type, () -> InternalTypeSerializer.createSerializer(provider, type));
                serializer.serializeWithType(value, generator, provider, this.typeSerializer);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    Throwables.throwIfInstanceOf((Throwable)cause, IOException.class);
                }
                throw new RuntimeException(e);
            }
        }

        private static <T> JsonSerializer<T> createSerializer(SerializerProvider provider, Class<?> type) throws JsonMappingException {
            JavaType javaType = provider.constructType(type);
            return BeanSerializerFactory.instance.createSerializer(provider, javaType);
        }
    }

    private static class InternalTypeDeserializer<T>
    extends StdDeserializer<T> {
        private final TypeDeserializer typeDeserializer;

        public InternalTypeDeserializer(Class<T> baseClass, TypeIdResolver typeIdResolver) {
            super(baseClass);
            this.typeDeserializer = new AsPropertyTypeDeserializer(TypeFactory.defaultInstance().constructType(baseClass), typeIdResolver, AbstractTypedJacksonModule.TYPE_PROPERTY, false, null);
        }

        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return (T)this.typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
        }
    }
}

