/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.AbstractPropertyManager;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.PlannerContext;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TableProceduresPropertyManager
extends AbstractPropertyManager<Key> {
    public TableProceduresPropertyManager() {
        super("procedure", (ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT);
    }

    public void addProperties(CatalogName catalogName, String procedureName, List<PropertyMetadata<?>> properties) {
        this.doAddProperties(new Key(catalogName, procedureName), properties);
    }

    public void removeProperties(CatalogName catalogName) {
        Set keysToRemove = (Set)this.connectorProperties.keySet().stream().filter(key -> catalogName.equals(key.getCatalogName())).collect(ImmutableSet.toImmutableSet());
        for (Key key2 : keysToRemove) {
            this.doRemoveProperties(key2);
        }
    }

    public Map<String, Object> getProperties(CatalogName catalog, String procedureName, String catalogNameForDiagnostics, Map<String, Expression> sqlPropertyValues, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        return this.doGetProperties(new Key(catalog, procedureName), catalogNameForDiagnostics, sqlPropertyValues, session, plannerContext, accessControl, parameters);
    }

    public Map<Key, Map<String, PropertyMetadata<?>>> getAllProperties() {
        return this.doGetAllProperties();
    }

    @Override
    protected String formatPropertiesKeyForMessage(String catalogName, Key propertiesKey) {
        return String.format("Catalog %s table procedure %s", catalogName, propertiesKey.procedureName);
    }

    static final class Key {
        private final CatalogName catalogName;
        private final String procedureName;

        private Key(CatalogName catalogName, String procedureName) {
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
            this.procedureName = Objects.requireNonNull(procedureName, "procedureName is null");
        }

        public CatalogName getCatalogName() {
            return this.catalogName;
        }

        public String getProcedureName() {
            return this.procedureName;
        }

        public String toString() {
            return this.catalogName + ":" + this.procedureName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.catalogName, key.catalogName) && Objects.equals(this.procedureName, key.procedureName);
        }

        public int hashCode() {
            return Objects.hash(this.catalogName, this.procedureName);
        }
    }
}

