/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexComparator;
import io.trino.operator.WindowOperator;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.Framing;
import io.trino.operator.window.GroupsFraming;
import io.trino.operator.window.PagesWindowIndex;
import io.trino.operator.window.RangeFraming;
import io.trino.operator.window.RowsFraming;
import io.trino.operator.window.WindowPartition;
import io.trino.spi.PageBuilder;
import io.trino.spi.function.WindowFunction;
import io.trino.spi.function.WindowIndex;
import io.trino.sql.tree.FrameBound;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RegularWindowPartition
implements WindowPartition {
    private final PagesIndex pagesIndex;
    private final int partitionStart;
    private final int partitionEnd;
    private final int[] outputChannels;
    private final List<WindowFunction> windowFunctions;
    private final PagesHashStrategy peerGroupHashStrategy;
    private int peerGroupStart;
    private int peerGroupEnd;
    private int currentGroupIndex = -1;
    private int currentPosition;
    private final Map<Integer, Framing> framings = new HashMap<Integer, Framing>();

    public RegularWindowPartition(PagesIndex pagesIndex, int partitionStart, int partitionEnd, int[] outputChannels, List<WindowFunction> windowFunctions, List<FrameInfo> frames, PagesHashStrategy peerGroupHashStrategy, Map<WindowOperator.FrameBoundKey, PagesIndexComparator> frameBoundComparators) {
        this.pagesIndex = pagesIndex;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
        this.outputChannels = outputChannels;
        this.windowFunctions = ImmutableList.copyOf(windowFunctions);
        this.peerGroupHashStrategy = peerGroupHashStrategy;
        PagesWindowIndex windowIndex = new PagesWindowIndex(pagesIndex, partitionStart, partitionEnd);
        for (WindowFunction windowFunction : windowFunctions) {
            windowFunction.reset((WindowIndex)windowIndex);
        }
        this.currentPosition = partitionStart;
        this.updatePeerGroup();
        for (int i = 0; i < windowFunctions.size(); ++i) {
            Framing framing;
            FrameInfo frame = frames.get(i);
            switch (frame.getType()) {
                case RANGE: {
                    PagesIndexComparator startComparator = frameBoundComparators.get(new WindowOperator.FrameBoundKey(i, WindowOperator.FrameBoundKey.Type.START));
                    PagesIndexComparator endComparator = frameBoundComparators.get(new WindowOperator.FrameBoundKey(i, WindowOperator.FrameBoundKey.Type.END));
                    if (frame.getEndType() == FrameBound.Type.UNBOUNDED_FOLLOWING) {
                        framing = new RangeFraming(frame, partitionStart, partitionEnd, startComparator, endComparator, pagesIndex, peerGroupHashStrategy, new Framing.Range(0, partitionEnd - partitionStart - 1));
                        break;
                    }
                    framing = new RangeFraming(frame, partitionStart, partitionEnd, startComparator, endComparator, pagesIndex, peerGroupHashStrategy, new Framing.Range(0, this.peerGroupEnd - partitionStart - 1));
                    break;
                }
                case ROWS: {
                    framing = new RowsFraming(frame, partitionStart, partitionEnd, pagesIndex);
                    break;
                }
                case GROUPS: {
                    framing = new GroupsFraming(frame, partitionStart, partitionEnd, pagesIndex, peerGroupHashStrategy, this.peerGroupEnd - partitionStart - 1);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not yet implemented");
                }
            }
            this.framings.put(i, framing);
        }
    }

    @Override
    public int getPartitionStart() {
        return this.partitionStart;
    }

    @Override
    public int getPartitionEnd() {
        return this.partitionEnd;
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.partitionEnd;
    }

    @Override
    public void processNextRow(PageBuilder pageBuilder) {
        int channel;
        Preconditions.checkState((boolean)this.hasNext(), (Object)"No more rows in partition");
        pageBuilder.declarePosition();
        for (channel = 0; channel < this.outputChannels.length; ++channel) {
            this.pagesIndex.appendTo(this.outputChannels[channel], this.currentPosition, pageBuilder.getBlockBuilder(channel));
        }
        if (this.currentPosition == this.peerGroupEnd) {
            this.updatePeerGroup();
        }
        for (int i = 0; i < this.windowFunctions.size(); ++i) {
            WindowFunction windowFunction = this.windowFunctions.get(i);
            Framing.Range range = this.framings.get(i).getRange(this.currentPosition, this.currentGroupIndex, this.peerGroupStart, this.peerGroupEnd);
            windowFunction.processRow(pageBuilder.getBlockBuilder(channel), this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart - 1, range.getStart(), range.getEnd());
            ++channel;
        }
        ++this.currentPosition;
    }

    private void updatePeerGroup() {
        ++this.currentGroupIndex;
        this.peerGroupStart = this.currentPosition;
        this.peerGroupEnd = this.peerGroupStart + 1;
        while (this.peerGroupEnd < this.partitionEnd && this.pagesIndex.positionNotDistinctFromPosition(this.peerGroupHashStrategy, this.peerGroupStart, this.peerGroupEnd)) {
            ++this.peerGroupEnd;
        }
    }
}

