/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.base.Preconditions;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class InjectedConnectorAccessControl
implements ConnectorAccessControl {
    private final AccessControl accessControl;
    private final SecurityContext securityContext;
    private final String catalogName;

    public InjectedConnectorAccessControl(AccessControl accessControl, SecurityContext securityContext, String catalogName) {
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.securityContext = Objects.requireNonNull(securityContext, "securityContext is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanCreateSchema(this.securityContext, this.getCatalogSchemaName(schemaName));
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanDropSchema(this.securityContext, this.getCatalogSchemaName(schemaName));
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanRenameSchema(this.securityContext, this.getCatalogSchemaName(schemaName), newSchemaName);
    }

    public void checkCanSetSchemaAuthorization(ConnectorSecurityContext context, String schemaName, TrinoPrincipal principal) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanSetSchemaAuthorization(this.securityContext, this.getCatalogSchemaName(schemaName), principal);
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanShowSchemas(this.securityContext, this.catalogName);
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        return this.accessControl.filterSchemas(this.securityContext, this.catalogName, schemaNames);
    }

    public void checkCanShowCreateSchema(ConnectorSecurityContext context, String schemaName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanShowCreateSchema(this.securityContext, this.getCatalogSchemaName(schemaName));
    }

    public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanShowCreateTable(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanCreateTable(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Object> properties) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanCreateTable(this.securityContext, this.getQualifiedObjectName(tableName), properties);
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanDropTable(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanTruncateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanTruncateTable(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanRenameTable(this.securityContext, this.getQualifiedObjectName(tableName), this.getQualifiedObjectName(tableName));
    }

    public void checkCanSetTableProperties(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Object> properties) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanSetTableProperties(this.securityContext, this.getQualifiedObjectName(tableName), properties);
    }

    public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanSetTableComment(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanSetColumnComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanSetColumnComment(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanShowTables(this.securityContext, this.getCatalogSchemaName(schemaName));
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        return this.accessControl.filterTables(this.securityContext, this.catalogName, tableNames);
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanShowColumns(this.securityContext, new CatalogSchemaTableName(this.catalogName, tableName));
    }

    public Set<String> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columns) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        return this.accessControl.filterColumns(this.securityContext, new CatalogSchemaTableName(this.catalogName, tableName), columns);
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanAddColumns(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanDropColumn(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanSetTableAuthorization(ConnectorSecurityContext context, SchemaTableName tableName, TrinoPrincipal principal) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanSetTableAuthorization(this.securityContext, this.getQualifiedObjectName(tableName), principal);
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanRenameColumn(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanSelectFromColumns(this.securityContext, this.getQualifiedObjectName(tableName), columnNames);
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanInsertIntoTable(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanDeleteFromTable(this.securityContext, this.getQualifiedObjectName(tableName));
    }

    public void checkCanUpdateTableColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> updatedColumns) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanUpdateTableColumns(this.securityContext, this.getQualifiedObjectName(tableName), updatedColumns);
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanCreateView(this.securityContext, this.getQualifiedObjectName(viewName));
    }

    public void checkCanSetViewAuthorization(ConnectorSecurityContext context, SchemaTableName viewName, TrinoPrincipal principal) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanSetViewAuthorization(this.securityContext, this.getQualifiedObjectName(viewName), principal);
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanRenameView(this.securityContext, this.getQualifiedObjectName(viewName), this.getQualifiedObjectName(viewName));
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanDropView(this.securityContext, this.getQualifiedObjectName(viewName));
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanCreateViewWithSelectFromColumns(this.securityContext, this.getQualifiedObjectName(tableName), columnNames);
    }

    public void checkCanCreateMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanCreateMaterializedView(this.securityContext, this.getQualifiedObjectName(materializedViewName));
    }

    public void checkCanCreateMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Object> properties) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanCreateMaterializedView(this.securityContext, this.getQualifiedObjectName(materializedViewName), properties);
    }

    public void checkCanRefreshMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanRefreshMaterializedView(this.securityContext, this.getQualifiedObjectName(materializedViewName));
    }

    public void checkCanDropMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanDropMaterializedView(this.securityContext, this.getQualifiedObjectName(materializedViewName));
    }

    public void checkCanRenameMaterializedView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanRenameMaterializedView(this.securityContext, this.getQualifiedObjectName(viewName), this.getQualifiedObjectName(newViewName));
    }

    public void checkCanSetMaterializedViewProperties(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Object> nonNullProperties, Set<String> nullPropertyNames) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanSetMaterializedViewProperties(this.securityContext, this.getQualifiedObjectName(materializedViewName), nonNullProperties, nullPropertyNames);
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanSetCatalogSessionProperty(this.securityContext, propertyName, this.catalogName);
    }

    public void checkCanGrantSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee, boolean grantOption) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanGrantSchemaPrivilege(this.securityContext, privilege, this.getCatalogSchemaName(schemaName), grantee, grantOption);
    }

    public void checkCanDenySchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanDenySchemaPrivilege(this.securityContext, privilege, this.getCatalogSchemaName(schemaName), grantee);
    }

    public void checkCanRevokeSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal revokee, boolean grantOption) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanRevokeSchemaPrivilege(this.securityContext, privilege, this.getCatalogSchemaName(schemaName), revokee, grantOption);
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee, boolean grantOption) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanGrantTablePrivilege(this.securityContext, privilege, this.getQualifiedObjectName(tableName), grantee, grantOption);
    }

    public void checkCanDenyTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanDenyTablePrivilege(this.securityContext, privilege, this.getQualifiedObjectName(tableName), grantee);
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal revokee, boolean grantOption) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanRevokeTablePrivilege(this.securityContext, privilege, this.getQualifiedObjectName(tableName), revokee, grantOption);
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanCreateRole(this.securityContext, role, grantor, Optional.of(this.catalogName));
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanDropRole(this.securityContext, role, Optional.of(this.catalogName));
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanGrantRoles(this.securityContext, roles, grantees, adminOption, grantor, Optional.of(this.catalogName));
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanRevokeRoles(this.securityContext, roles, grantees, adminOption, grantor, Optional.of(this.catalogName));
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanSetCatalogRole(this.securityContext, role, this.catalogName);
    }

    public void checkCanShowRoleAuthorizationDescriptors(ConnectorSecurityContext context) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanShowRoleAuthorizationDescriptors(this.securityContext, Optional.of(this.catalogName));
    }

    public void checkCanShowRoles(ConnectorSecurityContext context) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanShowRoles(this.securityContext, Optional.of(this.catalogName));
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanShowCurrentRoles(this.securityContext, Optional.of(this.catalogName));
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanShowRoleGrants(this.securityContext, Optional.of(this.catalogName));
    }

    public void checkCanExecuteProcedure(ConnectorSecurityContext context, SchemaRoutineName procedure) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanExecuteProcedure(this.securityContext, new QualifiedObjectName(this.catalogName, procedure.getSchemaName(), procedure.getRoutineName()));
    }

    public void checkCanExecuteTableProcedure(ConnectorSecurityContext context, SchemaTableName tableName, String procedure) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        this.accessControl.checkCanExecuteTableProcedure(this.securityContext, this.getQualifiedObjectName(tableName), procedure);
    }

    public Optional<ViewExpression> getRowFilter(ConnectorSecurityContext context, SchemaTableName tableName) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        if (this.accessControl.getRowFilters(this.securityContext, new QualifiedObjectName(this.catalogName, tableName.getSchemaName(), tableName.getTableName())).isEmpty()) {
            return Optional.empty();
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Row filtering not supported");
    }

    public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        Preconditions.checkArgument((context == null ? 1 : 0) != 0, (Object)"context must be null");
        if (this.accessControl.getColumnMasks(this.securityContext, new QualifiedObjectName(this.catalogName, tableName.getSchemaName(), tableName.getTableName()), columnName, type).isEmpty()) {
            return Optional.empty();
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Column masking not supported");
    }

    private QualifiedObjectName getQualifiedObjectName(SchemaTableName schemaTableName) {
        return new QualifiedObjectName(this.catalogName, schemaTableName.getSchemaName(), schemaTableName.getTableName());
    }

    private CatalogSchemaName getCatalogSchemaName(String schemaName) {
        return new CatalogSchemaName(this.catalogName, schemaName);
    }
}

