/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.testing.exchange;

import com.google.common.base.Preconditions;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.log.Logger;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import io.trino.spi.exchange.ExchangeSink;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.GuardedBy;
import org.openjdk.jol.info.ClassLayout;

public class LocalFileSystemExchangeSink
implements ExchangeSink {
    private static final Logger log = Logger.get(LocalFileSystemExchangeSink.class);
    public static final String COMMITTED_MARKER_FILE_NAME = "committed";
    public static final String DATA_FILE_SUFFIX = ".data";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LocalFileSystemExchangeSink.class).instanceSize();
    private static final int INTEGER_INSTANCE_SIZE = ClassLayout.parseClass(Integer.class).instanceSize();
    private static final int BUFFER_SIZE_IN_BYTES = Math.toIntExact(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE).toBytes());
    private final Path outputDirectory;
    private final int outputPartitionCount;
    @GuardedBy(value="this")
    private final Map<Integer, SliceOutput> outputs = new HashMap<Integer, SliceOutput>();
    @GuardedBy(value="this")
    private boolean committed;
    @GuardedBy(value="this")
    private boolean closed;

    public LocalFileSystemExchangeSink(Path outputDirectory, int outputPartitionCount) {
        this.outputDirectory = Objects.requireNonNull(outputDirectory, "outputDirectory is null");
        this.outputPartitionCount = outputPartitionCount;
    }

    public CompletableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    public synchronized void add(int partitionId, Slice data) {
        Preconditions.checkArgument((partitionId < this.outputPartitionCount ? 1 : 0) != 0, (String)"partition id is expected to be less than %s: %s", (int)this.outputPartitionCount, (int)partitionId);
        Preconditions.checkState((!this.committed ? 1 : 0) != 0, (Object)"already committed");
        if (this.closed) {
            return;
        }
        SliceOutput output = this.outputs.computeIfAbsent(partitionId, this::createOutput);
        output.writeInt(data.length());
        output.writeBytes(data);
    }

    private SliceOutput createOutput(int partitionId) {
        Path outputPath = this.outputDirectory.resolve(partitionId + DATA_FILE_SUFFIX);
        try {
            return new OutputStreamSliceOutput((OutputStream)new FileOutputStream(outputPath.toFile()), BUFFER_SIZE_IN_BYTES);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public synchronized long getMemoryUsage() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.outputs, ignored -> INTEGER_INSTANCE_SIZE, SliceOutput::getRetainedSize);
    }

    public synchronized void finish() {
        if (this.closed) {
            return;
        }
        try {
            for (SliceOutput output : this.outputs.values()) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            this.outputs.clear();
            try {
                Files.createFile(this.outputDirectory.resolve(COMMITTED_MARKER_FILE_NAME), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        catch (Throwable t) {
            this.abort();
            throw t;
        }
        this.committed = true;
        this.closed = true;
    }

    public synchronized void abort() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (SliceOutput output : this.outputs.values()) {
            try {
                output.close();
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Error closing output");
            }
        }
        this.outputs.clear();
        try {
            MoreFiles.deleteRecursively((Path)this.outputDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Error cleaning output directory");
        }
    }
}

