/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.testing.exchange;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.QueryId;
import io.trino.spi.exchange.ExchangeSinkHandle;
import java.util.Objects;

public class LocalFileSystemExchangeSinkHandle
implements ExchangeSinkHandle {
    private final QueryId queryId;
    private final int stageId;
    private final int taskPartitionId;

    @JsonCreator
    public LocalFileSystemExchangeSinkHandle(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="stageId") int stageId, @JsonProperty(value="taskPartitionId") int taskPartitionId) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.stageId = stageId;
        this.taskPartitionId = taskPartitionId;
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public int getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public int getTaskPartitionId() {
        return this.taskPartitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFileSystemExchangeSinkHandle sinkHandle = (LocalFileSystemExchangeSinkHandle)o;
        return this.stageId == sinkHandle.stageId && this.taskPartitionId == sinkHandle.taskPartitionId && Objects.equals(this.queryId, sinkHandle.queryId);
    }

    public int hashCode() {
        return Objects.hash(this.queryId, this.stageId, this.taskPartitionId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("stageId", this.stageId).add("taskPartitionId", this.taskPartitionId).toString();
    }
}

