/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.testing.exchange;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.units.DataSize;
import io.trino.spi.exchange.ExchangeSource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class LocalFileSystemExchangeSource
implements ExchangeSource {
    private static final int BUFFER_SIZE_IN_BYTES = Math.toIntExact(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE).toBytes());
    @GuardedBy(value="this")
    private final Iterator<Path> files;
    @GuardedBy(value="this")
    private SliceInput sliceInput;
    @GuardedBy(value="this")
    private boolean closed;

    public LocalFileSystemExchangeSource(List<Path> files) {
        this.files = ImmutableList.copyOf((Collection)Objects.requireNonNull(files, "files is null")).iterator();
    }

    public CompletableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    public synchronized boolean isFinished() {
        return this.closed || !this.files.hasNext() && this.sliceInput == null;
    }

    @Nullable
    public synchronized Slice read() {
        if (this.isFinished()) {
            return null;
        }
        if (this.sliceInput != null && !this.sliceInput.isReadable()) {
            this.sliceInput.close();
            this.sliceInput = null;
        }
        if (this.sliceInput == null && this.files.hasNext()) {
            Path file = this.files.next();
            try {
                this.sliceInput = new InputStreamSliceInput((InputStream)new FileInputStream(file.toFile()), BUFFER_SIZE_IN_BYTES);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (this.sliceInput == null) {
            return null;
        }
        if (!this.sliceInput.isReadable()) {
            this.sliceInput.close();
            this.sliceInput = null;
            return null;
        }
        int size = this.sliceInput.readInt();
        return this.sliceInput.readSlice(size);
    }

    public synchronized long getMemoryUsage() {
        return this.sliceInput != null ? this.sliceInput.getRetainedSize() : 0L;
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.sliceInput != null) {
                this.sliceInput.close();
                this.sliceInput = null;
            }
        }
    }
}

