/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.jsonwebtoken.JwtException;
import io.trino.server.ServletSecurityUtils;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.server.security.oauth2.ChallengeFailedException;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.ui.FormWebUiAuthenticationFilter;
import io.trino.server.ui.OAuthWebUiCookie;
import io.trino.server.ui.WebUiAuthenticationFilter;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;

public class OAuth2WebUiAuthenticationFilter
implements WebUiAuthenticationFilter {
    private static final Logger LOG = Logger.get(OAuth2WebUiAuthenticationFilter.class);
    private final String principalField;
    private final OAuth2Service service;
    private final UserMapping userMapping;
    private final Optional<String> groupsField;

    @Inject
    public OAuth2WebUiAuthenticationFilter(OAuth2Service service, OAuth2Config oauth2Config) {
        this.service = Objects.requireNonNull(service, "service is null");
        Objects.requireNonNull(oauth2Config, "oauth2Config is null");
        this.userMapping = UserMapping.createUserMapping(oauth2Config.getUserMappingPattern(), oauth2Config.getUserMappingFile());
        this.principalField = oauth2Config.getPrincipalField();
        this.groupsField = Objects.requireNonNull(oauth2Config.getGroupsField(), "groupsField is null");
    }

    public void filter(ContainerRequestContext request) {
        Optional<Map<String, Object>> claims;
        String path = request.getUriInfo().getRequestUri().getPath();
        if (path.equals("/ui/disabled.html")) {
            return;
        }
        if (!request.getSecurityContext().isSecure()) {
            if (path.startsWith("/ui/api/")) {
                ServletSecurityUtils.sendWwwAuthenticate(request, "Unauthorized", (Collection<String>)ImmutableSet.of((Object)"Trino-Form-Login"));
                return;
            }
            request.abortWith(Response.seeOther((URI)FormWebUiAuthenticationFilter.DISABLED_LOCATION_URI).build());
            return;
        }
        try {
            claims = this.getAccessToken(request);
            if (claims.isEmpty()) {
                this.needAuthentication(request);
                return;
            }
        }
        catch (ChallengeFailedException e) {
            LOG.debug((Throwable)e, "Invalid token: %s", new Object[]{e.getMessage()});
            ServletSecurityUtils.sendErrorMessage(request, Response.Status.UNAUTHORIZED, "Unauthorized");
            return;
        }
        try {
            Object principal = claims.get().get(this.principalField);
            if (!OAuth2WebUiAuthenticationFilter.isValidPrincipal(principal)) {
                LOG.debug("Invalid principal field: %s. Expected principal to be non-empty", new Object[]{this.principalField});
                ServletSecurityUtils.sendErrorMessage(request, Response.Status.UNAUTHORIZED, "Unauthorized");
                return;
            }
            String principalName = (String)principal;
            Identity.Builder builder = Identity.forUser((String)this.userMapping.mapUser(principalName));
            builder.withPrincipal((Principal)new BasicPrincipal(principalName));
            this.groupsField.flatMap(field -> Optional.ofNullable((List)((Map)claims.get()).get(field))).ifPresent(groups -> builder.withGroups((Set)ImmutableSet.copyOf((Collection)groups)));
            ServletSecurityUtils.setAuthenticatedIdentity(request, builder.build());
        }
        catch (UserMappingException e) {
            ServletSecurityUtils.sendErrorMessage(request, Response.Status.UNAUTHORIZED, (String)MoreObjects.firstNonNull((Object)e.getMessage(), (Object)"Unauthorized"));
        }
    }

    private Optional<Map<String, Object>> getAccessToken(ContainerRequestContext request) throws ChallengeFailedException {
        Optional<String> accessToken = OAuthWebUiCookie.read((Cookie)request.getCookies().get("__Secure-Trino-OAuth2-Token"));
        if (accessToken.isPresent()) {
            try {
                return this.service.convertTokenToClaims(accessToken.get());
            }
            catch (JwtException | IllegalArgumentException e) {
                LOG.debug(e, "Unable to parse JWT token");
            }
        }
        return Optional.empty();
    }

    private void needAuthentication(ContainerRequestContext request) {
        if (request.getUriInfo().getRequestUri().getPath().startsWith("/ui/api/")) {
            ServletSecurityUtils.sendWwwAuthenticate(request, "Unauthorized", (Collection<String>)ImmutableSet.of((Object)"Trino-Form-Login"));
            return;
        }
        request.abortWith(this.service.startOAuth2Challenge(request.getUriInfo()));
    }

    private static boolean isValidPrincipal(Object principal) {
        return principal instanceof String && !((String)principal).isEmpty();
    }
}

