/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.SortItem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class NodeUtils {
    private NodeUtils() {
    }

    public static List<SortItem> getSortItemsFromOrderBy(Optional<OrderBy> orderBy) {
        return orderBy.map(OrderBy::getSortItems).orElse((List)ImmutableList.of());
    }

    public static void throwOnDefaultProperty(Collection<Property> properties, String statementType) {
        Objects.requireNonNull(properties, "properties is null");
        Objects.requireNonNull(statementType, "statementType is null");
        properties.stream().filter(Property::isSetToDefault).findFirst().ifPresent(defaultProperty -> {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)defaultProperty, "Setting a property to DEFAULT is not supported in %s", statementType);
        });
    }
}

