/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.CachingCostProvider;
import io.trino.cost.CachingStatsProvider;
import io.trino.cost.CostCalculator;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.StatsCalculator;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.NewTableLayout;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.RelationId;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanBuilder;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.QueryPlanner;
import io.trino.sql.planner.RelationPlan;
import io.trino.sql.planner.RelationPlanner;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.StatisticsAggregationPlanner;
import io.trino.sql.planner.SubqueryPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DeleteNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RefreshMaterializedViewNode;
import io.trino.sql.planner.plan.StatisticAggregations;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.UpdateNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableExecute;
import io.trino.sql.tree.Update;
import io.trino.type.TypeCoercion;
import io.trino.type.UnknownType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class LogicalPlanner {
    private static final Logger LOG = Logger.get(LogicalPlanner.class);
    private final PlanNodeIdAllocator idAllocator;
    private final Session session;
    private final List<PlanOptimizer> planOptimizers;
    private final PlanSanityChecker planSanityChecker;
    private final SymbolAllocator symbolAllocator = new SymbolAllocator();
    private final Metadata metadata;
    private final PlannerContext plannerContext;
    private final TypeCoercion typeCoercion;
    private final TypeAnalyzer typeAnalyzer;
    private final StatisticsAggregationPlanner statisticsAggregationPlanner;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final WarningCollector warningCollector;

    public LogicalPlanner(Session session, List<PlanOptimizer> planOptimizers, PlanNodeIdAllocator idAllocator, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, StatsCalculator statsCalculator, CostCalculator costCalculator, WarningCollector warningCollector) {
        this(session, planOptimizers, PlanSanityChecker.DISTRIBUTED_PLAN_SANITY_CHECKER, idAllocator, plannerContext, typeAnalyzer, statsCalculator, costCalculator, warningCollector);
    }

    public LogicalPlanner(Session session, List<PlanOptimizer> planOptimizers, PlanSanityChecker planSanityChecker, PlanNodeIdAllocator idAllocator, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, StatsCalculator statsCalculator, CostCalculator costCalculator, WarningCollector warningCollector) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        this.planSanityChecker = Objects.requireNonNull(planSanityChecker, "planSanityChecker is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.metadata = plannerContext.getMetadata();
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        this.statisticsAggregationPlanner = new StatisticsAggregationPlanner(this.symbolAllocator, this.metadata, session);
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public Plan plan(Analysis analysis) {
        return this.plan(analysis, Stage.OPTIMIZED_AND_VALIDATED);
    }

    public Plan plan(Analysis analysis, Stage stage) {
        return this.plan(analysis, stage, analysis.getStatement() instanceof ExplainAnalyze || SystemSessionProperties.isCollectPlanStatisticsForAllQueries(this.session));
    }

    public Plan plan(Analysis analysis, Stage stage, boolean collectPlanStatistics) {
        PlanNode root = this.planStatement(analysis, analysis.getStatement());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initial plan:\n%s", new Object[]{PlanPrinter.textLogicalPlan(root, this.symbolAllocator.getTypes(), this.metadata, StatsAndCosts.empty(), this.session, 0, false)});
        }
        this.planSanityChecker.validateIntermediatePlan(root, this.session, this.plannerContext, this.typeAnalyzer, this.symbolAllocator.getTypes(), this.warningCollector);
        if (stage.ordinal() >= Stage.OPTIMIZED.ordinal()) {
            for (PlanOptimizer optimizer : this.planOptimizers) {
                root = optimizer.optimize(root, this.session, this.symbolAllocator.getTypes(), this.symbolAllocator, this.idAllocator, this.warningCollector);
                Objects.requireNonNull(root, String.format("%s returned a null plan", optimizer.getClass().getName()));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("%s:\n%s", new Object[]{optimizer.getClass().getName(), PlanPrinter.textLogicalPlan(root, this.symbolAllocator.getTypes(), this.metadata, StatsAndCosts.empty(), this.session, 0, false)});
            }
        }
        if (stage.ordinal() >= Stage.OPTIMIZED_AND_VALIDATED.ordinal()) {
            this.planSanityChecker.validateFinalPlan(root, this.session, this.plannerContext, this.typeAnalyzer, this.symbolAllocator.getTypes(), this.warningCollector);
        }
        TypeProvider types = this.symbolAllocator.getTypes();
        StatsAndCosts statsAndCosts = StatsAndCosts.empty();
        if (collectPlanStatistics) {
            CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator, this.session, types);
            CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, statsProvider, Optional.empty(), this.session, types);
            statsAndCosts = StatsAndCosts.create(root, statsProvider, costProvider);
        }
        return new Plan(root, types, statsAndCosts);
    }

    public PlanNode planStatement(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect && analysis.getCreate().orElseThrow().isCreateTableAsSelectNoOp() || statement instanceof RefreshMaterializedView && analysis.isSkipMaterializedViewRefresh()) {
            Symbol symbol = this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT);
            ValuesNode source = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)ImmutableList.of((Object)symbol), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new GenericLiteral("BIGINT", "0")))));
            return new OutputNode(this.idAllocator.getNextId(), source, (List<String>)ImmutableList.of((Object)"rows"), (List<Symbol>)ImmutableList.of((Object)symbol));
        }
        return this.createOutputPlan(this.planStatementWithoutOutput(analysis, statement), analysis);
    }

    private RelationPlan planStatementWithoutOutput(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect) {
            if (analysis.getCreate().orElseThrow().isCreateTableAsSelectNoOp()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE IF NOT EXISTS is not supported in this context " + statement.getClass().getSimpleName());
            }
            return this.createTableCreationPlan(analysis, ((CreateTableAsSelect)statement).getQuery());
        }
        if (statement instanceof Analyze) {
            return this.createAnalyzePlan(analysis, (Analyze)statement);
        }
        if (statement instanceof Insert) {
            Preconditions.checkState((boolean)analysis.getInsert().isPresent(), (Object)"Insert handle is missing");
            return this.createInsertPlan(analysis, (Insert)statement);
        }
        if (statement instanceof RefreshMaterializedView) {
            return this.createRefreshMaterializedViewPlan(analysis);
        }
        if (statement instanceof Delete) {
            return this.createDeletePlan(analysis, (Delete)statement);
        }
        if (statement instanceof Update) {
            return this.createUpdatePlan(analysis, (Update)statement);
        }
        if (statement instanceof Query) {
            return this.createRelationPlan(analysis, (Query)statement);
        }
        if (statement instanceof ExplainAnalyze) {
            return this.createExplainAnalyzePlan(analysis, (ExplainAnalyze)statement);
        }
        if (statement instanceof TableExecute) {
            return this.createTableExecutePlan(analysis, (TableExecute)statement);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type " + statement.getClass().getSimpleName());
    }

    private RelationPlan createExplainAnalyzePlan(Analysis analysis, ExplainAnalyze statement) {
        RelationPlan underlyingPlan = this.planStatementWithoutOutput(analysis, statement.getStatement());
        PlanNode root = underlyingPlan.getRoot();
        Scope scope = analysis.getScope((Node)statement);
        Symbol outputSymbol = this.symbolAllocator.newSymbol(scope.getRelationType().getFieldByIndex(0));
        ImmutableList.Builder actualOutputs = ImmutableList.builder();
        RelationType outputDescriptor = analysis.getOutputDescriptor((Node)statement.getStatement());
        for (Field field : outputDescriptor.getVisibleFields()) {
            int fieldIndex = outputDescriptor.indexOf(field);
            Symbol symbol = underlyingPlan.getSymbol(fieldIndex);
            actualOutputs.add((Object)symbol);
        }
        root = new ExplainAnalyzeNode(this.idAllocator.getNextId(), root, outputSymbol, (List<Symbol>)actualOutputs.build(), statement.isVerbose());
        return new RelationPlan(root, scope, (List<Symbol>)ImmutableList.of((Object)outputSymbol), Optional.empty());
    }

    private RelationPlan createAnalyzePlan(Analysis analysis, Analyze analyzeStatement) {
        TableHandle targetTable = analysis.getAnalyzeTarget().orElseThrow();
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, targetTable);
        ImmutableList.Builder tableScanOutputs = ImmutableList.builder();
        ImmutableMap.Builder symbolToColumnHandle = ImmutableMap.builder();
        ImmutableMap.Builder columnNameToSymbol = ImmutableMap.builder();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, targetTable);
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            Symbol symbol = this.symbolAllocator.newSymbol(column.getName(), column.getType());
            tableScanOutputs.add((Object)symbol);
            symbolToColumnHandle.put((Object)symbol, (Object)columnHandles.get(column.getName()));
            columnNameToSymbol.put((Object)column.getName(), (Object)symbol);
        }
        TableStatisticsMetadata tableStatisticsMetadata = this.metadata.getStatisticsCollectionMetadata(this.session, targetTable.getCatalogName().getCatalogName(), tableMetadata.getMetadata());
        StatisticsAggregationPlanner.TableStatisticAggregation tableStatisticAggregation = this.statisticsAggregationPlanner.createStatisticsAggregation(tableStatisticsMetadata, (Map<String, Symbol>)columnNameToSymbol.buildOrThrow());
        StatisticAggregations statisticAggregations = tableStatisticAggregation.getAggregations();
        List<Symbol> groupingSymbols = statisticAggregations.getGroupingSymbols();
        StatisticsWriterNode planNode = new StatisticsWriterNode(this.idAllocator.getNextId(), new AggregationNode(this.idAllocator.getNextId(), TableScanNode.newInstance(this.idAllocator.getNextId(), targetTable, (List<Symbol>)tableScanOutputs.build(), (Map<Symbol, ColumnHandle>)symbolToColumnHandle.buildOrThrow(), false, Optional.empty()), statisticAggregations.getAggregations(), AggregationNode.singleGroupingSet(groupingSymbols), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), new StatisticsWriterNode.WriteStatisticsReference(targetTable), this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), tableStatisticsMetadata.getTableStatistics().contains(TableStatisticType.ROW_COUNT), tableStatisticAggregation.getDescriptor());
        return new RelationPlan(planNode, analysis.getScope((Node)analyzeStatement), ((PlanNode)planNode).getOutputSymbols(), Optional.empty());
    }

    private RelationPlan createTableCreationPlan(Analysis analysis, Query query) {
        Analysis.Create create = analysis.getCreate().orElseThrow();
        QualifiedObjectName destination = create.getDestination().orElseThrow();
        RelationPlan plan = this.createRelationPlan(analysis, query);
        if (!create.isCreateTableAsSelectWithData()) {
            LimitNode root = new LimitNode(this.idAllocator.getNextId(), plan.getRoot(), 0L, false);
            plan = new RelationPlan(root, plan.getScope(), plan.getFieldMappings(), Optional.empty());
        }
        ConnectorTableMetadata tableMetadata = create.getMetadata().orElseThrow();
        Optional<NewTableLayout> newTableLayout = create.getLayout();
        List columnNames = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, destination.getCatalogName(), tableMetadata);
        return this.createTableWriterPlan(analysis, plan.getRoot(), QueryPlanner.visibleFields(plan), new TableWriterNode.CreateReference(destination.getCatalogName(), tableMetadata, newTableLayout), columnNames, tableMetadata.getColumns(), newTableLayout, statisticsMetadata);
    }

    private RelationPlan getInsertPlan(Analysis analysis, Table table, Query query, TableHandle tableHandle, List<ColumnHandle> insertColumns, Optional<NewTableLayout> newTableLayout, Optional<TableWriterNode.WriterTarget> materializedViewRefreshWriterTarget) {
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, tableHandle);
        Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap = LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator);
        RelationPlanner planner = new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, lambdaDeclarationToSymbolMap, this.plannerContext, Optional.empty(), this.session, (Map<NodeRef<Node>, RelationPlan>)ImmutableMap.of());
        RelationPlan plan = (RelationPlan)planner.process((Node)query, null);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < plan.getFieldMappings().size(); ++i) {
            if (plan.getDescriptor().getFieldByIndex(i).isHidden()) continue;
            builder.add((Object)plan.getFieldMappings().get(i));
        }
        ImmutableList visibleFieldMappings = builder.build();
        Map<String, ColumnHandle> columns = this.metadata.getColumnHandles(this.session, tableHandle);
        Assignments.Builder assignments = Assignments.builder();
        boolean supportsMissingColumnsOnInsert = this.metadata.supportsMissingColumnsOnInsert(this.session, tableHandle);
        ImmutableList.Builder insertedColumnsBuilder = ImmutableList.builder();
        for (ColumnMetadata column2 : tableMetadata.getColumns()) {
            if (column2.isHidden()) continue;
            Symbol output = this.symbolAllocator.newSymbol(column2.getName(), column2.getType());
            int index = insertColumns.indexOf(columns.get(column2.getName()));
            if (index < 0) {
                if (supportsMissingColumnsOnInsert) continue;
                Cast cast = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType(column2.getType()));
                assignments.put(output, (Expression)cast);
                insertedColumnsBuilder.add((Object)column2);
                continue;
            }
            Symbol input = (Symbol)visibleFieldMappings.get(index);
            Type tableType = column2.getType();
            Type queryType = this.symbolAllocator.getTypes().get(input);
            if (queryType.equals(tableType) || this.typeCoercion.isTypeOnlyCoercion(queryType, tableType)) {
                assignments.put(output, (Expression)input.toSymbolReference());
            } else {
                Expression cast = this.noTruncationCast((Expression)input.toSymbolReference(), queryType, tableType);
                assignments.put(output, cast);
            }
            insertedColumnsBuilder.add((Object)column2);
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), assignments.build());
        ImmutableList insertedColumns = insertedColumnsBuilder.build();
        List fields = (List)insertedColumns.stream().map(column -> Field.newUnqualified(column.getName(), column.getType())).collect(ImmutableList.toImmutableList());
        Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(fields)).build();
        plan = new RelationPlan(projectNode, scope, projectNode.getOutputSymbols(), Optional.empty());
        plan = planner.addRowFilters(table, plan, LogicalPlanner.failIfPredicateIsNotMeet(this.metadata, this.session, StandardErrorCode.PERMISSION_DENIED, "Access Denied: Cannot insert row that does not match to a row filter"), node -> {
            Scope accessControlScope = analysis.getAccessControlScope(table);
            return Scope.builder().like(accessControlScope).withRelationType(accessControlScope.getRelationId(), accessControlScope.getRelationType().withOnlyVisibleFields()).build();
        });
        List insertedTableColumnNames = (List)insertedColumns.stream().map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        String catalogName = tableHandle.getCatalogName().getCatalogName();
        TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, catalogName, tableMetadata.getMetadata());
        if (materializedViewRefreshWriterTarget.isPresent()) {
            return this.createTableWriterPlan(analysis, plan.getRoot(), plan.getFieldMappings(), materializedViewRefreshWriterTarget.get(), insertedTableColumnNames, (List<ColumnMetadata>)insertedColumns, newTableLayout, statisticsMetadata);
        }
        TableWriterNode.InsertReference insertTarget = new TableWriterNode.InsertReference(tableHandle, (List)insertedTableColumnNames.stream().map(columns::get).collect(ImmutableList.toImmutableList()));
        return this.createTableWriterPlan(analysis, plan.getRoot(), plan.getFieldMappings(), insertTarget, insertedTableColumnNames, (List<ColumnMetadata>)insertedColumns, newTableLayout, statisticsMetadata);
    }

    private static Function<Expression, Expression> failIfPredicateIsNotMeet(Metadata metadata, Session session, StandardErrorCode errorCode, String errorMessage) {
        ResolvedFunction fail = metadata.resolveFunction(session, QualifiedName.of((String)"fail"), TypeSignatureProvider.fromTypes(new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR}));
        return predicate -> new IfExpression(predicate, (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new FunctionCall(fail.toQualifiedName(), (List)ImmutableList.of((Object)new Cast((Expression)new LongLiteral(Long.toString(errorCode.toErrorCode().getCode())), TypeSignatureTranslator.toSqlType((Type)IntegerType.INTEGER)), (Object)new Cast((Expression)new StringLiteral(errorMessage), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)))), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)));
    }

    private RelationPlan createInsertPlan(Analysis analysis, Insert insertStatement) {
        Analysis.Insert insert = analysis.getInsert().orElseThrow();
        TableHandle tableHandle = insert.getTarget();
        Query query = insertStatement.getQuery();
        Optional<NewTableLayout> newTableLayout = insert.getNewTableLayout();
        return this.getInsertPlan(analysis, insert.getTable(), query, tableHandle, insert.getColumns(), newTableLayout, Optional.empty());
    }

    private RelationPlan createRefreshMaterializedViewPlan(Analysis analysis) {
        Optional<QualifiedObjectName> delegatedRefreshMaterializedView = analysis.getDelegatedRefreshMaterializedView();
        if (delegatedRefreshMaterializedView.isPresent()) {
            return new RelationPlan(new RefreshMaterializedViewNode(this.idAllocator.getNextId(), delegatedRefreshMaterializedView.get()), analysis.getRootScope(), (List<Symbol>)ImmutableList.of(), Optional.empty());
        }
        Preconditions.checkState((boolean)analysis.getRefreshMaterializedView().isPresent(), (Object)"RefreshMaterializedViewAnalysis handle is missing");
        Analysis.RefreshMaterializedViewAnalysis viewAnalysis = analysis.getRefreshMaterializedView().get();
        TableHandle tableHandle = viewAnalysis.getTarget();
        Query query = viewAnalysis.getQuery();
        Optional<NewTableLayout> newTableLayout = this.metadata.getInsertLayout(this.session, viewAnalysis.getTarget());
        TableWriterNode.RefreshMaterializedViewReference writerTarget = new TableWriterNode.RefreshMaterializedViewReference(viewAnalysis.getTable(), tableHandle, new ArrayList<TableHandle>(analysis.getTables()));
        return this.getInsertPlan(analysis, viewAnalysis.getTable(), query, tableHandle, viewAnalysis.getColumns(), newTableLayout, Optional.of(writerTarget));
    }

    private RelationPlan createTableWriterPlan(Analysis analysis, PlanNode source, List<Symbol> symbols, TableWriterNode.WriterTarget target, List<String> columnNames, List<ColumnMetadata> columnMetadataList, Optional<NewTableLayout> writeTableLayout, TableStatisticsMetadata statisticsMetadata) {
        Optional<PartitioningScheme> partitioningScheme = Optional.empty();
        Optional<PartitioningScheme> preferredPartitioningScheme = Optional.empty();
        if (writeTableLayout.isPresent()) {
            ArrayList<Symbol> partitionFunctionArguments = new ArrayList<Symbol>();
            writeTableLayout.get().getPartitionColumns().stream().mapToInt(columnNames::indexOf).mapToObj(symbols::get).forEach(partitionFunctionArguments::add);
            ArrayList<Symbol> outputLayout = new ArrayList<Symbol>(symbols);
            Optional<PartitioningHandle> partitioningHandle = writeTableLayout.get().getPartitioning();
            if (partitioningHandle.isPresent()) {
                partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(partitioningHandle.get(), partitionFunctionArguments), outputLayout));
            } else {
                preferredPartitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, partitionFunctionArguments), outputLayout));
            }
        }
        Verify.verify((columnNames.size() == symbols.size() ? 1 : 0) != 0, (String)"columnNames.size() != symbols.size(): %s and %s", columnNames, symbols);
        Map columnToSymbolMap = (Map)Streams.zip(columnNames.stream(), symbols.stream(), AbstractMap.SimpleImmutableEntry::new).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Set notNullColumnSymbols = (Set)columnMetadataList.stream().filter(column -> !column.isNullable()).map(ColumnMetadata::getName).map(columnToSymbolMap::get).collect(ImmutableSet.toImmutableSet());
        if (!statisticsMetadata.isEmpty()) {
            StatisticsAggregationPlanner.TableStatisticAggregation result = this.statisticsAggregationPlanner.createStatisticsAggregation(statisticsMetadata, columnToSymbolMap);
            StatisticAggregations.Parts aggregations = result.getAggregations().createPartialAggregations(this.symbolAllocator, this.plannerContext);
            StatisticAggregations partialAggregation = aggregations.getPartialAggregation();
            TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), new TableWriterNode(this.idAllocator.getNextId(), source, target, this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY), symbols, columnNames, notNullColumnSymbols, partitioningScheme, preferredPartitioningScheme, Optional.of(partialAggregation), Optional.of(result.getDescriptor().map(aggregations.getMappings()::get))), target, this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.of(aggregations.getFinalAggregation()), Optional.of(result.getDescriptor()));
            return new RelationPlan(commitNode, analysis.getRootScope(), commitNode.getOutputSymbols(), Optional.empty());
        }
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), new TableWriterNode(this.idAllocator.getNextId(), source, target, this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY), symbols, columnNames, notNullColumnSymbols, partitioningScheme, preferredPartitioningScheme, Optional.empty(), Optional.empty()), target, this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        return new RelationPlan(commitNode, analysis.getRootScope(), commitNode.getOutputSymbols(), Optional.empty());
    }

    private Expression noTruncationCast(Expression expression, Type fromType, Type toType) {
        int targetLength;
        if (fromType instanceof UnknownType || !(toType instanceof VarcharType) && !(toType instanceof CharType)) {
            return new Cast(expression, TypeSignatureTranslator.toSqlType(toType));
        }
        if (toType instanceof VarcharType) {
            if (((VarcharType)toType).isUnbounded()) {
                return new Cast(expression, TypeSignatureTranslator.toSqlType(toType));
            }
            targetLength = ((VarcharType)toType).getBoundedLength();
        } else {
            targetLength = ((CharType)toType).getLength();
        }
        Preconditions.checkState((fromType instanceof VarcharType || fromType instanceof CharType ? 1 : 0) != 0, (Object)"inserting non-character value to column of character type");
        ResolvedFunction spaceTrimmedLength = this.metadata.resolveFunction(this.session, QualifiedName.of((String)"$space_trimmed_length"), TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR}));
        ResolvedFunction fail = this.metadata.resolveFunction(this.session, QualifiedName.of((String)"fail"), TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR}));
        return new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new GenericLiteral("BIGINT", Integer.toString(targetLength)), (Expression)new CoalesceExpression((Expression)new FunctionCall(spaceTrimmedLength.toQualifiedName(), (List)ImmutableList.of((Object)new Cast(expression, TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)))), (Expression)new GenericLiteral("BIGINT", "0"), new Expression[0])), (Expression)new Cast(expression, TypeSignatureTranslator.toSqlType(toType)), (Expression)new Cast((Expression)new FunctionCall(fail.toQualifiedName(), (List)ImmutableList.of((Object)new Cast((Expression)new StringLiteral(String.format("Cannot truncate non-space characters when casting from %s to %s on INSERT", fromType.getDisplayName(), toType.getDisplayName())), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)))), TypeSignatureTranslator.toSqlType(toType)));
    }

    private RelationPlan createDeletePlan(Analysis analysis, Delete node) {
        DeleteNode deleteNode = new QueryPlanner(analysis, this.symbolAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator), this.plannerContext, Optional.empty(), this.session, (Map<NodeRef<Node>, RelationPlan>)ImmutableMap.of()).plan(node);
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), deleteNode, deleteNode.getTarget(), this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        return new RelationPlan(commitNode, analysis.getScope((Node)node), commitNode.getOutputSymbols(), Optional.empty());
    }

    private RelationPlan createUpdatePlan(Analysis analysis, Update node) {
        UpdateNode updateNode = new QueryPlanner(analysis, this.symbolAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator), this.plannerContext, Optional.empty(), this.session, (Map<NodeRef<Node>, RelationPlan>)ImmutableMap.of()).plan(node);
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), updateNode, updateNode.getTarget(), this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        return new RelationPlan(commitNode, analysis.getScope((Node)node), commitNode.getOutputSymbols(), Optional.empty());
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        ImmutableList.Builder names = ImmutableList.builder();
        int columnNumber = 0;
        RelationType outputDescriptor = analysis.getOutputDescriptor();
        for (Field field : outputDescriptor.getVisibleFields()) {
            String name = field.getName().orElse("_col" + columnNumber);
            names.add((Object)name);
            int fieldIndex = outputDescriptor.indexOf(field);
            Symbol symbol = plan.getSymbol(fieldIndex);
            outputs.add((Object)symbol);
            ++columnNumber;
        }
        return new OutputNode(this.idAllocator.getNextId(), plan.getRoot(), (List<String>)names.build(), (List<Symbol>)outputs.build());
    }

    private RelationPlan createRelationPlan(Analysis analysis, Query query) {
        return (RelationPlan)this.getRelationPlanner(analysis).process((Node)query, null);
    }

    private RelationPlan createRelationPlan(Analysis analysis, Table table) {
        return (RelationPlan)this.getRelationPlanner(analysis).process((Node)table, null);
    }

    private RelationPlanner getRelationPlanner(Analysis analysis) {
        return new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator), this.plannerContext, Optional.empty(), this.session, (Map<NodeRef<Node>, RelationPlan>)ImmutableMap.of());
    }

    private static Map<NodeRef<LambdaArgumentDeclaration>, Symbol> buildLambdaDeclarationToSymbolMap(Analysis analysis, SymbolAllocator symbolAllocator) {
        HashMap<Key, Symbol> allocations = new HashMap<Key, Symbol>();
        LinkedHashMap<NodeRef<LambdaArgumentDeclaration>, Symbol> result = new LinkedHashMap<NodeRef<LambdaArgumentDeclaration>, Symbol>();
        for (Map.Entry<NodeRef<Expression>, Type> entry : analysis.getTypes().entrySet()) {
            if (!(entry.getKey().getNode() instanceof LambdaArgumentDeclaration)) continue;
            LambdaArgumentDeclaration argument = (LambdaArgumentDeclaration)entry.getKey().getNode();
            Key key = new Key(argument, entry.getValue());
            Symbol symbol = (Symbol)allocations.get(key);
            if (symbol == null) {
                symbol = symbolAllocator.newSymbol((Expression)argument, entry.getValue());
                allocations.put(key, symbol);
            }
            result.put((NodeRef<LambdaArgumentDeclaration>)NodeRef.of((Node)argument), symbol);
        }
        return result;
    }

    private RelationPlan createTableExecutePlan(Analysis analysis, TableExecute statement) {
        Table table = statement.getTable();
        TableHandle tableHandle = analysis.getTableHandle(table);
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)statement, table.getName());
        TableExecuteHandle executeHandle = analysis.getTableExecuteHandle().orElseThrow();
        RelationPlan tableScanPlan = this.createRelationPlan(analysis, table);
        PlanBuilder sourcePlanBuilder = PlanBuilder.newPlanBuilder(tableScanPlan, analysis, (Map<NodeRef<LambdaArgumentDeclaration>, Symbol>)ImmutableMap.of(), (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of());
        if (statement.getWhere().isPresent()) {
            SubqueryPlanner subqueryPlanner = new SubqueryPlanner(analysis, this.symbolAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToSymbolMap(analysis, this.symbolAllocator), this.plannerContext, this.typeCoercion, Optional.empty(), this.session, (Map<NodeRef<Node>, RelationPlan>)ImmutableMap.of());
            Expression whereExpression = (Expression)statement.getWhere().get();
            sourcePlanBuilder = subqueryPlanner.handleSubqueries(sourcePlanBuilder, whereExpression, analysis.getSubqueries((Node)statement));
            sourcePlanBuilder = sourcePlanBuilder.withNewRoot(new FilterNode(this.idAllocator.getNextId(), sourcePlanBuilder.getRoot(), sourcePlanBuilder.rewrite(whereExpression)));
        }
        PlanNode sourcePlanRoot = sourcePlanBuilder.getRoot();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, tableHandle);
        List columnNames = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        TableWriterNode.TableExecuteTarget tableExecuteTarget = new TableWriterNode.TableExecuteTarget(executeHandle, Optional.empty(), tableName.asSchemaTableName());
        Optional<NewTableLayout> layout = this.metadata.getLayoutForTableExecute(this.session, executeHandle);
        List<Symbol> symbols = QueryPlanner.visibleFields(tableScanPlan);
        Optional<PartitioningScheme> partitioningScheme = Optional.empty();
        Optional<PartitioningScheme> preferredPartitioningScheme = Optional.empty();
        if (layout.isPresent()) {
            ArrayList<Symbol> partitionFunctionArguments = new ArrayList<Symbol>();
            layout.get().getPartitionColumns().stream().mapToInt(columnNames::indexOf).mapToObj(symbols::get).forEach(partitionFunctionArguments::add);
            ArrayList<Symbol> outputLayout = new ArrayList<Symbol>(symbols);
            Optional<PartitioningHandle> partitioningHandle = layout.get().getPartitioning();
            if (partitioningHandle.isPresent()) {
                partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(partitioningHandle.get(), partitionFunctionArguments), outputLayout));
            } else {
                preferredPartitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, partitionFunctionArguments), outputLayout));
            }
        }
        Verify.verify((columnNames.size() == symbols.size() ? 1 : 0) != 0, (String)"columnNames.size() != symbols.size(): %s and %s", (Object)columnNames, symbols);
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), new TableExecuteNode(this.idAllocator.getNextId(), sourcePlanRoot, tableExecuteTarget, this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY), symbols, columnNames, partitioningScheme, preferredPartitioningScheme), tableExecuteTarget, this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        return new RelationPlan(commitNode, analysis.getRootScope(), commitNode.getOutputSymbols(), Optional.empty());
    }

    private static class Key {
        private final LambdaArgumentDeclaration argument;
        private final Type type;

        public Key(LambdaArgumentDeclaration argument, Type type) {
            this.argument = Objects.requireNonNull(argument, "argument is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.argument, key.argument) && Objects.equals(this.type, key.type);
        }

        public int hashCode() {
            return Objects.hash(this.argument, this.type);
        }
    }

    public static enum Stage {
        CREATED,
        OPTIMIZED,
        OPTIMIZED_AND_VALIDATED;

    }
}

