/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.informationschema;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.informationschema.InformationSchemaColumnHandle;
import io.trino.connector.informationschema.InformationSchemaMetadata;
import io.trino.connector.informationschema.InformationSchemaTable;
import io.trino.connector.informationschema.InformationSchemaTableHandle;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.ViewInfo;
import io.trino.security.AccessControl;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.Type;
import io.trino.type.TypeUtils;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class InformationSchemaPageSource
implements ConnectorPageSource {
    private final Session session;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final String catalogName;
    private final InformationSchemaTable table;
    private final Supplier<Iterator<QualifiedTablePrefix>> prefixIterator;
    private final OptionalLong limit;
    private final List<Type> types;
    private final Queue<Page> pages = new ArrayDeque<Page>();
    private final PageBuilder pageBuilder;
    private final Function<Page, Page> projection;
    private final Optional<Set<String>> roles;
    private final Optional<Set<String>> grantees;
    private long recordCount;
    private long completedBytes;
    private long memoryUsageBytes;
    private boolean closed;

    public InformationSchemaPageSource(Session session, Metadata metadata, AccessControl accessControl, InformationSchemaTableHandle tableHandle, List<ColumnHandle> columns) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(columns, "columns is null");
        this.catalogName = tableHandle.getCatalogName();
        this.table = tableHandle.getTable();
        this.prefixIterator = Suppliers.memoize(() -> {
            Set prefixes = tableHandle.getPrefixes();
            if (tableHandle.getLimit().isEmpty()) {
                return prefixes.iterator();
            }
            if (InformationSchemaMetadata.isTablesEnumeratingTable(this.table)) {
                if (prefixes.equals(InformationSchemaMetadata.defaultPrefixes(this.catalogName))) {
                    prefixes = (Set)metadata.listSchemaNames(session, this.catalogName).stream().map(schema -> new QualifiedTablePrefix(this.catalogName, (String)schema)).collect(ImmutableSet.toImmutableSet());
                }
            } else {
                Preconditions.checkArgument((boolean)prefixes.equals(InformationSchemaMetadata.defaultPrefixes(this.catalogName)), (Object)"Catalog-wise tables have prefixes other than the default one");
            }
            return prefixes.iterator();
        });
        this.limit = tableHandle.getLimit();
        this.roles = tableHandle.getRoles();
        this.grantees = tableHandle.getGrantees();
        List columnMetadata = this.table.getTableMetadata().getColumns();
        this.types = (List)columnMetadata.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        this.pageBuilder = new PageBuilder(this.types);
        Map columnNameToChannel = (Map)IntStream.range(0, columnMetadata.size()).boxed().collect(ImmutableMap.toImmutableMap(i -> ((ColumnMetadata)columnMetadata.get((int)i)).getName(), Function.identity()));
        List channels = (List)columns.stream().map(columnHandle -> (InformationSchemaColumnHandle)columnHandle).map(columnHandle -> (Integer)columnNameToChannel.get(columnHandle.getColumnName())).collect(ImmutableList.toImmutableList());
        this.projection = page -> {
            Block[] blocks = new Block[channels.size()];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = page.getBlock(((Integer)channels.get(i)).intValue());
            }
            return new Page(page.getPositionCount(), blocks);
        };
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.closed || this.pages.isEmpty() && (!this.prefixIterator.get().hasNext() || this.isLimitExhausted());
    }

    public Page getNextPage() {
        Page page;
        if (this.isFinished()) {
            return null;
        }
        if (this.pages.isEmpty()) {
            this.buildPages();
        }
        if ((page = this.pages.poll()) == null) {
            return null;
        }
        this.memoryUsageBytes -= page.getRetainedSizeInBytes();
        Page outputPage = this.projection.apply(page);
        this.completedBytes += outputPage.getSizeInBytes();
        return outputPage;
    }

    public long getMemoryUsage() {
        return this.memoryUsageBytes + this.pageBuilder.getRetainedSizeInBytes();
    }

    public void close() {
        this.closed = true;
    }

    private void buildPages() {
        while (this.pages.isEmpty() && this.prefixIterator.get().hasNext() && !this.closed && !this.isLimitExhausted()) {
            QualifiedTablePrefix prefix = this.prefixIterator.get().next();
            switch (this.table) {
                case COLUMNS: {
                    this.addColumnsRecords(prefix);
                    break;
                }
                case TABLES: {
                    this.addTablesRecords(prefix);
                    break;
                }
                case VIEWS: {
                    this.addViewsRecords(prefix);
                    break;
                }
                case SCHEMATA: {
                    this.addSchemataRecords();
                    break;
                }
                case TABLE_PRIVILEGES: {
                    this.addTablePrivilegesRecords(prefix);
                    break;
                }
                case ROLES: {
                    this.addRolesRecords();
                    break;
                }
                case APPLICABLE_ROLES: {
                    this.addApplicableRolesRecords();
                    break;
                }
                case ENABLED_ROLES: {
                    this.addEnabledRolesRecords();
                    break;
                }
                case ROLE_AUTHORIZATION_DESCRIPTORS: {
                    this.addRoleAuthorizationDescriptorRecords();
                }
            }
        }
        if (!this.prefixIterator.get().hasNext() || this.isLimitExhausted()) {
            this.flushPageBuilder();
        }
    }

    private void addColumnsRecords(QualifiedTablePrefix prefix) {
        for (Map.Entry<SchemaTableName, List<ColumnMetadata>> entry : MetadataListing.listTableColumns(this.session, this.metadata, this.accessControl, prefix).entrySet()) {
            SchemaTableName tableName = entry.getKey();
            long ordinalPosition = 1L;
            for (ColumnMetadata column : entry.getValue()) {
                if (column.isHidden()) continue;
                this.addRecord(prefix.getCatalogName(), tableName.getSchemaName(), tableName.getTableName(), column.getName(), ordinalPosition, null, "YES", TypeUtils.getDisplayLabel(column.getType(), SystemSessionProperties.isOmitDateTimeTypePrecision(this.session)), column.getComment(), column.getExtraInfo(), column.getComment());
                ++ordinalPosition;
                if (!this.isLimitExhausted()) continue;
                return;
            }
        }
    }

    private void addTablesRecords(QualifiedTablePrefix prefix) {
        Set<SchemaTableName> tables = MetadataListing.listTables(this.session, this.metadata, this.accessControl, prefix);
        Set<SchemaTableName> views = MetadataListing.listViews(this.session, this.metadata, this.accessControl, prefix);
        for (SchemaTableName name : Sets.union(tables, views)) {
            String type = views.contains(name) ? "VIEW" : "BASE TABLE";
            this.addRecord(prefix.getCatalogName(), name.getSchemaName(), name.getTableName(), type, null);
            if (!this.isLimitExhausted()) continue;
            return;
        }
    }

    private void addViewsRecords(QualifiedTablePrefix prefix) {
        for (Map.Entry<SchemaTableName, ViewInfo> entry : MetadataListing.getViews(this.session, this.metadata, this.accessControl, prefix).entrySet()) {
            this.addRecord(prefix.getCatalogName(), entry.getKey().getSchemaName(), entry.getKey().getTableName(), entry.getValue().getOriginalSql());
            if (!this.isLimitExhausted()) continue;
            return;
        }
    }

    private void addSchemataRecords() {
        for (String schema : MetadataListing.listSchemas(this.session, this.metadata, this.accessControl, this.catalogName)) {
            this.addRecord(this.catalogName, schema);
            if (!this.isLimitExhausted()) continue;
            return;
        }
    }

    private void addTablePrivilegesRecords(QualifiedTablePrefix prefix) {
        ImmutableList grants = ImmutableList.copyOf(MetadataListing.listTablePrivileges(this.session, this.metadata, this.accessControl, prefix));
        for (GrantInfo grant : grants) {
            this.addRecord(grant.getGrantor().map(TrinoPrincipal::getName).orElse(null), grant.getGrantor().map(principal -> principal.getType().toString()).orElse(null), grant.getGrantee().getName(), grant.getGrantee().getType().toString(), prefix.getCatalogName(), grant.getSchemaTableName().getSchemaName(), grant.getSchemaTableName().getTableName(), grant.getPrivilegeInfo().getPrivilege().name(), grant.getPrivilegeInfo().isGrantOption() ? "YES" : "NO", grant.getWithHierarchy().map(withHierarchy -> withHierarchy != false ? "YES" : "NO").orElse(null));
            if (!this.isLimitExhausted()) continue;
            return;
        }
    }

    private void addRolesRecords() {
        try {
            this.accessControl.checkCanShowRoles(this.session.toSecurityContext(), Optional.of(this.catalogName));
        }
        catch (AccessDeniedException exception) {
            return;
        }
        for (String role : this.metadata.listRoles(this.session, Optional.of(this.catalogName))) {
            this.addRecord(role);
            if (!this.isLimitExhausted()) continue;
            return;
        }
    }

    private void addRoleAuthorizationDescriptorRecords() {
        try {
            this.accessControl.checkCanShowRoleAuthorizationDescriptors(this.session.toSecurityContext(), Optional.of(this.catalogName));
        }
        catch (AccessDeniedException exception) {
            return;
        }
        for (RoleGrant grant : this.metadata.listAllRoleGrants(this.session, Optional.of(this.catalogName), this.roles, this.grantees, this.limit)) {
            this.addRecord(grant.getRoleName(), null, null, grant.getGrantee().getName(), grant.getGrantee().getType().toString(), grant.isGrantable() ? "YES" : "NO");
            if (!this.isLimitExhausted()) continue;
            return;
        }
    }

    private void addApplicableRolesRecords() {
        for (RoleGrant grant : this.metadata.listApplicableRoles(this.session, new TrinoPrincipal(PrincipalType.USER, this.session.getUser()), Optional.of(this.catalogName))) {
            this.addRecord(grant.getGrantee().getName(), grant.getGrantee().getType().toString(), grant.getRoleName(), grant.isGrantable() ? "YES" : "NO");
            if (!this.isLimitExhausted()) continue;
            return;
        }
    }

    private void addEnabledRolesRecords() {
        for (String role : this.metadata.listEnabledRoles(this.session, this.catalogName)) {
            this.addRecord(role);
            if (!this.isLimitExhausted()) continue;
            return;
        }
    }

    private void addRecord(Object ... values) {
        this.pageBuilder.declarePosition();
        for (int i = 0; i < this.types.size(); ++i) {
            io.trino.spi.type.TypeUtils.writeNativeValue((Type)this.types.get(i), (BlockBuilder)this.pageBuilder.getBlockBuilder(i), (Object)values[i]);
        }
        if (this.pageBuilder.isFull()) {
            this.flushPageBuilder();
        }
        ++this.recordCount;
    }

    private void flushPageBuilder() {
        if (!this.pageBuilder.isEmpty()) {
            this.pages.add(this.pageBuilder.build());
            this.memoryUsageBytes += this.pageBuilder.getRetainedSizeInBytes();
            this.pageBuilder.reset();
        }
    }

    private boolean isLimitExhausted() {
        return this.limit.isPresent() && this.recordCount >= this.limit.getAsLong();
    }
}

