/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.Multimap;
import io.trino.Session;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.RemoteTask;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStatus;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;
import java.util.Set;

public class MemoryTrackingRemoteTaskFactory
implements RemoteTaskFactory {
    private final RemoteTaskFactory remoteTaskFactory;
    private final QueryStateMachine stateMachine;

    public MemoryTrackingRemoteTaskFactory(RemoteTaskFactory remoteTaskFactory, QueryStateMachine stateMachine) {
        this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
    }

    @Override
    public RemoteTask createRemoteTask(Session session, TaskId taskId, InternalNode node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker, Set<DynamicFilterId> outboundDynamicFilterIds, boolean summarizeTaskInfo) {
        RemoteTask task = this.remoteTaskFactory.createRemoteTask(session, taskId, node, fragment, initialSplits, outputBuffers, partitionedSplitCountTracker, outboundDynamicFilterIds, summarizeTaskInfo);
        task.addStateChangeListener(new UpdatePeakMemory(this.stateMachine));
        return task;
    }

    private static final class UpdatePeakMemory
    implements StateMachine.StateChangeListener<TaskStatus> {
        private final QueryStateMachine stateMachine;
        private long previousUserMemory;
        private long previousRevocableMemory;

        public UpdatePeakMemory(QueryStateMachine stateMachine) {
            this.stateMachine = stateMachine;
        }

        @Override
        public synchronized void stateChanged(TaskStatus newStatus) {
            long currentUserMemory = newStatus.getMemoryReservation().toBytes();
            long currentRevocableMemory = newStatus.getRevocableMemoryReservation().toBytes();
            long currentTotalMemory = currentUserMemory + currentRevocableMemory;
            long deltaUserMemoryInBytes = currentUserMemory - this.previousUserMemory;
            long deltaRevocableMemoryInBytes = currentRevocableMemory - this.previousRevocableMemory;
            long deltaTotalMemoryInBytes = currentTotalMemory - (this.previousUserMemory + this.previousRevocableMemory);
            this.previousUserMemory = currentUserMemory;
            this.previousRevocableMemory = currentRevocableMemory;
            this.stateMachine.updateMemoryUsage(deltaUserMemoryInBytes, deltaRevocableMemoryInBytes, deltaTotalMemoryInBytes, currentUserMemory, currentRevocableMemory, currentTotalMemory);
        }
    }
}

