/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.execution.StateMachine;
import io.trino.execution.buffer.BufferInfo;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBufferStateMachine;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PagesSerde;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.spi.exchange.ExchangeSink;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class SpoolingExchangeOutputBuffer
implements OutputBuffer {
    private static final Logger log = Logger.get(SpoolingExchangeOutputBuffer.class);
    private final OutputBufferStateMachine stateMachine;
    private final OutputBuffers outputBuffers;
    private final ExchangeSink exchangeSink;
    private final Supplier<LocalMemoryContext> memoryContextSupplier;
    private final AtomicLong peakMemoryUsage = new AtomicLong();
    private final AtomicLong totalPagesAdded = new AtomicLong();
    private final AtomicLong totalRowsAdded = new AtomicLong();

    public SpoolingExchangeOutputBuffer(OutputBufferStateMachine stateMachine, OutputBuffers outputBuffers, ExchangeSink exchangeSink, Supplier<LocalMemoryContext> memoryContextSupplier) {
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.outputBuffers = Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        Preconditions.checkArgument((outputBuffers.getType() == OutputBuffers.BufferType.SPOOL ? 1 : 0) != 0, (Object)"Expected a SPOOL output buffer");
        this.exchangeSink = Objects.requireNonNull(exchangeSink, "exchangeSink is null");
        this.memoryContextSupplier = Objects.requireNonNull(memoryContextSupplier, "memoryContextSupplier is null");
        stateMachine.noMoreBuffers();
    }

    @Override
    public OutputBufferInfo getInfo() {
        BufferState state = this.stateMachine.getState();
        return new OutputBufferInfo("EXTERNAL", state, false, state.canAddPages(), this.exchangeSink.getMemoryUsage(), this.totalPagesAdded.get(), this.totalRowsAdded.get(), this.totalPagesAdded.get(), (List<BufferInfo>)ImmutableList.of());
    }

    @Override
    public BufferState getState() {
        return this.stateMachine.getState();
    }

    @Override
    public double getUtilization() {
        return 0.0;
    }

    @Override
    public boolean isOverutilized() {
        return false;
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        if (this.stateMachine.getState().isTerminal() || this.outputBuffers.getVersion() >= newOutputBuffers.getVersion()) {
            return;
        }
        this.outputBuffers.checkValidTransition(newOutputBuffers);
    }

    @Override
    public ListenableFuture<BufferResult> get(OutputBuffers.OutputBufferId bufferId, long token, DataSize maxSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acknowledge(OutputBuffers.OutputBufferId bufferId, long token) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroy(OutputBuffers.OutputBufferId bufferId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenableFuture<Void> isFull() {
        return MoreFutures.asVoid((ListenableFuture)MoreFutures.toListenableFuture((CompletableFuture)this.exchangeSink.isBlocked()));
    }

    @Override
    public void enqueue(List<Slice> pages) {
        this.enqueue(0, pages);
    }

    @Override
    public void enqueue(int partition, List<Slice> pages) {
        Objects.requireNonNull(pages, "pages is null");
        if (!this.stateMachine.getState().canAddPages()) {
            return;
        }
        for (Slice page : pages) {
            this.exchangeSink.add(partition, page);
            this.totalRowsAdded.addAndGet(PagesSerde.getSerializedPagePositionCount(page));
        }
        this.updateMemoryUsage(this.exchangeSink.getMemoryUsage());
        this.totalPagesAdded.addAndGet(pages.size());
    }

    @Override
    public void setNoMorePages() {
        if (!this.stateMachine.noMorePages()) {
            return;
        }
        this.exchangeSink.finish().whenComplete((value, failure) -> {
            if (failure != null) {
                this.stateMachine.fail((Throwable)failure);
            } else {
                this.stateMachine.finish();
            }
            this.updateMemoryUsage(0L);
        });
    }

    @Override
    public void destroy() {
        this.abort();
    }

    @Override
    public void abort() {
        if (!this.stateMachine.abort()) {
            return;
        }
        this.exchangeSink.abort().whenComplete((value, failure) -> {
            if (failure != null) {
                log.warn(failure, "Error aborting exchange sink");
            }
            this.updateMemoryUsage(0L);
        });
    }

    @Override
    public long getPeakMemoryUsage() {
        return this.peakMemoryUsage.get();
    }

    @Override
    public Optional<Throwable> getFailureCause() {
        return this.stateMachine.getFailureCause();
    }

    private void updateMemoryUsage(long bytes) {
        LocalMemoryContext context = this.getSystemMemoryContextOrNull();
        if (context != null) {
            context.setBytes(bytes);
        }
        this.updatePeakMemoryUsage(bytes);
    }

    private void updatePeakMemoryUsage(long bytes) {
        long currentValue;
        do {
            if ((currentValue = this.peakMemoryUsage.get()) < bytes) continue;
            return;
        } while (!this.peakMemoryUsage.compareAndSet(currentValue, bytes));
    }

    private LocalMemoryContext getSystemMemoryContextOrNull() {
        try {
            return this.memoryContextSupplier.get();
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }
}

