/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.trino.execution.scheduler.NodeRequirements;
import io.trino.metadata.Split;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;

public class TaskDescriptor {
    private final int partitionId;
    private final Multimap<PlanNodeId, Split> splits;
    private final Multimap<PlanNodeId, ExchangeSourceHandle> exchangeSourceHandles;
    private final NodeRequirements nodeRequirements;

    public TaskDescriptor(int partitionId, Multimap<PlanNodeId, Split> splits, Multimap<PlanNodeId, ExchangeSourceHandle> exchangeSourceHandles, NodeRequirements nodeRequirements) {
        this.partitionId = partitionId;
        this.splits = ImmutableMultimap.copyOf(Objects.requireNonNull(splits, "splits is null"));
        this.exchangeSourceHandles = ImmutableMultimap.copyOf(Objects.requireNonNull(exchangeSourceHandles, "exchangeSourceHandles is null"));
        this.nodeRequirements = Objects.requireNonNull(nodeRequirements, "nodeRequirements is null");
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public Multimap<PlanNodeId, Split> getSplits() {
        return this.splits;
    }

    public Multimap<PlanNodeId, ExchangeSourceHandle> getExchangeSourceHandles() {
        return this.exchangeSourceHandles;
    }

    public NodeRequirements getNodeRequirements() {
        return this.nodeRequirements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDescriptor that = (TaskDescriptor)o;
        return this.partitionId == that.partitionId && Objects.equals(this.splits, that.splits) && Objects.equals(this.exchangeSourceHandles, that.exchangeSourceHandles) && Objects.equals(this.nodeRequirements, that.nodeRequirements);
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.splits, this.exchangeSourceHandles, this.nodeRequirements);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("splits", this.splits).add("exchangeSourceHandles", this.exchangeSourceHandles).add("nodeRequirements", (Object)this.nodeRequirements).toString();
    }
}

