/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogName;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.scheduler.NetworkLocation;
import io.trino.execution.scheduler.NodeMap;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.UniformNodeSelector;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.NodeState;
import io.trino.plugin.base.cache.NonEvictableCache;
import io.trino.plugin.base.cache.SafeCaches;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class UniformNodeSelectorFactory
implements NodeSelectorFactory {
    private static final Logger LOG = Logger.get(UniformNodeSelectorFactory.class);
    private final NonEvictableCache<InternalNode, Object> inaccessibleNodeLogCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS));
    private final InternalNodeManager nodeManager;
    private final int minCandidates;
    private final boolean includeCoordinator;
    private final long maxSplitsWeightPerNode;
    private final long maxPendingSplitsWeightPerTask;
    private final NodeSchedulerConfig.SplitsBalancingPolicy splitsBalancingPolicy;
    private final boolean optimizedLocalScheduling;
    private final NodeTaskMap nodeTaskMap;
    private final Duration nodeMapMemoizationDuration;

    @Inject
    public UniformNodeSelectorFactory(InternalNodeManager nodeManager, NodeSchedulerConfig config, NodeTaskMap nodeTaskMap) {
        this(nodeManager, config, nodeTaskMap, new Duration(5.0, TimeUnit.SECONDS));
    }

    @VisibleForTesting
    UniformNodeSelectorFactory(InternalNodeManager nodeManager, NodeSchedulerConfig config, NodeTaskMap nodeTaskMap, Duration nodeMapMemoizationDuration) {
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.nodeManager = nodeManager;
        this.minCandidates = config.getMinCandidates();
        this.includeCoordinator = config.isIncludeCoordinator();
        this.splitsBalancingPolicy = config.getSplitsBalancingPolicy();
        this.optimizedLocalScheduling = config.getOptimizedLocalScheduling();
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        int maxSplitsPerNode = config.getMaxSplitsPerNode();
        int maxPendingSplitsPerTask = config.getMaxPendingSplitsPerTask();
        Preconditions.checkArgument((maxSplitsPerNode >= maxPendingSplitsPerTask ? 1 : 0) != 0, (Object)"maxSplitsPerNode must be > maxPendingSplitsPerTask");
        this.maxSplitsWeightPerNode = SplitWeight.rawValueForStandardSplitCount((int)maxSplitsPerNode);
        this.maxPendingSplitsWeightPerTask = SplitWeight.rawValueForStandardSplitCount((int)maxPendingSplitsPerTask);
        this.nodeMapMemoizationDuration = nodeMapMemoizationDuration;
    }

    @Override
    public NodeSelector createNodeSelector(Session session, Optional<CatalogName> catalogName) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Supplier nodeMap = this.nodeMapMemoizationDuration.toMillis() > 0L ? Suppliers.memoizeWithExpiration(() -> this.createNodeMap(catalogName), (long)this.nodeMapMemoizationDuration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : () -> this.createNodeMap(catalogName);
        return new UniformNodeSelector(this.nodeManager, this.nodeTaskMap, this.includeCoordinator, (java.util.function.Supplier<NodeMap>)nodeMap, this.minCandidates, this.maxSplitsWeightPerNode, this.maxPendingSplitsWeightPerTask, SystemSessionProperties.getMaxUnacknowledgedSplitsPerTask(session), this.splitsBalancingPolicy, this.optimizedLocalScheduling);
    }

    private NodeMap createNodeMap(Optional<CatalogName> catalogName) {
        Set nodes = catalogName.map(this.nodeManager::getActiveConnectorNodes).orElseGet(() -> this.nodeManager.getNodes(NodeState.ACTIVE));
        Set coordinatorNodeIds = (Set)this.nodeManager.getCoordinators().stream().map(InternalNode::getNodeIdentifier).collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap.Builder byHostAndPort = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder byHost = ImmutableSetMultimap.builder();
        for (InternalNode node : nodes) {
            try {
                byHostAndPort.put((Object)node.getHostAndPort(), (Object)node);
                byHost.put((Object)node.getInternalAddress(), (Object)node);
            }
            catch (UnknownHostException e) {
                if (!this.markInaccessibleNode(node)) continue;
                LOG.warn((Throwable)e, "Unable to resolve host name for node: %s", new Object[]{node});
            }
        }
        return new NodeMap((SetMultimap<HostAddress, InternalNode>)byHostAndPort.build(), (SetMultimap<InetAddress, InternalNode>)byHost.build(), (SetMultimap<NetworkLocation, InternalNode>)ImmutableSetMultimap.of(), coordinatorNodeIds);
    }

    private boolean markInaccessibleNode(InternalNode node) {
        Object marker = new Object();
        try {
            return this.inaccessibleNodeLogCache.get((Object)node, () -> marker) == marker;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

