/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.PropertyUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.PlannerContext;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Property;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class AbstractCatalogPropertyManager {
    private final ConcurrentMap<CatalogName, Map<String, PropertyMetadata<?>>> connectorProperties = new ConcurrentHashMap();
    private final String propertyType;
    private final ErrorCodeSupplier propertyError;

    protected AbstractCatalogPropertyManager(String propertyType, ErrorCodeSupplier propertyError) {
        this.propertyType = propertyType;
        this.propertyError = Objects.requireNonNull(propertyError, "propertyError is null");
    }

    public void addProperties(CatalogName catalogName, List<PropertyMetadata<?>> properties) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(properties, "properties is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(properties, PropertyMetadata::getName);
        Preconditions.checkState((this.connectorProperties.putIfAbsent(catalogName, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"Properties for key %s are already registered", (Object)catalogName);
    }

    public void removeProperties(CatalogName catalogName) {
        this.connectorProperties.remove(catalogName);
    }

    public Map<String, Object> getProperties(CatalogName catalog, Iterable<Property> properties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters, boolean includeAllProperties) {
        Map<String, Optional<Object>> nullableValues = this.getNullableProperties(catalog, properties, session, plannerContext, accessControl, parameters, includeAllProperties);
        return (Map)nullableValues.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Optional)entry.getValue()).orElseThrow()));
    }

    public Map<String, Optional<Object>> getNullableProperties(CatalogName catalog, Iterable<Property> properties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters, boolean includeAllProperties) {
        Map propertyMetadata = (Map)this.connectorProperties.get(catalog);
        if (propertyMetadata == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Catalog '%s' %s property not found", catalog, this.propertyType));
        }
        return PropertyUtil.evaluateProperties(properties, session, plannerContext, accessControl, parameters, includeAllProperties, propertyMetadata, this.propertyError, String.format("catalog '%s' %s property", catalog, this.propertyType));
    }

    public Collection<PropertyMetadata<?>> getAllProperties(CatalogName catalogName) {
        return Optional.ofNullable((Map)this.connectorProperties.get(catalogName)).map(Map::values).orElse((Collection)ImmutableList.of());
    }
}

