/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.connector.CatalogName;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public final class TableExecuteHandle {
    private final CatalogName catalogName;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorTableExecuteHandle connectorHandle;

    @JsonCreator
    public TableExecuteHandle(@JsonProperty(value="catalogName") CatalogName catalogName, @JsonProperty(value="transactionHandle") ConnectorTransactionHandle transactionHandle, @JsonProperty(value="connectorHandle") ConnectorTableExecuteHandle connectorHandle) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
    }

    @JsonProperty
    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public ConnectorTransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }

    @JsonProperty
    public ConnectorTableExecuteHandle getConnectorHandle() {
        return this.connectorHandle;
    }

    public TableExecuteHandle withConnectorHandle(ConnectorTableExecuteHandle connectorHandle) {
        return new TableExecuteHandle(this.catalogName, this.transactionHandle, connectorHandle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableExecuteHandle o = (TableExecuteHandle)obj;
        return Objects.equals(this.catalogName, o.catalogName) && Objects.equals(this.transactionHandle, o.transactionHandle) && Objects.equals(this.connectorHandle, o.connectorHandle);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.transactionHandle, this.connectorHandle);
    }

    public String toString() {
        return "Execute[" + this.catalogName + ":" + this.connectorHandle + "]";
    }
}

