/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.aggregation.TypedSet;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DynamicFilterSourceOperator
implements Operator {
    private static final int EXPECTED_BLOCK_BUILDER_SIZE = 8;
    private final OperatorContext context;
    private boolean finished;
    private Page current;
    private final Consumer<TupleDomain<DynamicFilterId>> dynamicPredicateConsumer;
    private final int maxDistinctValues;
    private final long maxFilterSizeInBytes;
    private final List<Channel> channels;
    private final List<Integer> minMaxChannels;
    private final List<BlockTypeOperators.BlockPositionComparison> minMaxComparisons;
    @Nullable
    private BlockBuilder[] blockBuilders;
    @Nullable
    private TypedSet[] valueSets;
    private int minMaxCollectionLimit;
    @Nullable
    private Block[] minValues;
    @Nullable
    private Block[] maxValues;

    private DynamicFilterSourceOperator(OperatorContext context, Consumer<TupleDomain<DynamicFilterId>> dynamicPredicateConsumer, List<Channel> channels, PlanNodeId planNodeId, int maxDistinctValues, DataSize maxFilterSize, int minMaxCollectionLimit, BlockTypeOperators blockTypeOperators) {
        this.context = Objects.requireNonNull(context, "context is null");
        this.maxDistinctValues = maxDistinctValues;
        this.maxFilterSizeInBytes = maxFilterSize.toBytes();
        this.dynamicPredicateConsumer = Objects.requireNonNull(dynamicPredicateConsumer, "dynamicPredicateConsumer is null");
        this.channels = Objects.requireNonNull(channels, "channels is null");
        this.blockBuilders = new BlockBuilder[channels.size()];
        this.valueSets = new TypedSet[channels.size()];
        ImmutableList.Builder minMaxChannelsBuilder = ImmutableList.builder();
        ImmutableList.Builder minMaxComparisonsBuilder = ImmutableList.builder();
        for (int channelIndex = 0; channelIndex < channels.size(); ++channelIndex) {
            Type type = channels.get((int)channelIndex).type;
            if (minMaxCollectionLimit > 0 && type.isOrderable() && type != DoubleType.DOUBLE && type != RealType.REAL) {
                minMaxChannelsBuilder.add((Object)channelIndex);
                minMaxComparisonsBuilder.add((Object)blockTypeOperators.getComparisonUnorderedLastOperator(type));
            }
            this.blockBuilders[channelIndex] = type.createBlockBuilder(null, 8);
            this.valueSets[channelIndex] = TypedSet.createUnboundedEqualityTypedSet(type, blockTypeOperators.getEqualOperator(type), blockTypeOperators.getHashCodeOperator(type), this.blockBuilders[channelIndex], 8, String.format("DynamicFilterSourceOperator_%s_%d", planNodeId, channelIndex));
        }
        this.minMaxCollectionLimit = minMaxCollectionLimit;
        this.minMaxChannels = minMaxChannelsBuilder.build();
        if (!this.minMaxChannels.isEmpty()) {
            this.minValues = new Block[channels.size()];
            this.maxValues = new Block[channels.size()];
        }
        this.minMaxComparisons = minMaxComparisonsBuilder.build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.context;
    }

    @Override
    public boolean needsInput() {
        return this.current == null && !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Verify.verify((!this.finished ? 1 : 0) != 0, (String)"DynamicFilterSourceOperator: addInput() may not be called after finish()", (Object[])new Object[0]);
        this.current = page;
        if (this.valueSets == null) {
            if (this.minValues == null) {
                return;
            }
            this.minMaxCollectionLimit -= page.getPositionCount();
            if (this.minMaxCollectionLimit < 0) {
                this.handleMinMaxCollectionLimitExceeded();
                return;
            }
            for (int i = 0; i < this.minMaxChannels.size(); ++i) {
                Integer channelIndex = this.minMaxChannels.get(i);
                BlockTypeOperators.BlockPositionComparison comparison = this.minMaxComparisons.get(i);
                Block block = page.getBlock(this.channels.get((int)channelIndex.intValue()).index);
                this.updateMinMaxValues(block, channelIndex, comparison);
            }
            return;
        }
        this.minMaxCollectionLimit -= page.getPositionCount();
        long filterSizeInBytes = 0L;
        int filterMaxDistinctValues = 0;
        for (int channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
            Block block = page.getBlock(this.channels.get((int)channelIndex).index);
            TypedSet valueSet = this.valueSets[channelIndex];
            for (int position = 0; position < block.getPositionCount(); ++position) {
                valueSet.add(block, position);
            }
            filterSizeInBytes += valueSet.getRetainedSizeInBytes();
            filterMaxDistinctValues = Math.max(filterMaxDistinctValues, valueSet.size());
        }
        if (filterMaxDistinctValues > this.maxDistinctValues || filterSizeInBytes > this.maxFilterSizeInBytes) {
            this.handleTooLargePredicate();
        }
    }

    private void handleTooLargePredicate() {
        if (this.minMaxChannels.isEmpty()) {
            this.dynamicPredicateConsumer.accept((TupleDomain<DynamicFilterId>)TupleDomain.all());
        } else if (this.minMaxCollectionLimit < 0) {
            this.handleMinMaxCollectionLimitExceeded();
        } else {
            for (int i = 0; i < this.minMaxChannels.size(); ++i) {
                Integer channelIndex = this.minMaxChannels.get(i);
                BlockTypeOperators.BlockPositionComparison comparison = this.minMaxComparisons.get(i);
                Block block = this.blockBuilders[channelIndex].build();
                this.updateMinMaxValues(block, channelIndex, comparison);
            }
        }
        this.valueSets = null;
        this.blockBuilders = null;
    }

    private void handleMinMaxCollectionLimitExceeded() {
        this.dynamicPredicateConsumer.accept((TupleDomain<DynamicFilterId>)TupleDomain.all());
        this.minValues = null;
        this.maxValues = null;
    }

    private void updateMinMaxValues(Block block, int channelIndex, BlockTypeOperators.BlockPositionComparison comparison) {
        Preconditions.checkState((this.minValues != null && this.maxValues != null ? 1 : 0) != 0);
        int minValuePosition = -1;
        int maxValuePosition = -1;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            if (minValuePosition == -1) {
                minValuePosition = position;
                maxValuePosition = position;
                continue;
            }
            if (comparison.compare(block, position, block, minValuePosition) < 0L) {
                minValuePosition = position;
                continue;
            }
            if (comparison.compare(block, position, block, maxValuePosition) <= 0L) continue;
            maxValuePosition = position;
        }
        if (minValuePosition == -1) {
            return;
        }
        if (this.minValues[channelIndex] == null) {
            this.minValues[channelIndex] = block.getSingleValueBlock(minValuePosition);
            this.maxValues[channelIndex] = block.getSingleValueBlock(maxValuePosition);
            return;
        }
        Block currentMin = this.minValues[channelIndex];
        Block currentMax = this.maxValues[channelIndex];
        if (comparison.compare(block, minValuePosition, currentMin, 0) < 0L) {
            this.minValues[channelIndex] = block.getSingleValueBlock(minValuePosition);
        }
        if (comparison.compare(block, maxValuePosition, currentMax, 0) > 0L) {
            this.maxValues[channelIndex] = block.getSingleValueBlock(maxValuePosition);
        }
    }

    @Override
    public Page getOutput() {
        Page result = this.current;
        this.current = null;
        return result;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        ImmutableMap.Builder domainsBuilder = new ImmutableMap.Builder();
        if (this.valueSets == null) {
            if (this.minValues == null) {
                return;
            }
            for (Integer channelIndex : this.minMaxChannels) {
                Type type = this.channels.get((int)channelIndex.intValue()).type;
                if (this.minValues[channelIndex] == null) {
                    domainsBuilder.put((Object)this.channels.get((int)channelIndex.intValue()).filterId, (Object)Domain.none((Type)type));
                    continue;
                }
                Object min = TypeUtils.readNativeValue((Type)type, (Block)this.minValues[channelIndex], (int)0);
                Object max = TypeUtils.readNativeValue((Type)type, (Block)this.maxValues[channelIndex], (int)0);
                Domain domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true), (Range[])new Range[0]), (boolean)false);
                domainsBuilder.put((Object)this.channels.get((int)channelIndex.intValue()).filterId, (Object)domain);
            }
            this.minValues = null;
            this.maxValues = null;
            this.dynamicPredicateConsumer.accept((TupleDomain<DynamicFilterId>)TupleDomain.withColumnDomains((Map)domainsBuilder.buildOrThrow()));
            return;
        }
        for (int channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
            Block block = this.blockBuilders[channelIndex].build();
            Type type = this.channels.get((int)channelIndex).type;
            domainsBuilder.put((Object)this.channels.get((int)channelIndex).filterId, (Object)this.convertToDomain(type, block));
        }
        this.valueSets = null;
        this.blockBuilders = null;
        this.dynamicPredicateConsumer.accept((TupleDomain<DynamicFilterId>)TupleDomain.withColumnDomains((Map)domainsBuilder.buildOrThrow()));
    }

    private Domain convertToDomain(Type type, Block block) {
        ImmutableList.Builder values = ImmutableList.builder();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            Object value = TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
            if (value == null || TypeUtils.isFloatingPointNaN((Type)type, (Object)value)) continue;
            values.add(value);
        }
        return Domain.create((ValueSet)ValueSet.copyOf((Type)type, (Collection)values.build()), (boolean)false);
    }

    @Override
    public boolean isFinished() {
        return this.current == null && this.finished;
    }

    public static class DynamicFilterSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Consumer<TupleDomain<DynamicFilterId>> dynamicPredicateConsumer;
        private final List<Channel> channels;
        private final int maxDisinctValues;
        private final DataSize maxFilterSize;
        private final int minMaxCollectionLimit;
        private final BlockTypeOperators blockTypeOperators;
        private boolean closed;

        public DynamicFilterSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, Consumer<TupleDomain<DynamicFilterId>> dynamicPredicateConsumer, List<Channel> channels, int maxDisinctValues, DataSize maxFilterSize, int minMaxCollectionLimit, BlockTypeOperators blockTypeOperators) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.dynamicPredicateConsumer = Objects.requireNonNull(dynamicPredicateConsumer, "dynamicPredicateConsumer is null");
            this.channels = Objects.requireNonNull(channels, "channels is null");
            Verify.verify((channels.stream().map(channel -> channel.filterId).collect(Collectors.toSet()).size() == channels.size() ? 1 : 0) != 0, (String)"duplicate dynamic filters are not allowed", (Object[])new Object[0]);
            Verify.verify((channels.stream().map(channel -> channel.index).collect(Collectors.toSet()).size() == channels.size() ? 1 : 0) != 0, (String)"duplicate channel indices are not allowed", (Object[])new Object[0]);
            this.maxDisinctValues = maxDisinctValues;
            this.maxFilterSize = maxFilterSize;
            this.minMaxCollectionLimit = minMaxCollectionLimit;
            this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new DynamicFilterSourceOperator(driverContext.addOperatorContext(this.operatorId, this.planNodeId, DynamicFilterSourceOperator.class.getSimpleName()), this.dynamicPredicateConsumer, this.channels, this.planNodeId, this.maxDisinctValues, this.maxFilterSize, this.minMaxCollectionLimit, this.blockTypeOperators);
        }

        @Override
        public void noMoreOperators() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("duplicate() is not supported for DynamicFilterSourceOperatorFactory");
        }
    }

    public static class Channel {
        private final DynamicFilterId filterId;
        private final Type type;
        private final int index;

        public Channel(DynamicFilterId filterId, Type type, int index) {
            this.filterId = filterId;
            this.type = type;
            this.index = index;
        }
    }
}

