/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.trino.connector.CatalogName;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.TaskFailureListener;
import io.trino.execution.TaskId;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.metadata.Split;
import io.trino.operator.DirectExchangeClient;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorInfo;
import io.trino.operator.RetryPolicy;
import io.trino.operator.SourceOperator;
import io.trino.operator.SourceOperatorFactory;
import io.trino.operator.TaskContext;
import io.trino.spi.Page;
import io.trino.spi.connector.UpdatablePageSource;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.exchange.ExchangeSource;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.split.RemoteSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import java.io.Closeable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class ExchangeOperator
implements SourceOperator {
    public static final CatalogName REMOTE_CONNECTOR_ID = new CatalogName("$remote");
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final ExchangeDataSource exchangeDataSource;
    private final PagesSerde serde;
    private ListenableFuture<Void> isBlocked = NOT_BLOCKED;

    public ExchangeOperator(OperatorContext operatorContext, PlanNodeId sourceId, ExchangeDataSource exchangeDataSource, PagesSerde serde) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.exchangeDataSource = Objects.requireNonNull(exchangeDataSource, "exchangeDataSource is null");
        this.serde = Objects.requireNonNull(serde, "serde is null");
        operatorContext.setInfoSupplier(exchangeDataSource::getInfo);
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkArgument((boolean)split.getCatalogName().equals(REMOTE_CONNECTOR_ID), (Object)"split is not a remote split");
        this.exchangeDataSource.addSplit((RemoteSplit)split.getConnectorSplit());
        return Optional::empty;
    }

    @Override
    public void noMoreSplits() {
        this.exchangeDataSource.noMoreSplits();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public boolean isFinished() {
        return this.exchangeDataSource.isFinished();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.exchangeDataSource.isBlocked();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot take input");
    }

    @Override
    public Page getOutput() {
        Slice page = this.exchangeDataSource.pollPage();
        if (page == null) {
            return null;
        }
        Page deserializedPage = this.serde.deserialize(page);
        this.operatorContext.recordNetworkInput(page.length(), deserializedPage.getPositionCount());
        this.operatorContext.recordProcessedInput(deserializedPage.getSizeInBytes(), deserializedPage.getPositionCount());
        return deserializedPage;
    }

    @Override
    public void close() {
        this.exchangeDataSource.close();
    }

    private static class SpoolingExchangeDataSource
    implements ExchangeDataSource {
        private final ExchangeSource exchangeSource;
        private final List<ExchangeSourceHandle> exchangeSourceHandles;
        private final LocalMemoryContext systemMemoryContext;

        private SpoolingExchangeDataSource(ExchangeSource exchangeSource, List<ExchangeSourceHandle> exchangeSourceHandles, LocalMemoryContext systemMemoryContext) {
            this.exchangeSource = Objects.requireNonNull(exchangeSource, "exchangeSource is null");
            this.exchangeSourceHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(exchangeSourceHandles, "exchangeSourceHandles is null"));
            this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        }

        @Override
        public Slice pollPage() {
            Slice data = this.exchangeSource.read();
            this.systemMemoryContext.setBytes(this.exchangeSource.getMemoryUsage());
            return data;
        }

        @Override
        public boolean isFinished() {
            return this.exchangeSource.isFinished();
        }

        @Override
        public ListenableFuture<Void> isBlocked() {
            return MoreFutures.asVoid((ListenableFuture)MoreFutures.toListenableFuture((CompletableFuture)this.exchangeSource.isBlocked()));
        }

        @Override
        public void addSplit(RemoteSplit split) {
            RemoteSplit.SpoolingExchangeInput exchangeInput = (RemoteSplit.SpoolingExchangeInput)split.getExchangeInput();
            Preconditions.checkState((boolean)exchangeInput.getExchangeSourceHandles().equals(this.exchangeSourceHandles), (String)"split is expected to contain an identical exchangeSourceHandles list: %s != %s", exchangeInput.getExchangeSourceHandles(), this.exchangeSourceHandles);
        }

        @Override
        public void noMoreSplits() {
        }

        @Override
        public OperatorInfo getInfo() {
            return null;
        }

        @Override
        public void close() {
            this.exchangeSource.close();
        }
    }

    private static class DirectExchangeDataSource
    implements ExchangeDataSource {
        private final DirectExchangeClient directExchangeClient;

        private DirectExchangeDataSource(DirectExchangeClient directExchangeClient) {
            this.directExchangeClient = Objects.requireNonNull(directExchangeClient, "directExchangeClient is null");
        }

        @Override
        public Slice pollPage() {
            return this.directExchangeClient.pollPage();
        }

        @Override
        public boolean isFinished() {
            return this.directExchangeClient.isFinished();
        }

        @Override
        public ListenableFuture<Void> isBlocked() {
            return this.directExchangeClient.isBlocked();
        }

        @Override
        public void addSplit(RemoteSplit split) {
            RemoteSplit.DirectExchangeInput exchangeInput = (RemoteSplit.DirectExchangeInput)split.getExchangeInput();
            this.directExchangeClient.addLocation(exchangeInput.getTaskId(), URI.create(exchangeInput.getLocation()));
        }

        @Override
        public void noMoreSplits() {
            this.directExchangeClient.noMoreLocations();
        }

        @Override
        public OperatorInfo getInfo() {
            return this.directExchangeClient.getStatus();
        }

        @Override
        public void close() {
            this.directExchangeClient.close();
        }
    }

    private static class LazyExchangeDataSource
    implements ExchangeDataSource {
        private final TaskId taskId;
        private final PlanNodeId sourceId;
        private final DirectExchangeClientSupplier directExchangeClientSupplier;
        private final LocalMemoryContext systemMemoryContext;
        private final TaskFailureListener taskFailureListener;
        private final RetryPolicy retryPolicy;
        private final ExchangeManagerRegistry exchangeManagerRegistry;
        private final SettableFuture<Void> initializationFuture = SettableFuture.create();
        private final AtomicReference<ExchangeDataSource> delegate = new AtomicReference();
        private final AtomicBoolean closed = new AtomicBoolean();

        private LazyExchangeDataSource(TaskId taskId, PlanNodeId sourceId, DirectExchangeClientSupplier directExchangeClientSupplier, LocalMemoryContext systemMemoryContext, TaskFailureListener taskFailureListener, RetryPolicy retryPolicy, ExchangeManagerRegistry exchangeManagerRegistry) {
            this.taskId = Objects.requireNonNull(taskId, "taskId is null");
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.directExchangeClientSupplier = Objects.requireNonNull(directExchangeClientSupplier, "directExchangeClientSupplier is null");
            this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
            this.taskFailureListener = Objects.requireNonNull(taskFailureListener, "taskFailureListener is null");
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
            this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
        }

        @Override
        public Slice pollPage() {
            ExchangeDataSource dataSource = this.delegate.get();
            if (dataSource == null) {
                return null;
            }
            return dataSource.pollPage();
        }

        @Override
        public boolean isFinished() {
            if (this.closed.get()) {
                return true;
            }
            ExchangeDataSource dataSource = this.delegate.get();
            if (dataSource == null) {
                return false;
            }
            return dataSource.isFinished();
        }

        @Override
        public ListenableFuture<Void> isBlocked() {
            if (this.closed.get()) {
                return Futures.immediateVoidFuture();
            }
            if (!this.initializationFuture.isDone()) {
                return this.initializationFuture;
            }
            ExchangeDataSource dataSource = this.delegate.get();
            Preconditions.checkState((dataSource != null ? 1 : 0) != 0, (Object)"dataSource is expected to be initialized");
            return dataSource.isBlocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSplit(RemoteSplit split) {
            boolean initialized = false;
            LazyExchangeDataSource lazyExchangeDataSource = this;
            synchronized (lazyExchangeDataSource) {
                if (this.closed.get()) {
                    return;
                }
                ExchangeDataSource dataSource = this.delegate.get();
                if (dataSource == null) {
                    if (split.getExchangeInput() instanceof RemoteSplit.DirectExchangeInput) {
                        DirectExchangeClient client = this.directExchangeClientSupplier.get(this.taskId.getQueryId(), new ExchangeId(String.format("direct-exchange-%s-%s", this.taskId.getStageId().getId(), this.sourceId)), this.systemMemoryContext, this.taskFailureListener, this.retryPolicy);
                        dataSource = new DirectExchangeDataSource(client);
                    } else if (split.getExchangeInput() instanceof RemoteSplit.SpoolingExchangeInput) {
                        RemoteSplit.SpoolingExchangeInput input = (RemoteSplit.SpoolingExchangeInput)split.getExchangeInput();
                        ExchangeManager exchangeManager = this.exchangeManagerRegistry.getExchangeManager();
                        List<ExchangeSourceHandle> sourceHandles = input.getExchangeSourceHandles();
                        ExchangeSource exchangeSource = exchangeManager.createSource(sourceHandles);
                        dataSource = new SpoolingExchangeDataSource(exchangeSource, sourceHandles, this.systemMemoryContext);
                    } else {
                        throw new IllegalArgumentException("Unexpected split: " + split);
                    }
                    this.delegate.set(dataSource);
                    initialized = true;
                }
                dataSource.addSplit(split);
            }
            if (initialized) {
                this.initializationFuture.set(null);
            }
        }

        @Override
        public synchronized void noMoreSplits() {
            if (this.closed.get()) {
                return;
            }
            ExchangeDataSource dataSource = this.delegate.get();
            if (dataSource != null) {
                dataSource.noMoreSplits();
            } else {
                this.close();
            }
        }

        @Override
        public OperatorInfo getInfo() {
            ExchangeDataSource dataSource = this.delegate.get();
            if (dataSource == null) {
                return null;
            }
            return dataSource.getInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            LazyExchangeDataSource lazyExchangeDataSource = this;
            synchronized (lazyExchangeDataSource) {
                if (!this.closed.compareAndSet(false, true)) {
                    return;
                }
                ExchangeDataSource dataSource = this.delegate.get();
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            this.initializationFuture.set(null);
        }
    }

    private static interface ExchangeDataSource
    extends Closeable {
        public Slice pollPage();

        public boolean isFinished();

        public ListenableFuture<Void> isBlocked();

        public void addSplit(RemoteSplit var1);

        public void noMoreSplits();

        public OperatorInfo getInfo();

        @Override
        public void close();
    }

    public static class ExchangeOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final DirectExchangeClientSupplier directExchangeClientSupplier;
        private final PagesSerdeFactory serdeFactory;
        private final RetryPolicy retryPolicy;
        private final ExchangeManagerRegistry exchangeManagerRegistry;
        private ExchangeDataSource exchangeDataSource;
        private boolean closed;

        public ExchangeOperatorFactory(int operatorId, PlanNodeId sourceId, DirectExchangeClientSupplier directExchangeClientSupplier, PagesSerdeFactory serdeFactory, RetryPolicy retryPolicy, ExchangeManagerRegistry exchangeManagerRegistry) {
            this.operatorId = operatorId;
            this.sourceId = sourceId;
            this.directExchangeClientSupplier = directExchangeClientSupplier;
            this.serdeFactory = serdeFactory;
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
            this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            TaskContext taskContext = driverContext.getPipelineContext().getTaskContext();
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, ExchangeOperator.class.getSimpleName());
            LocalMemoryContext memoryContext = driverContext.getPipelineContext().localMemoryContext();
            if (this.exchangeDataSource == null) {
                this.exchangeDataSource = new LazyExchangeDataSource(taskContext.getTaskId(), this.sourceId, this.directExchangeClientSupplier, memoryContext, taskContext::sourceTaskFailed, this.retryPolicy, this.exchangeManagerRegistry);
            }
            return new ExchangeOperator(operatorContext, this.sourceId, this.exchangeDataSource, this.serdeFactory.createPagesSerde());
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

