/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.PagesIndex;
import io.trino.operator.aggregation.Accumulator;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.GroupedAccumulator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OrderedAccumulatorFactory
implements AccumulatorFactory {
    private final AccumulatorFactory delegate;
    private final List<Type> sourceTypes;
    private final List<Integer> argumentChannels;
    private final List<Integer> orderByChannels;
    private final List<SortOrder> orderings;
    private final PagesIndex.Factory pagesIndexFactory;

    public OrderedAccumulatorFactory(AccumulatorFactory delegate, List<Type> sourceTypes, List<Integer> argumentChannels, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
        this.argumentChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentChannels, "argumentChannels is null"));
        this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
        this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
        Preconditions.checkArgument((!orderByChannels.isEmpty() ? 1 : 0) != 0, (Object)"Order by channels is empty");
        this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
    }

    @Override
    public Accumulator createAccumulator() {
        Accumulator accumulator = this.delegate.createAccumulator();
        return new OrderedAccumulator(accumulator, this.sourceTypes, this.argumentChannels, this.orderByChannels, this.orderings, this.pagesIndexFactory);
    }

    @Override
    public Accumulator createIntermediateAccumulator() {
        return this.delegate.createIntermediateAccumulator();
    }

    @Override
    public GroupedAccumulator createGroupedAccumulator() {
        GroupedAccumulator accumulator = this.delegate.createGroupedAccumulator();
        return new OrderingGroupedAccumulator(accumulator, this.sourceTypes, this.argumentChannels, this.orderByChannels, this.orderings, this.pagesIndexFactory);
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAccumulator() {
        return this.delegate.createGroupedIntermediateAccumulator();
    }

    private static Page filter(Page page, Block mask) {
        int[] ids = new int[mask.getPositionCount()];
        int next = 0;
        for (int i = 0; i < page.getPositionCount(); ++i) {
            if (!BooleanType.BOOLEAN.getBoolean(mask, i)) continue;
            ids[next++] = i;
        }
        return page.getPositions(ids, 0, next);
    }

    private static class OrderingGroupedAccumulator
    implements GroupedAccumulator {
        private final GroupedAccumulator accumulator;
        private final int[] argumentChannels;
        private final List<Integer> orderByChannels;
        private final List<SortOrder> orderings;
        private final PagesIndex pagesIndex;
        private long groupCount;

        private OrderingGroupedAccumulator(GroupedAccumulator accumulator, List<Type> aggregationSourceTypes, List<Integer> argumentChannels, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.argumentChannels = Ints.toArray(argumentChannels);
            Objects.requireNonNull(aggregationSourceTypes, "aggregationSourceTypes is null");
            this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
            this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
            ArrayList<Type> pageIndexTypes = new ArrayList<Type>(aggregationSourceTypes);
            pageIndexTypes.add((Type)BigintType.BIGINT);
            this.pagesIndex = pagesIndexFactory.newPagesIndex(pageIndexTypes, 10000);
            this.groupCount = 0L;
        }

        @Override
        public long getEstimatedSize() {
            return this.pagesIndex.getEstimatedSize().toBytes() + this.accumulator.getEstimatedSize();
        }

        @Override
        public void addInput(GroupByIdBlock groupIdsBlock, Page page, Optional<Block> mask) {
            this.groupCount = Long.max(this.groupCount, groupIdsBlock.getGroupCount());
            page = page.appendColumn((Block)groupIdsBlock);
            if (mask.isPresent()) {
                page = OrderedAccumulatorFactory.filter(page, mask.orElseThrow());
            }
            this.pagesIndex.addPage(page);
        }

        @Override
        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.accumulator.evaluateFinal(groupId, output);
        }

        @Override
        public void prepareFinal() {
            this.pagesIndex.sort(this.orderByChannels, this.orderings);
            Iterator<Page> pagesIterator = this.pagesIndex.getSortedPages();
            pagesIterator.forEachRemaining(page -> this.accumulator.addInput(new GroupByIdBlock(this.groupCount, page.getBlock(page.getChannelCount() - 1)), page.getColumns(this.argumentChannels), Optional.empty()));
        }
    }

    private static class OrderedAccumulator
    implements Accumulator {
        private final Accumulator accumulator;
        private final int[] argumentChannels;
        private final List<Integer> orderByChannels;
        private final List<SortOrder> orderings;
        private final PagesIndex pagesIndex;

        private OrderedAccumulator(Accumulator accumulator, List<Type> aggregationSourceTypes, List<Integer> argumentChannels, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.argumentChannels = Ints.toArray(argumentChannels);
            this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
            this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
            this.pagesIndex = pagesIndexFactory.newPagesIndex(aggregationSourceTypes, 10000);
        }

        @Override
        public long getEstimatedSize() {
            return this.pagesIndex.getEstimatedSize().toBytes() + this.accumulator.getEstimatedSize();
        }

        @Override
        public Accumulator copy() {
            throw new UnsupportedOperationException("Ordered aggregation function state can not be copied");
        }

        @Override
        public void addInput(Page page, Optional<Block> mask) {
            if (mask.isPresent()) {
                page = OrderedAccumulatorFactory.filter(page, mask.orElseThrow());
            }
            this.pagesIndex.addPage(page);
        }

        @Override
        public void addIntermediate(Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(BlockBuilder blockBuilder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(BlockBuilder blockBuilder) {
            this.pagesIndex.sort(this.orderByChannels, this.orderings);
            Iterator<Page> pagesIterator = this.pagesIndex.getSortedPages();
            pagesIterator.forEachRemaining(arguments -> this.accumulator.addInput(arguments.getColumns(this.argumentChannels), Optional.empty()));
            this.accumulator.evaluateFinal(blockBuilder);
        }
    }
}

