/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.SessionContext;
import io.trino.server.SessionSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.security.Identity;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.SqlPath;
import io.trino.transaction.TransactionManager;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class QuerySessionSupplier
implements SessionSupplier {
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;
    private final Optional<String> defaultPath;
    private final Optional<TimeZoneKey> forcedSessionTimeZone;
    private final Optional<String> defaultCatalog;
    private final Optional<String> defaultSchema;

    @Inject
    public QuerySessionSupplier(TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, SqlEnvironmentConfig config) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        Objects.requireNonNull(config, "config is null");
        this.defaultPath = Objects.requireNonNull(config.getPath(), "path is null");
        this.forcedSessionTimeZone = Objects.requireNonNull(config.getForcedSessionTimeZone(), "forcedSessionTimeZone is null");
        this.defaultCatalog = Objects.requireNonNull(config.getDefaultCatalog(), "defaultCatalog is null");
        this.defaultSchema = Objects.requireNonNull(config.getDefaultSchema(), "defaultSchema is null");
        Preconditions.checkArgument((this.defaultCatalog.isPresent() || this.defaultSchema.isEmpty() ? 1 : 0) != 0, (Object)"Default schema cannot be set if catalog is not set");
    }

    @Override
    public Session createSession(QueryId queryId, SessionContext context) {
        Identity authenticatedIdentity;
        Identity identity = context.getIdentity();
        this.accessControl.checkCanSetUser(identity.getPrincipal(), identity.getUser());
        if (context.getAuthenticatedIdentity().isPresent() && !(authenticatedIdentity = context.getAuthenticatedIdentity().get()).getUser().equals(identity.getUser())) {
            authenticatedIdentity = HttpRequestSessionContextFactory.addEnabledRoles(authenticatedIdentity, context.getSelectedRole(), this.metadata);
            this.accessControl.checkCanImpersonateUser(authenticatedIdentity, identity.getUser());
        }
        identity = HttpRequestSessionContextFactory.addEnabledRoles(identity, context.getSelectedRole(), this.metadata);
        Session.SessionBuilder sessionBuilder = Session.builder(this.sessionPropertyManager).setQueryId(queryId).setIdentity(identity).setPath(context.getPath().or(() -> this.defaultPath).map(SqlPath::new)).setSource(context.getSource()).setRemoteUserAddress(context.getRemoteUserAddress()).setUserAgent(context.getUserAgent()).setClientInfo(context.getClientInfo()).setClientTags(context.getClientTags()).setClientCapabilities(context.getClientCapabilities()).setTraceToken(context.getTraceToken()).setResourceEstimates(context.getResourceEstimates()).setProtocolHeaders(context.getProtocolHeaders());
        if (context.getCatalog().isPresent()) {
            sessionBuilder.setCatalog(context.getCatalog());
            sessionBuilder.setSchema(context.getSchema());
        } else {
            this.defaultCatalog.ifPresent(sessionBuilder::setCatalog);
            this.defaultSchema.ifPresent(sessionBuilder::setSchema);
        }
        if (this.forcedSessionTimeZone.isPresent()) {
            sessionBuilder.setTimeZoneKey(this.forcedSessionTimeZone.get());
        } else {
            String sessionTimeZoneId = context.getSystemProperties().get("time_zone_id");
            if (sessionTimeZoneId != null) {
                sessionBuilder.setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionTimeZoneId));
            } else {
                sessionBuilder.setTimeZoneKey(context.getTimeZoneId().map(TimeZoneKey::getTimeZoneKey));
            }
        }
        context.getLanguage().ifPresent(s -> sessionBuilder.setLocale(Locale.forLanguageTag(s)));
        for (Map.Entry entry : context.getSystemProperties().entrySet()) {
            sessionBuilder.setSystemProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<String, Map<String, String>> entry : context.getCatalogSessionProperties().entrySet()) {
            String catalog = entry.getKey();
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                sessionBuilder.setCatalogSessionProperty(catalog, entry2.getKey(), entry2.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : context.getPreparedStatements().entrySet()) {
            sessionBuilder.addPreparedStatement(entry.getKey(), (String)entry.getValue());
        }
        if (context.supportClientTransaction()) {
            sessionBuilder.setClientTransactionSupport();
        }
        Session session = sessionBuilder.build();
        if (context.getTransactionId().isPresent()) {
            session = session.beginTransactionId(context.getTransactionId().get(), this.transactionManager, this.accessControl);
        }
        return session;
    }
}

