/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.trino.server.ForStartup;
import io.trino.server.PluginManager;
import io.trino.server.ServerPluginsProviderConfig;
import io.trino.util.Executors;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class ServerPluginsProvider
implements PluginManager.PluginsProvider {
    private final File installedPluginsDir;
    private final Executor executor;

    @Inject
    public ServerPluginsProvider(ServerPluginsProviderConfig config, @ForStartup Executor executor) {
        this.installedPluginsDir = config.getInstalledPluginsDir();
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    @Override
    public void loadPlugins(PluginManager.PluginsProvider.Loader loader, PluginManager.PluginsProvider.ClassLoaderFactory createClassLoader) {
        Executors.executeUntilFailure(this.executor, (Collection)ServerPluginsProvider.listFiles(this.installedPluginsDir).stream().filter(File::isDirectory).map(file -> () -> {
            loader.load(file.getAbsolutePath(), () -> createClassLoader.create(file.getName(), ServerPluginsProvider.buildClassPath(file)));
            return null;
        }).collect(ImmutableList.toImmutableList()));
    }

    private static List<URL> buildClassPath(File path) {
        return (List)ServerPluginsProvider.listFiles(path).stream().map(ServerPluginsProvider::fileToUrl).collect(ImmutableList.toImmutableList());
    }

    private static List<File> listFiles(File path) {
        List list;
        block8: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path.toPath());
            try {
                list = (List)Streams.stream(directoryStream).map(Path::toFile).sorted().collect(ImmutableList.toImmutableList());
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            directoryStream.close();
        }
        return list;
    }

    private static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }
}

