/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.testing.exchange;

import com.google.common.collect.ImmutableList;
import io.trino.server.testing.exchange.LocalFileSystemExchange;
import io.trino.server.testing.exchange.LocalFileSystemExchangeSink;
import io.trino.server.testing.exchange.LocalFileSystemExchangeSinkInstanceHandle;
import io.trino.server.testing.exchange.LocalFileSystemExchangeSource;
import io.trino.server.testing.exchange.LocalFileSystemExchangeSourceHandle;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeContext;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.exchange.ExchangeSink;
import io.trino.spi.exchange.ExchangeSinkInstanceHandle;
import io.trino.spi.exchange.ExchangeSource;
import io.trino.spi.exchange.ExchangeSourceHandle;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;

public class LocalFileSystemExchangeManager
implements ExchangeManager {
    private final Path baseDirectory;

    public LocalFileSystemExchangeManager(Path baseDirectory) {
        this.baseDirectory = Objects.requireNonNull(baseDirectory, "baseDirectory is null");
    }

    public Exchange createExchange(ExchangeContext context, int outputPartitionCount) {
        LocalFileSystemExchange exchange = new LocalFileSystemExchange(this.baseDirectory, context, outputPartitionCount);
        exchange.initialize();
        return exchange;
    }

    public ExchangeSink createSink(ExchangeSinkInstanceHandle handle, boolean preserveRecordsOrder) {
        LocalFileSystemExchangeSinkInstanceHandle localHandle = (LocalFileSystemExchangeSinkInstanceHandle)handle;
        Path outputDirectory = localHandle.getOutputDirectory();
        try {
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new LocalFileSystemExchangeSink(outputDirectory, localHandle.getOutputPartitionCount());
    }

    public ExchangeSource createSource(List<ExchangeSourceHandle> handles) {
        List files = (List)handles.stream().map(LocalFileSystemExchangeSourceHandle.class::cast).flatMap(handle -> handle.getFiles().stream()).map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList());
        return new LocalFileSystemExchangeSource(files);
    }
}

