/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.testing.exchange;

import io.trino.server.testing.exchange.LocalFileSystemExchangeManager;
import io.trino.server.testing.exchange.LocalFileSystemExchangeSinkInstanceHandle;
import io.trino.server.testing.exchange.LocalFileSystemExchangeSourceHandle;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.exchange.ExchangeManagerFactory;
import io.trino.spi.exchange.ExchangeManagerHandleResolver;
import io.trino.spi.exchange.ExchangeSinkInstanceHandle;
import io.trino.spi.exchange.ExchangeSourceHandle;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class LocalFileSystemExchangeManagerFactory
implements ExchangeManagerFactory {
    private static final String BASE_DIRECTORY_PROPERTY = "base-directory";

    public String getName() {
        return "local";
    }

    public ExchangeManager create(Map<String, String> config) {
        Path baseDirectory;
        String configuredBaseDirectory = config.get(BASE_DIRECTORY_PROPERTY);
        if (configuredBaseDirectory != null) {
            baseDirectory = Paths.get(configuredBaseDirectory, new String[0]);
        } else {
            try {
                baseDirectory = Files.createTempDirectory("exchange-manager-", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new LocalFileSystemExchangeManager(baseDirectory);
    }

    public ExchangeManagerHandleResolver getHandleResolver() {
        return new ExchangeManagerHandleResolver(){

            public Class<? extends ExchangeSinkInstanceHandle> getExchangeSinkInstanceHandleClass() {
                return LocalFileSystemExchangeSinkInstanceHandle.class;
            }

            public Class<? extends ExchangeSourceHandle> getExchangeSourceHandleHandleClass() {
                return LocalFileSystemExchangeSourceHandle.class;
            }
        };
    }
}

