/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.testing.exchange;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.QueryId;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.exchange.ExchangeSinkHandle;
import java.util.Objects;

public class LocalFileSystemExchangeSinkHandle
implements ExchangeSinkHandle {
    private final QueryId queryId;
    private final ExchangeId exchangeId;
    private final int taskPartitionId;

    @JsonCreator
    public LocalFileSystemExchangeSinkHandle(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="exchangeId") ExchangeId exchangeId, @JsonProperty(value="taskPartitionId") int taskPartitionId) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.exchangeId = Objects.requireNonNull(exchangeId, "exchangeId is null");
        this.taskPartitionId = taskPartitionId;
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public ExchangeId getExchangeId() {
        return this.exchangeId;
    }

    @JsonProperty
    public int getTaskPartitionId() {
        return this.taskPartitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFileSystemExchangeSinkHandle that = (LocalFileSystemExchangeSinkHandle)o;
        return this.taskPartitionId == that.taskPartitionId && Objects.equals(this.queryId, that.queryId) && Objects.equals(this.exchangeId, that.exchangeId);
    }

    public int hashCode() {
        return Objects.hash(this.queryId, this.exchangeId, this.taskPartitionId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("exchangeId", (Object)this.exchangeId).add("taskPartitionId", this.taskPartitionId).toString();
    }
}

