/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.testing.exchange;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.exchange.ExchangeSourceHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class LocalFileSystemExchangeSourceHandle
implements ExchangeSourceHandle {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LocalFileSystemExchangeSourceHandle.class).instanceSize();
    private final int partitionId;
    private final List<String> files;

    @JsonCreator
    public LocalFileSystemExchangeSourceHandle(@JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="files") List<String> files) {
        this.partitionId = partitionId;
        this.files = ImmutableList.copyOf((Collection)Objects.requireNonNull(files, "files is null"));
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty
    public List<String> getFiles() {
        return this.files;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.files, SizeOf::estimatedSizeOf);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFileSystemExchangeSourceHandle that = (LocalFileSystemExchangeSourceHandle)o;
        return this.partitionId == that.partitionId && Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.files);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("files", this.files).toString();
    }
}

